/*  load_input.c */

/* 	Copyright 2004-2005 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int load_input(float *input_buffer, int num_elem_input, const char * filename)
{
	int k;
	FILE * file_pointer;

	if( (file_pointer = fopen(filename,"r")) == NULL)
	{
		return(1);
	}

	k = 0;
	while (1)
	{
		fgets(char_buffer,BUFFSIZE,file_pointer);
		if ( (strncmp(char_buffer,"\n",1)) && !(feof(file_pointer)) )
		{
			if (k < num_elem_input)
			{
				input_buffer[k] = atof(char_buffer);
				k += 1;
			}
			else 
			{
				fclose(file_pointer);
				return(2);							//Too many inputs
			}
		}
		else if (feof(file_pointer))
		{
			if (k == num_elem_input) //everything is fine
			{
				fclose(file_pointer);
				return(0);
			}
			else
			{
				fclose(file_pointer);	//Not enough inputs
				return(3);
			}
		}
	}
}
