/*  nn_agr.c */
/* 	Copyright 2004-2005 Oswaldo Morizaki Hirakata */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*
type defines old_init1 / num_output_add

type = 0: num_output_add (output aggregation)
type = 1: old_init1 (neural net aggregation)

Neural network type is defined by old_init2 (the receptor)
*/

#define INIT_FILE 		conf.init_filename
#define DIMENSION 		conf.dimension
#define TYPE 					conf.type
#define MOMENTUM 			conf.momentum
#define ALPHA 				conf.alpha
#define CONV_RATE 		conf.conv_rate
#define BIAS_CORR 		conf.bias_corr
#define DELTA_TYPE 		conf.delta_type
#define DELTA_INF 		conf.delta_inf
#define DELTA_DISP 		conf.delta_disp
#define BIAS 					conf.bias
#define DECAYMENT			conf.decayment
#define NUM_OUTPUT_ADD		conf.output_add
#define NUM_INPUT_ADD			conf.input_add
#define OLD_INIT1			conf.old_init1
#define OLD_INIT2			conf.old_init2
#define MODE					conf.mode

int main(int argc, char * argv[])
{
int k,l,m,n,o,p;
int agr_type;			
int type;
int num_neuron_add;
int num_output_add;
int num_input_add;
int old_num_output;
int old_num_input;
int dimension;
int momentum;

float temp;
	
struct nn_init_config conf;
struct neural_net * net;
struct neural_net * append_net;

if (argc < 2)
{
	printf("Wrong number of arguments\nUsage: %s init=init mode=# ",argv[0]);
	printf("dimension=# momentum=# alpha=# conv_rate=# bias_corr=# ");
	printf("delta_type=# delta_inf=# delta_disp=# decayment=# ");
	printf("bias=# output_add=# old_init1=old_init1 old_init2=old_init2\n");
	printf("Append happens over old_init2\n");
	exit(1);
}

openlog("nn_agr",LOG_PID,LOG_LOCAL3);

load_nn_init_config(0,char_buffer, &conf); //mode 0 = reset

for (k=1; k< argc; k++)
{
	l = load_nn_init_config(2,argv[k], &conf); //mode 2 = aggregation
	if (l == 10)
	{
		agr_type = 0;		//output aggregation
	}
	else if (l == 11)
	{
		agr_type = 1;		//input aggregation
	}
	else if (l == 20)
	{
		agr_type = 10;		//neural net aggregation
	}
}

if (agr_type < 10)
{
	if (!strncmp(conf.old_init2,"NULL",4))
	{
		printf("old_init2 required, exiting\n");
		exit(1);
	}
}
else if (agr_type == 10)
{
	if (!strncmp(conf.old_init2,"NULL",4))
	{
		printf("old_init2 required, exiting\n");
		exit(1);
	}
	else if (!strncmp(conf.old_init1,"NULL",4))
	{
		printf("old_init1 required, exiting\n");
		exit(1);
	}
}

net = NULL;
append_net = NULL;

if (!(net = (struct neural_net *)fread_neural_net(net,OLD_INIT2) ))
{
	syslog(LOG_CRIT,"Error in fread_neural_net(net,%s)",OLD_INIT2);
	exit(1);
}

old_num_input = net->num_input;
old_num_output = net->num_output;
dimension = net->dimension;
num_neuron_add = 0;

/* Aggregation of more outputs */
if (agr_type == 0)
{
/****************************************************/
	num_output_add = atoi(NUM_OUTPUT_ADD);
	
	temp = (float)net->num_neuron /net->num_output;
	
	k= (int)temp;
	
	num_neuron_add = dice_toss(k,k);
	
	num_neuron_add += num_output_add;
	
	if ( !(append_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net");
		exit(1);
	}
	if ( !(append_net->neuron_array = (struct neuron **)calloc(1,sizeof(struct neuron)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
		exit(1);
	}
	append_net->num_neuron = 1;
	append_net->type = net->type;
	append_net->dimension = net->dimension;

		
	/* Append output neurons to net */
	for (k=0; k< num_neuron_add; k++)
	{
		if (!strncmp("rr",MOMENTUM,2))
		{
			momentum = dice_toss(k,MAX_MOMENTUM);
		}
		else 
		{
			momentum = atoi(MOMENTUM);
		}
		if ( !(append_net->neuron_array[0] = (struct neuron *)calloc_neuron(
				net->dimension,momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
			exit(1);
		}
		append_net->neuron_array[0]->momentum = momentum;
		
		if (k < num_output_add)
		{
			append_net->neuron_array[0]->x_c[0] = 1.0;
			append_net->neuron_array[0]->range[0] = rand_gen(k) / 2;
			append_net->neuron_array[0]->block = 13;		//upper
		}
		else
		{
			l = dice_toss(k,(net->num_neuron - net->num_input - net->num_output) );
			temp = net->neuron_array[l + net->num_input]->x_c[0];
			append_net->neuron_array[0]->x_c[0] = temp; //set coordinates
			append_net->neuron_array[0]->range[0] = (temp > 0.5) ? (rand_gen(l) / 2) : 
																				( temp*rand_gen(l) ) ; //set range
			append_net->neuron_array[0]->block = 11;		//inner
		}

		for (l= 1; l< dimension; l++)
		{
			temp = rand_gen(l);
			append_net->neuron_array[0]->x_c[l] = temp; //set coordinates
			append_net->neuron_array[0]->range[l] = (temp > 0.5) ? (rand_gen(l) / 2) : 
																				( temp*rand_gen(l) ) ; //set range
		}

		for (l= 0; l< append_net->neuron_array[0]->momentum; l++) //alpha
		{
			if ( strncmp(ALPHA,"rr",2) )
			{
				temp = rand_gen(l)*atof(ALPHA);
			}
			else
			{
				temp = rand_gen(l);
			}
			append_net->neuron_array[0]->alpha[l] = temp;
		}
		
		if ( strncmp(CONV_RATE,"rr",2) ) //set conv_rate
		{
			temp = atof(CONV_RATE);
		}
		else
		{
			temp = rand_gen(k);
		}
		append_net->neuron_array[0]->conv_rate = temp;
		
		if ( strncmp(BIAS_CORR,"rr",2) ) //set bias_corr
		{
			l = atoi(BIAS_CORR);
		}
		else
		{
			l = coin_toss(k);
		}
		append_net->neuron_array[0]->bias_corr = l;

		if ( strncmp(DELTA_TYPE,"rr",2) ) //set delta_type
		{
			l = atoi(DELTA_TYPE);
		}
		else
		{
			l = dice_toss(k,NUM_TYPE);
		}
		append_net->neuron_array[0]->delta_type = l;
		
		if ( strncmp(DELTA_INF,"rr",2) ) //set delta_inf
		{
			temp = atof(DELTA_INF);
		}
		else
		{
			temp = MAX_DELTA_DISP*rand_gen(k);
		}
		append_net->neuron_array[0]->delta_inf = temp;

		if ( strncmp(DELTA_DISP,"rr",2) ) //set delta_disp
		{
			temp = atof(DELTA_DISP);
		}
		else
		{
			temp = MAX_DELTA_DISP*rand_gen(k);
		}
		append_net->neuron_array[0]->delta_disp = temp;

		if ( strncmp(BIAS,"rr",2) ) //set bias
		{
			temp = atof(BIAS);
		}
		else
		{
			temp = rand_gen(k);
		}
		append_net->neuron_array[0]->bias = temp;
		
		if ( strncmp(DECAYMENT,"rr",2) ) //set decayment
		{
			temp = atof(DECAYMENT);
		}
		else
		{
			temp = rand_gen(k);
		}
		append_net->neuron_array[0]->decayment = temp;
		
		append_net->neuron_array[0]->inner = 4;
		
		net = (struct neural_net *)append_neuron(net,append_net);

		free_neuron( append_net->neuron_array[0] );
	}	
}
/* Aggregation of more inputs */
else if (agr_type == 1)
{
	num_input_add = atoi(NUM_INPUT_ADD);
	num_neuron_add = num_input_add;
	
	if ( !(append_net = (struct neural_net *)calloc(1,sizeof(struct neural_net)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net");
		exit(1);
	}
	if ( !(append_net->neuron_array = (struct neuron **)calloc(1,sizeof(struct neuron)) ))
	{
		ga_errno = 1;
		syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
		exit(1);
	}
	append_net->num_neuron = 1;
	append_net->type = net->type;
	append_net->dimension = net->dimension;
	

	/* Append input neurons to net */
	for (k=0; k< num_neuron_add; k++)
	{
		if (!strncmp("rr",MOMENTUM,2))
		{
			momentum = dice_toss(k,MAX_MOMENTUM);
		}
		else 
		{
			momentum = atoi(MOMENTUM);
		}
		if ( !(append_net->neuron_array[0] = (struct neuron *)calloc_neuron(
				net->dimension,momentum,0) ))
		{
			ga_errno = 1;
			syslog(LOG_CRIT,"Error calloc append_net->neuron_array");
			exit(1);
		}
		append_net->neuron_array[0]->momentum = momentum;
		
		append_net->neuron_array[0]->x_c[0] = 0.0;
		append_net->neuron_array[0]->range[0] = rand_gen(k) / 2;
		append_net->neuron_array[0]->block = 12;		//lower

		for (l= 1; l< dimension; l++)
		{
			temp = rand_gen(l);
			append_net->neuron_array[0]->x_c[l] = temp; //set coordinates
			append_net->neuron_array[0]->range[l] = (temp > 0.5) ? (rand_gen(l) / 2) : 
																				( temp*rand_gen(l) ) ; //set range
		}

		for (l= 0; l< append_net->neuron_array[0]->momentum; l++) //alpha
		{
			if ( strncmp(ALPHA,"rr",2) )
			{
				temp = rand_gen(l)*atof(ALPHA);
			}
			else
			{
				temp = rand_gen(l);
			}
			append_net->neuron_array[0]->alpha[l] = temp;
		}
		
		if ( strncmp(CONV_RATE,"rr",2) ) //set conv_rate
		{
			temp = atof(CONV_RATE);
		}
		else
		{
			temp = rand_gen(k);
		}
		append_net->neuron_array[0]->conv_rate = temp;
		
		if ( strncmp(BIAS_CORR,"rr",2) ) //set bias_corr
		{
			l = atoi(BIAS_CORR);
		}
		else
		{
			l = coin_toss(k);
		}
		append_net->neuron_array[0]->bias_corr = l;

		if ( strncmp(DELTA_TYPE,"rr",2) ) //set delta_type
		{
			l = atoi(DELTA_TYPE);
		}
		else
		{
			l = dice_toss(k,NUM_TYPE);
		}
		append_net->neuron_array[0]->delta_type = l;
		
		if ( strncmp(DELTA_INF,"rr",2) ) //set delta_inf
		{
			temp = atof(DELTA_INF);
		}
		else
		{
			temp = MAX_DELTA_DISP*rand_gen(k);
		}
		append_net->neuron_array[0]->delta_inf = temp;

		if ( strncmp(DELTA_DISP,"rr",2) ) //set delta_disp
		{
			temp = atof(DELTA_DISP);
		}
		else
		{
			temp = MAX_DELTA_DISP*rand_gen(k);
		}
		append_net->neuron_array[0]->delta_disp = temp;

		if ( strncmp(BIAS,"rr",2) ) //set bias
		{
			temp = atof(BIAS);
		}
		else
		{
			temp = rand_gen(k);
		}
		append_net->neuron_array[0]->bias = temp;
		
		if ( strncmp(DECAYMENT,"rr",2) ) //set decayment
		{
			temp = atof(DECAYMENT);
		}
		else
		{
			temp = rand_gen(k);
		}
		append_net->neuron_array[0]->decayment = temp;
		
		append_net->neuron_array[0]->inner = 2;
		
		net = (struct neural_net *)append_neuron(net,append_net);
		
		free_neuron( append_net->neuron_array[0] );
	}	
}
/* Aggregation of whole networks */
else if (agr_type == 10)
{
	if (!(append_net = (struct neural_net *)fread_neural_net(append_net,OLD_INIT1) ))
	{
		syslog(LOG_CRIT,"Error in fread_neural_net(append_net,%s)",OLD_INIT1);
		exit(1);
	}
		
	l = atoi(MODE);
	if (l == 0)	// full network append
	{
		for (k= 0; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = append_net->neuron_array[k]->block;
		}
	}
	else if (l == 1) // share the output
	{
		for (k= append_net->num_input; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = append_net->neuron_array[k]->block;
		}
		for (k= 0; k< append_net->num_input; k++)
		{
			append_net->neuron_array[k]->inner = 0;
			for (m= append_net->num_input; m< append_net->num_neuron; m++)
			{
				if(is_connected(append_net->neuron_array[k],append_net->neuron_array[m],NULL) >0)
				{
					append_net->neuron_array[m]->inner = 12;  //block lower
				}
			}
		}
	}
	else if (l == 2) //share the input
	{
		for (k= 0; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = append_net->neuron_array[k]->block;
		}
		for (k= append_net->num_neuron - append_net->num_output; k< append_net->num_neuron; k++)
		{
			append_net->neuron_array[k]->inner = 0;
			for (m= 0; m< append_net->num_neuron - append_net->num_output; m++)
			{
				if(is_connected(append_net->neuron_array[k],append_net->neuron_array[m],NULL) >0)
				{
					append_net->neuron_array[k]->inner = 13;  //block upper
				}
			}
		}
	}
	
	net = (struct neural_net *)append_neuron(net,append_net); //requires more aggregation modes
	free_neuron( *(append_net->neuron_array) );
}


if(	fwrite_neural_net(net,INIT_FILE)< 0)
{
	syslog(LOG_CRIT,"Error fwrite_neural_net() %s: %s",INIT_FILE,strerror(errno));
	exit(1);
}
exit(0);
}
