/*  output_layer_error.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

float output_layer_error(int num_neuron, struct neuron ** neuron_array, 
							int num_elem_output, float *output_buffer)
{
	int k,l;
	double temp;
	float error=0;
	
	for (k=0; k<num_neuron; k++)
	{
		neuron_array[k]->delta=0;
	}

	for (k=0; k<num_elem_output; k++)
	{
		l=num_neuron-num_elem_output+k-1;
		temp = output_buffer[k] - neuron_array[l]->value;
		error += (temp*temp);
		temp *= der(neuron_array[l]->delta_type,neuron_array[l]->value);
		neuron_array[l]->delta=temp;
	}
	return(error);
}
