/*  copy_neuron_array.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

/*** Copy the contents of one neuron array into another ***/
//Assuming destiny is already clean
void * copy_neuron_array(int num_neuron, struct neuron ** origin, 
																		struct neuron ** destiny)
{
	int k;
	if ( destiny == NULL ) 
	{
		if( !(destiny = (struct neuron **)malloc(num_neuron*sizeof(struct neuron *)) ))
		{
			syslog(LOG_CRIT,"Couldn't malloc destiny");
			return(NULL);
		}
	}
	else 
	{
		syslog(LOG_CRIT,"destiny still asigned");
		return(NULL);
	}
	
	for (k=0; k< num_neuron; k++)
	{
		if( !(destiny[k] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
		{
			syslog(LOG_CRIT,"Couldn't calloc destiny[k]",k);
			return(NULL);
		}
	}

	for (k=0; k< num_neuron; k++)
	{
		if (origin[k]->num_con)
		{
			if (!( destiny[k]->con_x = (float *)
						malloc(origin[k]->num_con*sizeof(float)) ))
			{
				syslog(LOG_CRIT,"Couldn't malloc destiny[%d]->con_x",k);
				return(NULL);
			}
			if (!( destiny[k]->con_y = (float *)
						malloc(origin[k]->num_con*sizeof(float)) ))
			{
				syslog(LOG_CRIT,"Couldn't malloc destiny[%d]->con_y",k);
				return(NULL);
			}
			if (!( destiny[k]->con_w = (double *)
						malloc(origin[k]->num_con*sizeof(double)) ))
			{
				syslog(LOG_CRIT,"Couldn't malloc destiny[%d]->con_w",k);
				return(NULL);
			}
			if (!( destiny[k]->age = (int *)
						malloc(origin[k]->num_con*sizeof(int)) ))
			{
				syslog(LOG_CRIT,"Couldn't malloc destiny[%d]->age",k);
				return(NULL);
			}

			if (origin[k]->momentum == 1)
			{
				if (!( destiny[k]->delta_con_w = (double *)
							malloc(origin[k]->num_con*sizeof(double)) ))
				{
					syslog(LOG_CRIT,"Couldn't malloc destiny[%d]->delta_con_w",k);			
					return(NULL);
				}
			}
		}
		else
		{
			destiny[k]->con_x = NULL;
			destiny[k]->con_y = NULL;
			destiny[k]->con_w = NULL;
			destiny[k]->age   = NULL;
			destiny[k]->delta_con_w = NULL;
		}
	}
	
	//couldn't use memcpy
	for (k=0; k< num_neuron; k++)
	{
		copy_neuron(origin[k],destiny[k]);
	}
	return(destiny);
}
