/*  dwrite_neuron_array.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"


int dwrite_neuron_array(int num_neuron, struct neuron ** neuron_array, int file_ptr)
{
	int k,l,num_con;
	
	sprintf(char_buffer,"neuron_array\0");
//	syslog(LOG_INFO,"writting %s",char_buffer);
	writen(file_ptr,char_buffer,BUFFSIZE);
	sprintf(char_buffer,"num_neuron=%d\0",num_neuron);
	writen(file_ptr,char_buffer,BUFFSIZE);

	for (k=0;k<num_neuron; k++)
	{
		sprintf(char_buffer,"neuron %d\0",k);
		writen(file_ptr,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"alpha=%f\0",neuron_array[k]->alpha);	
		writen(file_ptr,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"conv_rate=%f\0",neuron_array[k]->conv_rate);	
		writen(file_ptr,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"bias_corr=%d\0",neuron_array[k]->bias_corr);	
		writen(file_ptr,char_buffer,BUFFSIZE);
		
		sprintf(char_buffer,"delta_type=%d\0",neuron_array[k]->delta_type);	
		writen(file_ptr,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"momentum=%d\0",neuron_array[k]->momentum);	
		writen(file_ptr,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"x_c=%1.15f\0",neuron_array[k]->x_c);	
		writen(file_ptr,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"y_c=%1.15f\0",neuron_array[k]->y_c);	
		writen(file_ptr,char_buffer,BUFFSIZE);

		sprintf(char_buffer,"range=%1.15f\0",neuron_array[k]->range);	
		writen(file_ptr,char_buffer,BUFFSIZE);

		num_con=neuron_array[k]->num_con;
		sprintf(char_buffer,"num_con=%d\0",num_con);	
		writen(file_ptr,char_buffer,BUFFSIZE);
		
		sprintf(char_buffer,"bias=%f\0",neuron_array[k]->bias);	
		writen(file_ptr,char_buffer,BUFFSIZE);
		
		for (l=0;l<num_con;l++)
		{
			sprintf(char_buffer,"%1.15f:%1.15f:%3.9f:%d\0",*(neuron_array[k]->con_x+l),
					*(neuron_array[k]->con_y+l),*(neuron_array[k]->con_w+l),*(neuron_array[k]->age+l));	
//		syslog(LOG_INFO,char_buffer);
			writen(file_ptr,char_buffer,BUFFSIZE);
		}
	}
	sprintf(char_buffer,"END\0");	
	writen(file_ptr,char_buffer,BUFFSIZE);
	return 1;
}
