/*  listen_remote.c */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

int listen_remote(char * ip, unsigned int port, int number, int * listenfd)
{
	struct sockaddr_in serv_in_addr;

	if ( (listenfd[number] = socket(PF_INET, SOCK_STREAM, 0)) < 0)
	{
		syslog(LOG_CRIT,"Error creating listen socket");
		return(-1);
	}
	bzero(&serv_in_addr,sizeof(serv_in_addr));
	serv_in_addr.sin_family = PF_INET;
	
	if (inet_pton(AF_INET,ip,&serv_in_addr.sin_addr) < 1)
	{
		syslog(LOG_CRIT,"Error inet_pton() %s",strerror(errno));
		return(-1);
	}
	serv_in_addr.sin_port = htons((uint16_t)(port));

	if ( (bind(listenfd[number], (struct sockaddr *) &serv_in_addr, sizeof(serv_in_addr)) ) < 0)
	{
		syslog(LOG_CRIT,"Error Binding socket: %s",strerror(errno));
		return(-1);
	}
	if ( (listen(listenfd[number],LISTENQ)) <0 )
	{
		syslog(LOG_CRIT,"Error listenning: %s",strerror(errno));
		return(-1);
	}
	return(listen[number]);
}
