/*  mutate_neuron_array.c */

/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn-ag; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "my_header.h"
#include "aux_prot.h"

void * mutate_neuron_array(int num_neuron, int num_add_neuron, struct neuron ** neuron_array,
														int * new_num_neuron)
{
	int k,l,m,n;
	float temp1;
	float temp2;

	int * inner_elem;
	float ** coord;
	
	struct neuron ** temp_array;
	
	if ( num_add_neuron == 0 )
	{
//		syslog(LOG_INFO,"No neurons to add/del in mutate_neuron_array");
		return(neuron_array);
	}
	
	m = ( num_add_neuron > 0 ) ? num_add_neuron : num_neuron;
	
	if (!( inner_elem = (int *)calloc(m,sizeof(int)) ))
	{
		syslog(LOG_CRIT,"Error calloc inner_elem in mutate_neuron_array()");
		return(NULL);
	}

	if ( num_add_neuron > 0 )
	{
		if (!( temp_array = (struct neuron **)calloc(m,sizeof(struct neuron *)) ))
		{
			syslog(LOG_CRIT,"Error calloc temp_array in mutate_neuron_array()");
			return(NULL);
		}
		if (!( coord = (float **)calloc(m,sizeof(float *)) ))
		{
			syslog(LOG_CRIT,"Error calloc coord in mutate_neuron_array()");
			return(NULL);
		}
		for (k=0; k< m; k++)
		{
			if (!( temp_array[k] = (struct neuron *)calloc(1,sizeof(struct neuron)) ))
			{
				syslog(LOG_CRIT,"Error calloc temp_array[%d] in mutate_neuron_array()",k);
				return(NULL);
			}
			if (!( coord[k] = (float *)calloc(2,sizeof(float )) ))
			{
				syslog(LOG_CRIT,"Error calloc coord[k] in mutate_neuron_array()",k);
				return(NULL);
			}
		}
		
		coord[0][0]=rand_gen(m);
		coord[0][1]=rand_gen(m+1);
		for (k=0; k< m ; k++)
		{
			while(1)
			{
				n=0;
				temp1=rand_gen(k);
				temp2=rand_gen(k+1);
				for (l=0; l< k; l++)
				{
					if ( (coord[l][0] == temp1) && (coord[l][1] == temp2) )
					{
						n++;
						break;
					}
				}
				if ( !n )
				{
					coord[k][0] = temp1;
					coord[k][1] = temp2;
					break;
				}
			}
		}
		for (k=0; k< m; k++)
		{
			inner_elem[k] = 8;
			
			temp_array[k]->range = 				0.0;
			temp_array[k]->num_con = 			0;
			temp_array[k]->con_x = 				NULL;
			temp_array[k]->con_y = 				NULL;
			temp_array[k]->con_w = 				NULL;
			temp_array[k]->age =							NULL;
			temp_array[k]->delta_con_w = 	NULL;
	
			temp_array[k]->x_c = 					coord[k][0];
			temp_array[k]->y_c =					coord[k][1];
			temp_array[k]->momentum = 		coin_toss(k);
			temp_array[k]->bias_corr = 		coin_toss(k+1);

			temp_array[k]->delta_type = 	dice_toss(k+2,2);
		
			temp_array[k]->alpha =				rand_gen(k+3);
			temp_array[k]->conv_rate = 		rand_gen(k+4);
			temp_array[k]->bias =					rand_gen(k+5);
		}
	
		if ( !(neuron_array = (struct neuron **)append_neuron(num_neuron, num_add_neuron, 
														neuron_array, temp_array, inner_elem, new_num_neuron) ))
		{
			syslog(LOG_CRIT,"Error in append_neuron() in mutate_neuron_array()");
			return(NULL);
		}
	}
	else 
	{
		for (k=0; k < -num_add_neuron; k++)
		{
			m=dice_toss(k, num_neuron);
			if ( (neuron_array[m]->x_c != 0.0) && (neuron_array[m]->x_c != 1.0) )
			{
				inner_elem[m] = 1;
			}
		}
		neuron_array = (struct neuron **)remove_neuron(num_neuron,neuron_array,
																					inner_elem,new_num_neuron);
	}
	return(neuron_array);
}
