/*  aux_prot.h */
/* 	Copyright 2004 Oswaldo Morizaki */

/* 	This file is part of ga-nn-ag.

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

extern double threshold(int threshold_type, float net);
extern float der(int delta_type, float net);
extern int load_input(float *input_buffer, int num_elem_input, const char * filename);
extern int load_output(float *output_buffer, int num_elem_output, const char * filename);
extern int load_nn_config(struct nn_config *conf, const char * filename);
extern int load_num_neuron(const char *filename);
extern int load_neuron_array(int num_neuron, struct neuron ** neuron_array,	const char * filename);
extern int sort_neuron_array(int num_neuron, struct neuron ** neuron_array);
extern int sort_neuron_connections(struct neuron * neuron_unit);
extern int verify_connections(int num_neuron, struct neuron ** neuron_array);
extern int forward_propagation(int num_neuron, struct neuron ** neuron_array, int num_elem_input);
extern float output_layer_error(int num_neuron, struct neuron ** neuron_array,
													int num_elem_output, float *output_buffer);
extern int back_propagation(int num_neuron, struct neuron ** neuron_array, int num_elem_input);
extern int weight_update(int num_neuron, struct neuron ** neuron_array, int num_elem_input);
extern int fwrite_neuron_array(int num_neuron, struct neuron ** neuron_array, 
												const char *filename);
extern int dwrite_neuron_array(int num_neuron, struct neuron ** neuron_array, int file_ptr);
extern int copy_neuron(struct neuron * origin, struct neuron * destiny);
extern void * copy_neuron_array(int num_neuron, struct neuron ** origin, struct neuron ** destiny);
extern void * free_neuron_array(int num_neuron, struct neuron ** neuron_array);

extern ssize_t writen(int fd, const void *vptr, size_t n);
extern ssize_t readn(int fd, void *vptr, size_t n);

extern int coin_toss(int seed);
extern int toss(float prob, int seed);
extern int dice_toss(int seed, int partition);
extern float rand_gen(int seed);
extern int roulette(int num, float *fitness);
extern int mate(int poblation, int **parents, float * fitness);
extern int region_gen(float **vertice);
extern int inner(float ** vertice, float *coord);
extern int inner_neuron(int num_neuron, struct neuron ** neuron_array, float **vertice, 
						int *inner_elem);
extern int near_neuron(int num_neuron, struct neuron **neuron_array, int * inner_elem);
extern int isolate_region(int num_neuron, struct neuron **neuron_array, int * inner_elem);
extern void * remove_neuron(int num_neuron, struct neuron **neuron_array, 
											int * inner_elem, int * new_num_neuron);
extern void * append_neuron(int num_neuron1, int num_neuron2, struct neuron ** parent1, 
											struct neuron ** parent2, int * inner_elem2, int * new_num_neuron);
extern void * mutate_neuron(struct neuron * neuron_unit, struct ga_server_config * mut);
extern void * mutate_neuron_array(int num_neuron, int num_add_neuron, struct neuron ** 
											neuron_array, int * new_num_neuron);
extern int clean_char_buffer(char * char_buffer);
extern int read_neuron_array(int num_neuron, struct neuron ** neuron_array,	int fd);
extern int load_ga_server_config(struct ga_server_config *conf, const char * filename);
extern int get_fitness(int poblation, float base, float boost,  int * num_neuron, 
													double * error, float * fitness);
extern int read_ga_server_remote_config(struct ga_server_config *conf, int descriptor);	
extern int is_local(int num_client, int max_local);
extern void sig_alarm(int signo);

