/* my_header.h */
/* 	Copyright 2004 Oswaldo Morizaki */
/* 	This file is part of ga-nn-ag 

    ga-nn-ag is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    ga-nn-ag is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ga-nn; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/select.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <netdb.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <fcntl.h>
#include <setjmp.h>

#include "stdlib.h"
#include "stdio.h"
#include "math.h"
#include "strings.h"

#define BUFFSIZE 256
#define LISTENQ 1024
#define FILE_MODE (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)

char char_buffer[BUFFSIZE];

struct nn_config
{
	int num_pat;
	int num_input;
	int num_output;
	
	int mode; //mode type
	
	char input_preffix[BUFFSIZE];
	char output_preffix[BUFFSIZE];
};

struct ga_server_config
{	
	int timestamp;
	int time_wait;

	char message[BUFFSIZE];

	char ip[BUFFSIZE];
	char init_preffix[BUFFSIZE];
	char result_preffix[BUFFSIZE];
	char ** hosts;
	char ** niches;

	unsigned int remote_server_port;
	unsigned int local_server_port;
	int max_local;
	int first_local;
	int last_local;
	int num_hosts;
	int num_niche;

	int poblation;
	int generations;
	int max_neuron_mut;
	int max_num_layer;
	int max_num_neuron;
	int agr;
	int age;
	
	float mut_new_prob;
	float mut_neuron_prob;
	float mut_net_prob;
	float inm_prob;
	float lifespan;
	float base;
	float boost;
	float level;
	
	float prob_alpha;
	float prob_conv_rate;
	float prob_bias_corr;
	float prob_delta_type;
	float prob_momentum;
	float prob_num_con;
	float prob_bias;
};

struct neuron
{
	float alpha;		//individual parameters
	float conv_rate;
	int bias_corr;
	int delta_type;
	int momentum;		
	
	float x_c;			//x coordinate
	float y_c;			//y coordinate	

	float range;		//range of connection
	int num_con;		//number of conected elements
	double bias;		//bias input
	int	* age;
	float * con_x;	//prev. layer conections x coordinate
	float * con_y; 
	double * con_w;
	
	double * delta_con_w;
	
	double value;		//network value
	double delta;		//error value
};

struct individual
{
	struct neuron ** neuron_array;
	int age;
};

