#!/usr/bin/env bash
# Written in 2013 by Alexandru Cojocaru <xojoc@gmx.com>
# This file is part of games2d.
# As an exception I am releasing this file in
# the Public domain: use this file as you wish. NO WARRANTY.

### keep in sync with gen-gtkkeyslst.sh

cat build-aux/keyslst | awk 'BEGIN {print "\
#pragma once\n\
#include <SDL.h>\n\
enum keys {"}\
                                                        \
$0 == "# special", $0 == "# end special" {              \
    if ($0 == "KNONE")                                  \
        print "\t" "KNONE = SDLK_UNKNOWN" ",";          \
}                                                       \
                                                        \
                                                        \
$0 == "# non textual", $0 == "# end non textual" {                      \
    if ($0 != "# non textual" &&                                        \
        $0 != "# end non textual")                                      \
    {                                                                   \
        print "\t" $0 " = SDLK_" substr ($0, 2) "," ;                   \
    }                                                                   \
}                                                                       \
                                                                        \
$0 == "# textual", $0 == "# end textual" {                              \
    if ($0 != "# textual" &&                                            \
        $0 != "# end textual")                                          \
    {                                                                   \
        s = substr ($0, 2);                                             \
        print "\t" $0 " = SDLK_" s "," ;                                \
    }                                                                   \
}                                                                       \
                                                                        \
END {print "};"}' > src/keyslst.h
