/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

#include "games2d.h"

static obj b;
static obj pad;

/* last pad direction: -1 || 0 || 1 */
static int lastdir;

static uchar **grid;

static uint32_t colors[] = {0, 0xba1f20aa, 0xe68922aa, 0x58be4daa, 0xe6e150aa};

static uint lifes = 3;
static uint hits;
static uint score;
/* static uint _round; */

static void
reposition (void)
{
  pad.r.x = rnd (0, scrn.w-pad.r.w);
  pad.r.y = (scrn.h - pad.r.h - blkw/2);

  b.r.x = pad.r.x + pad.r.w/2 - b.r.w/2;
  b.r.y = pad.r.y - b.r.h;
}

static void
redraw (void)
{
  boxr ((rec){0,0, scrn.w,scrn.h}, bgcolor);
  for (int r = 0; r < scrn.h/blkw; ++r)
    for (int c = 0; c < scrn.w/blkw; ++c)
      if (grid[r][c])
        boxr ((rec){c*blkw, r*blkw, blkw-1, blkw-1},
              colors[grid[r][c]]);

  boxr (pad.r, pad.c);
  boxr (b.r, b.c);
  // updater (scrn);
}
static void
fillgrid (void)
{
  uint h = scrn.h/blkw;
  uint w = scrn.w/blkw;

  grid = g_slice_alloc (h * sizeof(*grid));

  for (uint r = 0; r < h; ++r) {
    grid[r] = g_slice_alloc (w);
    char f;
    if (r >= 3 && r <= 10)
      f = (r-1)/2;
    else
      f = 0;
    memset (grid[r], f, w);
  }
}
static void
hitted (void)
{
  if (hits < 12) {
    ++hits;
    
    if (hits == 4 || hits == 12) {
      b.dx += b.ddx * (b.dx > 0 ? 1 : -1);
      b.dy += b.ddy * (b.dy > 0 ? 1 : -1);
    }
  }
}
static int
padballcoll (void)
{
  if ((b.r.x + b.r.w > pad.r.x) &&
      (b.r.x < pad.r.x + pad.r.w) &&
      (b.r.y + b.r.h > pad.r.y))
    {
      b.r.y = pad.r.y - b.r.h;
      b.dy *= -1;
      if (lastdir)
        b.dx = lastdir * abs(b.dx);
      float v = fabsf (((float)pad.r.h/2 - (b.r.y - pad.r.y))) /
        (float)pad.r.h/2;
      b.dx += v;
      hitted ();
      return 1;
    }
  return 0;
}
static void
player (enum keys k)
{
  boxr (pad.r, bgcolor);
  if (k == KLEFT) {
    lastdir = -1;
    sub (pad.r.x, pad.dx, 0);
  } else {
    lastdir = 1;
    add (pad.r.x, pad.dx, scrn.w-pad.r.w);
  }
  boxr (pad.r, pad.c);
}
static int
ball (void)
{
  /* int collided = 0; */

  boxr (b.r, bgcolor);
  b.r.x += b.dx;
  b.r.y += b.dy;

  if (b.r.x < 0) {
    b.r.x = 0;
    b.dx *= -1;
    /* collided = 1; */
  }
  else if (b.r.x + b.r.w > scrn.w) {
    b.r.x = scrn.w - b.r.w;
    b.dx *= -1;
    /* collided = 1; */
  }

  if (b.r.y < 0) {
    b.r.y = 0;
    b.dy *= -1;
    b.dx *= -1;
    /* collided = 1; */
  }
  else if (b.r.y + b.r.h > scrn.h) {
    --lifes;
    return 1;
  }
    
  int gridcoll = 0;

#define gridchk(y,x)                                    \
  if (grid[y][x]) {                                     \
    score += (grid[y][x] - 1)*2 + 1;                    \
    boxr ((rec){x*blkw,y*blkw, blkw,blkw}, bgcolor);    \
    grid[y][x] = 0;                                     \
    gridcoll = 1;                                       \
  }

  gridchk (b.r.y/blkw, b.r.x/blkw);
  gridchk (b.r.y/blkw, (b.r.x+blkw-1)/blkw);
  gridchk ((b.r.y+blkw-1)/blkw, (b.r.x+blkw-1)/blkw);
  gridchk ((b.r.y+blkw-1)/blkw, b.r.x/blkw);

  if (gridcoll) {
    b.dy *= -1;
    b.dx *= -1;
    /* collided = 1; */
  }
  
  /* if (collided) */
  /*   hitted (); */

  padballcoll ();

  boxr (b.r, b.c);
  
  return 0;
}

int
main (int argc, char **argv)
{
  scrn.w = 700;
  scrn.h = 500;

  fps = 50;

  //blkw = 2 * MIN (scrn.w, scrn.h) / 100;
  blkp = 3;
  
  //  scrn.w -= scrn.w % blkw;
  // scrn.h -= scrn.h % blkw;
  
  g2dinit (&argc, &argv, 0);

  fillgrid ();
  
  pad.r.w = blkw*10;
  pad.r.h = 10;
  pad.dx = 10;
  pad.c = WHITE;

  b.r.w = b.r.h = blkw;
  b.dx = blkw/2;
  b.dy = -blkw/2;
  b.ddx = b.ddy = 1;
  b.c = WHITE;

  reposition ();
  
  redraw ();

  uint playing = 1;
  
  while (mainloop (1000 / fps)) {
    enum keys k, k0;

    getinput ();

    k = getkey ((enum keys []) {KSPACE, KNONE}, 1);

    if (k == KSPACE) {
      playing = ! playing;
    }

    if (! playing)
      continue;
    
    k0 = getkey ((enum keys []) {KLEFT, KRIGHT, KNONE}, 0);
    if (k0 != KNONE)
      player (k0);
    else
      lastdir = 0;

    if (ball ()) {
      if (lifes == 0)
        error (1, 0, "game over");
      boxr (b.r, bgcolor);
      boxr (pad.r, bgcolor);
      reposition ();
      boxr (b.r, b.c);
      boxr (pad.r, pad.c);
    }
    
    updater ((rec){0,0,scrn.w,scrn.h});
  }
}
