/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

/* TODO: queeu update_list */

#include "games2d.h"

#include <errno.h>
#include <time.h>
#include <sys/time.h>

rec scrn = {0};
int fps = 25;
struct timeval tstart;
uint32_t bgcolor = 0x001122ff;
int blkw = 0;
int blkp = 0;
pos scrnalgn = {0};
uint hplayers = 0;
uint nexttick;
int playing;

void (*drawcb) (void) = NULL;

#include "init.h"

void
g2dinit (int *argc, char ***argv, int flags)
{
  assert (scrn.w && scrn.h);

  adjstsz ();
  
  init (argc, argv, flags);
  
  if (flags & G2D_STARTPAUSED)
    playing = 0;
  else
    playing = 1;

  
  /* FIXME: remove this (after implementing resize) */
  boxr (scrn, bgcolor);
  updater (scrn);

  srand (time (0));

  gettimeofday (&tstart, NULL);
  nexttick = getticks ();
}
/* FIXME: find a better method */
uint
rnd (uint s, uint e)
{
  return s + rand ()%e; 
}
void
msleep (uint32_t m)
{
  struct timespec r, s = {0, m*1000*1000};
  while (nanosleep (&s, &r) != 0) {
    if (errno == EINTR) {
      s = r;
      continue;
    } else
      error (1, errno, "nanosleep");
  }
}
uint32_t
getticks (void)
{
  struct timeval t;
  gettimeofday (&t, NULL);
  return (t.tv_sec-tstart.tv_sec)*1000 + (t.tv_usec-tstart.tv_usec)/1000;
}
int
mainloop (uint32_t d)
{
  getinput ();

  if (getkey ((enum keys [])
              {Kp, KNONE}, 1))
    {
      playing = ! playing;
    }

  nexttick += d;
  int32_t s = nexttick - getticks ();
  if (s >= 0)
    msleep (s);
  else
    error (0, 0, "slow hardware");

  if (! playing)
    mainloop (d);

  return 1;
}
void
adjstsz (void)
{
  if (scrnalgn.x == blkw)
    scrnalgn.x = 0;
  if (scrnalgn.y == blkw)
    scrnalgn.y = 0;

  if (blkp)
    blkw = blkp * MIN (scrn.w, scrn.h) / 100;
  
  assert (blkw);
  
  if (scrnalgn.x == 0)
    scrnalgn.x = blkw;
  if (scrnalgn.y == 0)
    scrnalgn.y = blkw;

  scrn.w -= scrn.w % scrnalgn.x;
  scrn.h -= scrn.h % scrnalgn.h;
}
int
sign (double n)
{
  return n < 0 ? -1 : (n == 0 ? 0 : 1);
}
