/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */


#pragma once

#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <error.h>
#include <assert.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <math.h>

#include <glib.h>

/* Shorter names, I hate typing :-). */
#define INT2PTR GINT_TO_POINTER

typedef unsigned long ulong;
typedef unsigned int uint;
typedef unsigned char uchar;

#define USED(v)((void)v)
#define AUSED __attribute__ ((used))

/* games2d */
#include "arith.h"
#include "draw.h"
#include "input.h"
#include "collision.h"
// #include "bitmap.h"

enum {
  G2D_NOTHING = 0,
  G2D_FULLSCREEN = 1,
  //  G2D_SDL = 1 << 1,
  G2D_STARTPAUSED = G2D_FULLSCREEN << 1,
};

#define nelems(a) (sizeof (a)/sizeof (a[0]))

extern rec scrn;
extern int fps;
extern struct timeval tstart;
extern uint32_t bgcolor;
extern int blkw;
extern int blkp;
extern pos scrnalgn;
AUSED static uint ai;
extern uint hplayers;
extern uint32_t nexttick;
extern int playing;

void g2dinit (int *argc, char ***argv, int flags);
uint rnd (uint s, uint e);
void msleep (uint32_t m);
uint32_t getticks (void);
int mainloop (uint32_t d);
void adjstsz (void);
int sign (double n);

extern void (*drawcb) (void);


#define CU(decl, ps, fun)                           \
  decl __attribute__ ((cleanup (fun##f)));          \
  fun (ps)

#define CUA(decl, ps, fun)                           \
  decl __attribute__ ((cleanup (fun##f))) = fun (ps)



#define CUE(type, var, ps, fun)                 \
  type var;                                     \
  fun (ps);                                     \
  do {                                          \
    void G_PASTE (__CUE_, __LINE__) (void) {    \
      fun##f (&var);                            \
    }                                           \
    atexit (G_PASTE (__CUE_, __LINE__));        \
  } while (0)                                       
  
