/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

#include "games2d.h"
#include "gtk.h"

GtkWidget *screen;
GtkWidget *drawa;

void
updater (rec r)
{
  USED (r);
}
static void
cairo_setc (cairo_t *cr, uint32_t c)
{
  double r = (c & 0xff000000) >> 24;
  double g = (c & 0x00ff0000) >> 16;
  double b = (c & 0x0000ff00) >> 8;
  double a = c & 0x000000ff;
  cairo_set_source_rgba (cr, r/0xff, g/0xff, b/0xff, a/0xff);
}
static void
_boxr (rec r, uint32_t c, int f)
{
  cairo_t *cr = gdk_cairo_create (gtk_widget_get_window (drawa));
  cairo_setc (cr, c);
  cairo_set_line_width (cr, 1);
  cairo_rectangle (cr, r.x, r.y, r.w, r.h);
  if (f)
    cairo_fill (cr);
  
  cairo_destroy (cr);
}
void
boxr (rec r, uint32_t c)
{
  _boxr (r, c, 1);
}
void
boxp (pos s, pos e, uint32_t c)
{
  boxr ((rec){s.x, s.y, e.x-s.x, e.y-s.y}, c);
}
void
borderp (pos s, pos e, uint32_t c)
{
  _boxr ((rec){s.x, s.y, e.x-s.x, e.y-s.y}, c, 0);
}
img *
loadimg (char *s, int w, int h)
{
  char *t = g_strconcat (DATADIR"/"PKGNAME"/", s, NULL);
  GError *e = NULL;
  img *i = gdk_pixbuf_new_from_file_at_size (t, w, h, &e);
  if (! i)
    error (1, 0, "can't load image: %s\n", e->message);

  g_free (t);

  return i;
}
void
freeimg (img *i)
{
  g_object_unref (i);
}
void
blit (img *src, rec srcr, img *dst, rec dstr)
{
  USED (src); USED (srcr); USED (dst); USED (dstr);
}
void
blito (obj o)
{
  cairo_t *cr = gdk_cairo_create (gtk_widget_get_window (drawa));
  gdk_cairo_set_source_pixbuf (cr, o.img, o.r.x, o.r.y);
  cairo_paint (cr);
  cairo_destroy (cr);
}
