/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

/* TODO: mystship */

#include "games2d.h"

/*  static int lifes = 3; */
static uint score;

static int dx, dy;
/* static double ddx, ddy; */

static pos toplft;
static int lastrgt;
static int fstlft;
static int lastbtm;

enum {
  ALN_ROWS = 5,
  ALN_COLS = 11,
  ALN_MAX_BLETS = 3,
  BNKR_N = 4,
  BNKR_ROWS = 3,
  BNKR_COLS = 5,
};

static int alnalive[5][11];
static img *alnimg[3];
/* static obj alnmystship; */

struct bullet {
  obj o;
  int alive;
};

static obj plship;
static struct bullet plblet;

static struct bullet alnblet[ALN_MAX_BLETS];

static obj bnkrsq;
static pos bnkrpos[BNKR_N];
static bool bnkralive[BNKR_N][BNKR_ROWS][BNKR_COLS];

static void
lose (void)
{
  error (1, 0, "gameover :-(: score: %d", score);
}
static void
win (void)
{
  error (0, 0, "gameover :-): score: %d", score);
  exit (0);
}
static void
plinit (void)
{
  int w = blkw*3;
  plship = (obj) {.dx = blkw/4, .c = GREEN};
  plship.r = (rec) {scrn.w/2 - w/2, scrn.h - blkw,
                    w, blkw};
}
static void
bnkrinit (void)
{
  int o = blkw*3;
  bnkrsq = (obj) {.r = {.w = blkw, .h = blkw}, .c = ORANGE};
  bnkrpos[0] = pp ((scrn.w - (bnkrsq.r.w*(BNKR_N*BNKR_COLS) + o*(BNKR_N-1)))/2,
                   scrn.h - (blkw + blkw*4));
  
  for (int i = 1; i < BNKR_N; ++i)
    bnkrpos[i] = pp (bnkrpos[i-1].x + bnkrsq.r.w*BNKR_COLS + o,
                     bnkrpos[i-1].y);

  memset (bnkralive, 1, sizeof (bnkralive));
}
static int
bnkrgetx (int i, int c)
{
  return bnkrpos[i].x + bnkrsq.r.w * c;
}
static int
bnkrgety (int i, int r)
{
  return bnkrpos[i].y + bnkrsq.r.w * r;
}
static int
bnkriter (bool (*cb) (rec rec, int i, int r, int c))
{
  for (int i = 0; i < BNKR_N; ++i) {
    for (int r = 0; r < BNKR_ROWS; ++r) {
      bnkrsq.r.y = bnkrgety (i, r);
      for (int c = 0; c < BNKR_COLS; ++c) {
        bnkrsq.r.x = bnkrgetx (i, c);
        if (bnkralive[i][r][c])
          if (cb (bnkrsq.r, i, r, c))
            return 1;
      }
    }
  }
  return 0;
}
static void
bnkrdraw (void)
{
  bool _cb (rec rec, int i, int r, int c) {
    USED (i); USED (r); USED (c);
    boxr (rec, bnkrsq.c);
    return 0;
  }

  bnkriter (_cb);
}
static bool
bnkrclds (rec _rec)
{
  bool _cb (rec bnkrec, int i, int r, int c) {
    if (cldsr (bnkrec, _rec)) {
      bnkralive[i][r][c] = 0;
      boxr (bnkrsq.r, bgcolor);
      return 1;
    }
    return 0;
  }
  return bnkriter (_cb);
}
static void
alninit (void)
{
  alnimg[0] = loadimg ("space_invaders-alns-1.png", blkw, blkw);
  alnimg[1] = loadimg ("space_invaders-alns-2.png", blkw, blkw);
  alnimg[2] = loadimg ("space_invaders-alns-3.png", blkw, blkw);
 
  dx = blkw/10;
  dy = blkw;
  toplft = pp(0,0);
  lastrgt = ALN_COLS-1;
  lastbtm = ALN_ROWS-1;
  memset (alnalive, 1, sizeof (alnalive));
}
static int
alngetx (int c)
{
  return toplft.x + c*blkw + c*blkw/2;
}
static int
alngety (int r)
{
  return toplft.y + r*blkw + r*blkw/2;
}
static void
alniter (bool (*cb) (rec, int, int))
{
  for (int r = 0; r < ALN_ROWS; ++r) {
    for (int c = 0; c < ALN_COLS; ++c) {
      rec rec = {alngetx (c),
                 alngety (r),
                 blkw, blkw};

      if (alnalive[r][c])
        if (cb (rec, r, c))
          return;
    }
  }
}
static int
alngeti (int r)
{
  return (r+1)/2;
}
static void
alndraw (int clear)
{
  bool _cb (rec rec, int r, int c) {
    USED (c);
    if (clear)
      boxr (rec, bgcolor);
    else {
      blito ((obj) {.r = rec,
            .img = alnimg[alngeti (r)]});
    }
    
    return 0;
  }
  alniter (_cb);
}
static void
alnmove (void)
{
  int incy = 0;
  toplft.x += dx;
  if (alngetx (lastrgt) + blkw > scrn.w) {
    toplft.x -= dx;
    dx *= -1;
    incy = 1;
  } else if (alngetx (fstlft) < 0) {
    toplft.x -= dx;
    dx *= -1;
    incy = 1;
  }
  bool _xcb (rec alnrec, int r, int c) {
    USED (r); USED (c);
    if (cldsr (alnrec, plship.r)) {
      lose ();
      return 1;
    }
    return 0;
  }
  alniter (_xcb);
  
  bool _cb (rec alnrec, int r, int c) {
    USED (r); USED (c);
    bool _bnkrcb (rec bnkrrec, int i, int r, int c) {
      if (cldsr (bnkrrec, alnrec)) {
        bnkralive[i][r][c] = 0;
        boxr (bnkrrec, bgcolor);
      }
        return 0;
    }
    
    return bnkriter (_bnkrcb);
  }
  alniter (_cb);

  if (incy) {
    toplft.y += dy;
    if (alngety (lastbtm) + blkw > scrn.h)
      lose ();
  }
}
static void
alnshoot (void)
{
  static int fire = 0;
  if (fire != fps) {
    ++fire;
    return;
  } else
    fire = 0;
  
  int j = rnd (0, ALN_MAX_BLETS);
  if (alnblet[j].alive)
    return;

  int _c = (plship.r.x+plship.r.w/2 - toplft.x) / blkw;
  int cmin = _c - 1;
  int cmax = _c + 1;
  cmin = MIN (fstlft, cmin);
  cmax = MAX (lastrgt, cmax);

  alnblet[j].alive = 1;
  
  int c = rnd (cmin, cmax);
    //  int c = rnd (0, ALN_COLS);
  int r = rnd (0, ALN_ROWS);
  alnblet[j].o.r.x = alngetx (c);
  alnblet[j].o.r.y = alngety (r);
  boxr (alnblet[j].o.r, alnblet[j].o.c);
}
static void
alnkilled (int r, int c)
{
  alnalive[r][c] = 0;
  boxr ((rec){alngetx (c), alngety (r), blkw, blkw},
        bgcolor);

  if (alngeti (r) == 0)
    score += 30;
  else if (alngeti (r) == 1)
    score += 20;
  else if (alngeti (r) == 2)
    score += 10;

  if (r == lastbtm) {
    while ((lastbtm >= 0) &&
           (! memchr (alnalive[lastbtm], 1,
                      sizeof (alnalive[lastbtm]))))
      {
        --lastbtm;
      }
  }

  if (c == lastrgt) {
    int ce;
    do {
      ce = 1;
      for (int xr = 0; xr <= lastbtm; ++xr)
        if (alnalive[xr][lastrgt]) {
          ce = 0;
          break;
        }
      if (ce)
        --lastrgt;
    } while (ce && (lastrgt >= 0));
  }
  
  if (c == fstlft)
    {
      int ce;
      do {
        ce = 1;
        for (int xr = 0; xr <= lastbtm; ++xr)
          if (alnalive[xr][fstlft]) {
            ce = 0;
            break;
          }
        if (ce)
          ++fstlft;
      } while (ce && (fstlft < lastrgt));
    }

  if (lastbtm == -1)
    win ();
}
static void
bletinit (void)
{
  int dy = blkw/3;
  int w = blkw/4;
  int h = blkw/3;
  plblet.o = (obj){.dy = -dy, .c = GREEN};
  plblet.o.r = (rec){0, 0, w, h};

  for (int i = 0; i < ALN_MAX_BLETS; ++i) {
    alnblet[i].o = (obj) {.dy = dy, .c = RED};
    alnblet[i].o.r = (rec) {0, 0, w, h};
  }
}
static void
bletclds (struct bullet *b)
{
  if (! b->alive)
    return;
    
  boxr (b->o.r, bgcolor);
  b->o.r.y += b->o.dy;
  
  if (bnkrclds (b->o.r))
    b->alive = 0;

  if (b->o.r.y + b->o.r.h <= 0)
    b->alive = 0;

  if (b->o.r.y >= scrn.h)
    b->alive = 0;

  if (! b->alive)
    return;
}
static void
bletdraw (void)
{
  if (plblet.alive)
    boxr (plblet.o.r, plblet.o.c);
  for (int i = 0; i < ALN_MAX_BLETS; ++i)
    if (alnblet[i].alive)
      boxr (alnblet[i].o.r, alnblet[i].o.c);
}
static void
bletsmove (void)
{
  bletclds (&plblet);

  bool _cb (rec rec, int r, int c) {
    if (! plblet.alive)
      return 1;
    
    if (cldsr (plblet.o.r, rec)) {
      plblet.alive = 0;
      boxr (plblet.o.r, bgcolor);
      alnkilled (r, c);
      return 1;
    }

    return 0;
  }

  alniter (_cb);

  
  for (int i = 0; i < 3; ++i) {
    bletclds (&alnblet[i]);
    if (plblet.alive) {
      if (cldsr (alnblet[i].o.r, plblet.o.r)) {
        plblet.alive = 0;
        boxr (plblet.o.r, bgcolor);
        alnblet[i].alive = 0;
        boxr (alnblet[i].o.r, bgcolor);
      }
    }

    if (cldsr (alnblet[i].o.r, plship.r))
      lose ();
  }

  bletdraw ();
}
static void
pldraw (void)
{
  boxr (plship.r, plship.c);
}
static void
plmove (enum keys k)
{
  boxr (plship.r, bgcolor);

  if (k == KRIGHT)
    plship.r.x += plship.dx;
  else
    plship.r.x -= plship.dx;

  if (plship.r.x + plship.r.w > scrn.w)
    plship.r.x = scrn.w - plship.r.w;
  else if (plship.r.x < 0)
    plship.r.x = 0;

  pldraw ();
}
static void
plshoot (void)
{
  if (plblet.alive)
    return;
  
  plblet.alive = 1;
  plblet.o.r.x = plship.r.x + plship.r.w/2;
  plblet.o.r.y = plship.r.y - plblet.o.r.h;
}
static void
plhandle (enum keys k)
{
  switch (k) {
   case KLEFT: case KRIGHT: plmove (k); break;
   case KSPACE:             plshoot (); break;
   case KNONE:              break;
   default:                 abort (); break;
  }
}
static void
draw (void)
{
  boxr (scrn, bgcolor);
  pldraw ();
  bletdraw ();
  alndraw (0);
  bnkrdraw ();
}
static void
reset (void)
{
  plinit ();
  alninit ();
  bnkrinit ();
  bletinit ();
  draw ();
}
int
main (int argc, char **argv)
{
  scrn.w = 1000;
  scrn.h = 500;
  blkw = 30;
  fps = 100;
  drawcb = draw;
  
  g2dinit (&argc, &argv, 0);

  reset ();
  
  while (mainloop (1000 / fps)) {
    enum keys k;
    k = getkey ((enum keys [])
                {KLEFT, KRIGHT, KSPACE, KNONE}, 0);
    plhandle (k);

    alnshoot ();

    bletsmove ();
  
    alndraw (1);
    alnmove ();
    alndraw (0);
  }
}
