/* Copyright (C) 2013 by Alexandru Cojocaru */

/* This file is part of games2d.
 
   games2d is free software: you can redistribute
   it and/or modify it under the terms of the
   GNU General Public License as published by the
   Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   games2d is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
   the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see http://www.gnu.org/licenses/. */

#include "games2d.h"

static int8_t **grid;
static pos *head;
static uint32_t colors[] = {0x33dd33ff, 0x223344ff};
static enum keys p1keys[] = {Kd, Ks, Ka, Kw, KNONE};

static pos
next_move (enum keys k)
{
  pos d = pp(0,0);

  switch (k) {
  case KRIGHT: case Kd:
    d.x = 1; break;
  case KDOWN: case Ks:
    d.y = 1; break;
  case KLEFT: case Ka:
    d.x = -1; break;
  case KUP: case Kw:
    d.y = -1; break;
  default:
    abort ();
  }

  return d;
}
static int
would_collide (uint p, struct pos d)
{
  struct pos pos = head[p];
  pos.x += d.x;
  pos.y += d.y;
  if (pos.x < 0 || pos.y < 0 ||
      pos.x > scrn.w/blkw - 1 ||
      pos.y > scrn.h/blkw - 1 ||
      grid[pos.x][pos.y] != -1)
    return 1;
  return 0;
}
static struct pos
ai_move (uint p)
{
  static enum keys lastk = Kd;

  struct pos d = next_move (lastk);
  if ((would_collide (p, d)) ||
      (rnd (0, 70) == 0)) {
    for (uint i = 0; i < 15; ++i) {
      enum keys t = p1keys[rnd (0, 4)];
      if (! would_collide (p, next_move (t))) {
	lastk = t;
	break;
      }
    }
  }
 
  return next_move (lastk);
}
static int
isopp (enum keys k0, enum keys k1)
{ return (k0 == KLEFT && k1 == KRIGHT) ||
    (k0 == KRIGHT && k1 == KLEFT) ||
    (k0 == KUP && k1 == KDOWN) ||
    (k0 == KDOWN && k1 == KUP) ||
    (k0 == Ka && k1 == Kd) ||
    (k0 == Kd && k1 == Ka) ||
    (k0 == Kw && k1 == Ks) ||
    (k0 == Ks && k1 == Kw);
}
static int
handle_player (uint p, enum keys k)
{
  int c = 0;
  static enum keys lastk[2] = {KLEFT, Kd};
  struct pos d;
  if (k == KNONE)
    k = lastk[p];
  else if (isopp (k, lastk[p]))
    k = lastk[p];
  else
    lastk[p] = k;

  if (ai && (p == 1))
    d = ai_move (p);
  else
    d = next_move (k);

  if (would_collide (p, d))
    c = 1;

  head[p].x += d.x;
  head[p].y += d.y;
  if (! c)
    grid[head[p].x][head[p].y] = p;
  
  return c;
}
void
draw (void)
{
  for (uint i = 0; i < 2; ++i) {
    int x = head[i].x*blkw;
    int y = head[i].y*blkw;
    boxp (head[i], pp(x+blkw, y+blkw), colors[i]);
    updater ((rec){x, y, blkw, blkw});
  }
}
int
main (int argc, char *argv[])
{
  scrn.w = 500;
  scrn.h = 300;

  blkp = 2;
  //blkw = 10;
  // scrnalgn = pp(0,0);
  
  g2dinit (&argc, &argv, 0);

  ai = 1;
  hplayers = 1;
  if (! ai)
    ++hplayers;

  grid = g_slice_alloc (scrn.w/blkw * sizeof (uint8_t *));
  for (int c = 0; c < scrn.w/blkw; ++c) {
    grid[c] = g_slice_alloc (scrn.h/blkw);
    memset (grid[c], -1, scrn.h/blkw);
  }

  head = g_slice_alloc (2 * sizeof (struct pos));

  for (uint i = 0; i < 2; ++i) {
    pos d = pp(0,0);
    head[i] = pp(scrn.w/2/blkw, scrn.h/blkw);
    
    if (i == 0)
      d.x = scrn.w/blkw/3;
    else
      d.x = -scrn.w/blkw/3;
    head[i].x += d.x;
    head[i].x -= head[i].x % blkw;
    head[i].y -= head[i].y % blkw;
    grid[head[i].x][head[i].y] = i;
  }

  draw ();
   
  while (mainloop (1000 / fps)) {
    enum keys k0, k1;

    k1 = KNONE;

    getinput ();

    k0 = getkey ((enum keys [])
                 {KRIGHT, KDOWN, KLEFT, KUP, KNONE}, 0);
    if (! ai)
      k1 = getkey ((enum keys [])
                   {Kd, Ks, Ka, Kw, KNONE}, 0);
    
    int died0 = 0;
    int died1 = 0;
    died0 = handle_player (0, k0);
    died1 = handle_player (1, k1);
    if (died0 ||
	((head[0].x == head[1].x) &&
	(head[0].y == head[1].y)))
      error (0, 0, "player 1 died");
    if (died1)
      error (0, 0, "player 2 died");
    if (died0 || died1)
      exit (1);

    draw ();
  }
}
