<?PHP
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Free Web Based Training System                          //
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Plate-forme de tlformation gratuite et en open source //
// ------------------------------------------------------------------------- //
// Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>          //
// ------------------------------------------------------------------------- //
//            Developer : Georges CALDEIRA <gcaldeira@anemalab.org>          //
// ------------------------------------------------------------------------- //
//               Infos on project <http://anemalab.org/>                     //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

/**
* Page groupe de la partie Admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaAdmin
*/
	/**
	* include des fichiers + verification de la cnx
	*/
	include_once("anema.inc.php");

	debugf(__FILE__);
	
	/**#@+
    * @access public
	* @ignore
	*/
	define('SUBMENU',	MENU_GROUPE);
	define('ACTION',	(isset($HTTP_GET_VARS['action'])?$HTTP_GET_VARS['action']:''))	;
	define('ID',		(isset($HTTP_GET_VARS['id'])?$HTTP_GET_VARS['id']:''))			;
	define('PAGE',		HTTP_ADMIN.$PAGE_ADMIN[SUBMENU]."?connexion=".$gconnexionid)	;
	/**#@-*/
	
/**
* Gestion de la page groupe de l'admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaAdmin
*/
class PageGroupeAdmin {
		
	/**
	* Affiche la liste des societes
	* @access	public
	*/
	function liste() { 
	 	global $ClsGroupe, $ClsSession, $ClsMembre;
	 	global $gconnexionid, $gusertype, $guserid, $HTTP, $ad_menu, $color3, $ad_form, $ad_titre ;
	    GetTitre($ad_menu[1]);

		$ajouter= PAGE.'&action=add';
		put('<center><a class="student" href="'.$ajouter.'" >'.IMG_ADD.'&nbsp;'.$ad_titre['ajtgroupe'].'</a></center>');
		BR();

		if ( $gusertype == TUTEUR ) {
			$grp = $ClsGroupe->read($guserid);
		} elseif ( $gusertype == ADMIN ) {
			$grp = $ClsGroupe->read() ;
		} else {
			die('Erreur...');
		}

		for($i=0;$i<$grp['cnt'];$i++) {
			BeginBorder("90%",$color3);	
			SubTitleImage(CSS($grp[$i]['name']).' ['.CSS($grp[$i]['code']).']',IMG_GRP);
			InitTableau();
			DebutLigne();
			$lstudent = '' ;
			$lmodule  = '' ;			
			if ( $i != 0 ) {
				$lstudent	= PAGE.'&action=liste_stagiaire&id='.$grp[$i]['id'];
				$lstudent 	= "onClick=\"openWindow('".$lstudent."','list_sudent','scrollbars=yes,width=500,height=590')\" ";			
				$lstudent	= '<a class="student" href="#" '.$lstudent.' >'.IMG_MODIF.'</a>';
				$lmodule	= PAGE.'&action=ordre_module&id='.$grp[$i]['id'];
				$lmodule 	= "onClick=\"openWindow('".$lmodule."','list_sudent','scrollbars=yes,width=500,height=590')\" ";			
				$lmodule	= '<a class="student" href="#" '.$lmodule.' >'.IMG_MODIF.'</a>';			
			}			
			TitreTableau($ad_form['tuteur'],25);
			TitreTableau($lstudent.'&nbsp;'.$ad_form['stagiaire'],25);
			TitreTableau($lmodule.'&nbsp;'.$ad_form['modformat'],30);
			TitreTableau($ad_form['action'],20);
			FinLigne();
			$ret = $ClsMembre->readTuteur($grp[$i]['id']);
			$tuteur = '' ;
			for($j=0;$j<count($ret);$j++) {
				$tuteur.= CSS($ret[$j]).'<br>&nbsp;';
			}
			DebutLigne()	;
			ColTableau('&nbsp;'.$tuteur)	;
			$stu = $ClsGroupe->Members($grp[$i]['id']);
			$student = '' ;
			for($j=0;$j<$stu['cnt'];$j++) {
				$student.= CSS($stu[$j]['name']).'<br>&nbsp;';
			}
			ColTableau('&nbsp;'.$student)	;
			$mod = $ClsSession->read($grp[$i]['id']);
			$module = '' ;
			for($j=0;$j<$mod['cnt'];$j++) {
				$module.= CSS($mod[$j]['name']).'<br>&nbsp;';
			}				
			ColTableau('&nbsp;'.$module)	;
			$modif	= PAGE.'&action=modif&id='.$grp[$i]['id'];
			$lmodif	= '<a href="'.$modif.'" >'.IMG_MODIF.'</a>';
			$del	= PAGE.'&action=delete&id='.$grp[$i]['id'];
			$ldel	= '<a href="#" onclick="DeleteItem(\''.$del.'\');" >'.IMG_DEL.'</a>';
			$laction = '<center>'.$ldel.'&nbsp;'.$lmodif.'</center>';
			if ( $grp[$i]['id'] > 0 ) {
				ColTableau($laction);
			}else{
				ColTableau('&nbsp;')	;
			}			
			FinLigne()		;
			FermeTableau();
			BR();
			CloseBorder();
			BR();
		}
        GoTop();
     }

	/**
	* Supprime un item de la table
	* @access	public
	*/
	function del() {
		$this->liste();
	}

	/**
	* Affiche un formulaire pour modifier une societe
	* @access	public
	*/
	function modif() { 
		global $ad_menu, $ClsGroupe, $ad_texte ;
		GetTitre($ad_menu[3]);
		GoBack();
		$lstudent	= PAGE.'&action=liste_stagiaire&id='.ID;
		$lstudent 	= "onClick=\"openWindow('".$lstudent."','list_sudent','scrollbars=yes,width=500,height=590')\" ";			
		$lstudent	= '<a class="student" href="#" '.$lstudent.' >'.IMG_MODIF.' Modifier la liste des stagiaires pour ce groupe</a>';
		print('&nbsp;'.$lstudent)	;
		
		$ret = $ClsGroupe->readGroupe(ID);
        BeginFormulaire(PAGE.'&action=modif&id='.ID) ;
        AddText( $ad_texte['nomgroupe'],Unreplace($ret['name']),1) ;
        AddText( $ad_texte['codegroupe'],Unreplace($ret['code']),2,false,10) ;
        SelectTuteur(ID);
        //SelectStagiaire(ID);
        SelectModule(ID);
		EndFormulaire('VerifGroupe');
		GoTop();		
     }

	/**
	* Affiche un formulaire pour une societe
	* @access	public
	*/
	function add() {
		global $ad_menu, $ad_texte ;
		GetTitre($ad_menu[2]);
		GoBack();
		BeginFormulaire(PAGE.'&action=add');
		AddText($ad_texte['nomgroupe'],'',1);
		AddText($ad_texte['codegroupe'],'',2,false,10) ;	
		AddCheck($ad_texte['creatgroupe'],'creation',1,CREATE_DIR_GRP);
		SelectTuteur();
		SelectModule();
		EndFormulaire('VerifAddGroupe');
		GoTop();			
	}

	/**
	* Traitement des variables POST et redirection
	* @access	public
	*/	
	function traite_post() {
		global $HTTP_POST_VARS, $ClsAdmin ;
		if (count($HTTP_POST_VARS) > 0) {
			//debug($HTTP_POST_VARS);
			$name		= (isset($HTTP_POST_VARS['text1'])?trim($HTTP_POST_VARS['text1']):'')		;
			$code		= (isset($HTTP_POST_VARS['text2'])?trim($HTTP_POST_VARS['text2']):'')		;
			$planning	= ''; //trim($HTTP_POST_VARS['text2'])			;
			// recuperation des tuteurs
			$nbtuteur	= (isset($HTTP_POST_VARS['nbtuteur'])?$HTTP_POST_VARS['nbtuteur']:0)	;
			$checkTuteur= array();
			for ($i=0;$i<$nbtuteur;$i++) {
				if ( isset($HTTP_POST_VARS['checkTuteur'.$i]) && $HTTP_POST_VARS['checkTuteur'.$i] != '' ) {
					$checkTuteur[] = $HTTP_POST_VARS['checkTuteur'.$i] ;
				}
			}
			// recuperation des modules
			$nbmodule	= (isset($HTTP_POST_VARS['nbmodule'])?$HTTP_POST_VARS['nbmodule']:0)	;
			$checkModule= array();
			for ($i=0;$i<$nbmodule;$i++) {
				if ( isset($HTTP_POST_VARS['checkModule'.$i]) && $HTTP_POST_VARS['checkModule'.$i] != '' ) {
					$checkModule[] = $HTTP_POST_VARS['checkModule'.$i] ;
				}
			}
			$url = 	PAGE.'&action=liste';
			switch(ACTION) {
			case 'add'	:
				//debug($HTTP_POST_VARS);
				$creation	= ((isset($HTTP_POST_VARS['check1'])?$HTTP_POST_VARS['check1']:'') == 'creation')	;
				$idg = $ClsAdmin->ajouterUnGroupe($name,$code,$checkTuteur,$planning,$creation,$checkModule) ;
				if ( $idg < 0 ) {
					$idg = $idg * (-1) ;
					$repertoire = DIR_GRP.$idg 	;				
					$url = '<a class="student" href="'.PAGE.'&action=liste">Continuer</a>';
					messageError('Vous devez creer les rpertoires '.$repertoire.'/ et '.$repertoire.'/messages/',$url);					
				}
				location($url);
				exit();
				break ;
			case 'modif':
				$ClsAdmin->modifierUnGroupe(ID,$name,$code,$checkTuteur,$planning,$checkModule);
				location($url);
				exit();
				break ;
			case 'modif_liste_stagiaire':
				$nbstagiaire	= (isset($HTTP_POST_VARS['nbstagiaire'])?$HTTP_POST_VARS['nbstagiaire']:0)	;
				$checkStagiaire= array();
				for ($i=0;$i<$nbstagiaire;$i++) {
					if ( isset($HTTP_POST_VARS['checkStagiaire'.$i]) && $HTTP_POST_VARS['checkStagiaire'.$i] != '' ) {
						$checkStagiaire[] = $HTTP_POST_VARS['checkStagiaire'.$i] ;
					}
				}			
				$ClsAdmin->MergeMembreGroupe(ID,$checkStagiaire) ;
				location(PAGE.'&action=close_window&id='.ID);
				break ;
			case 'modif_ordre_module' :
				//debug($HTTP_POST_VARS);
				$nbsession	= (isset($HTTP_POST_VARS['nbsession'])?$HTTP_POST_VARS['nbsession']:0)	;
				$ordre = array();
				$module = array();
				for ($i=0;$i<$nbsession;$i++) {
					if ( isset($HTTP_POST_VARS['ordre'.$i]) && $HTTP_POST_VARS['ordre'.$i] != '' ) {
						$ordre[]  = $HTTP_POST_VARS['ordre'.$i] ;
						$module[] = $HTTP_POST_VARS['index'.$i] ;
					}
				}
				$ClsAdmin->OrdreSession(ID,$module,$ordre) ;
				location(PAGE.'&action=close_window&id='.ID);
				break;
			}
		}
	}

	/**
	* Traitement des variables GET et redirection
	* @access	public
	*/		
	function traite_get() {
		global $ClsAdmin ;
		if (is_numeric(ID) ) {
			switch(ACTION) {
			case 'delete':	
				$ClsAdmin->supprimerUnGroupe(ID) ;
				location(PAGE.'&action=liste');
				exit();
				break;
			}
		}
	}

} // class 


	/**
	* Instance de la classe PageGroupeAdmin
	* @var	object	PageGroupeAdmin
	*/
	$ClsPageAdmin = new PageGroupeAdmin ;


	/*
	* Gestion des pages de configurations des stagiaires par groupe 
	* et de l'ordre des modules pour la session
	*/
	if ( ACTION == 'liste_stagiaire') {
		InitPageHtml("Liste",false);
		GetTitre("Liste des stagiaires pour le groupe");
		//$ret = $ClsGroupe->readGroupe(ID);
        BeginFormulaire(PAGE.'&action=modif_liste_stagiaire&id='.ID) ;
        SelectStagiaire(ID);
		EndFormulaire();
		CloseWindow();
		die();
	} elseif (ACTION == 'ordre_module') {
		InitPageHtml("Ordre",false);
		GetTitre("Ordre des modules de la session");
		//$ret = $ClsSession->read(ID);
        BeginFormulaire(PAGE.'&action=modif_ordre_module&id='.ID) ;
        SelectSession(ID);
		EndFormulaire();
		CloseWindow();
		die();		
	} elseif ( ACTION == 'close_window' ) {
		InitPageHtml("Liste",false);
		print("<script>window.opener.location.reload();window.close();</script>");
		die();		
	} else {
		// Affichage de la page principale du menu groupe...
		pageAdmin() ;
	}

?>