<?PHP
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Free Web Based Training System                          //
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Plate-forme de tlformation gratuite et en open source //
// ------------------------------------------------------------------------- //
// Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>          //
// ------------------------------------------------------------------------- //
//            Developer : Georges CALDEIRA <gcaldeira@anemalab.org>          //
// ------------------------------------------------------------------------- //
//               Infos on project <http://anemalab.org/>                     //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

/**
* Page societe de la partie Admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaAdmin
*/
	/**
	* include des fichiers + verification de la cnx
	*/
	include_once("anema.inc.php");

	debugf(__FILE__);

	/**#@+
    * @access public
	* @ignore
	*/
	define('SUBMENU',	MENU_SOCIETE)	;	
	define('ACTION',	(isset($HTTP_GET_VARS['action'])?$HTTP_GET_VARS['action']:''))	;
	define('ID',		(isset($HTTP_GET_VARS['id'])?$HTTP_GET_VARS['id']:''))			;
	define('PAGE',		HTTP_ADMIN.$PAGE_ADMIN[SUBMENU]."?connexion=".$gconnexionid)	;
	/**#@-*/

/**
* Gestion de la page option de l'admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaAdmin
*/
class PageSocieteAdmin {

	/**
	* Affiche la liste des societes
	* @access	public
	*/
     function liste() { 
	 global $ad_menu, $ClsMembre, $ad_form, $ad_titre ;
	    GetTitre($ad_menu[1]);

		$ret = $ClsMembre->readCompany();
		$ajouter= PAGE.'&action=add';
		put('<center><a class="student" href="'.$ajouter.'" >'.IMG_ADD.$ad_titre['ajtsociete'].'</a></center><br>');

        InitTableau()	;
        DebutLigne()	;
        TitreTableau($ad_form['nom'],40)		;
        TitreTableau($ad_form['adresse'],40)	;
        TitreTableau($ad_form['action'],20);
        FinLigne()	;
        for( $i=0;$i<$ret['cnt'];$i++ ) {
            DebutLigne();
            ColTableau(CSS(Unreplace($ret[$i]['name'])));
            ColTableau(CSS(Unreplace($ret[$i]['adresse'])));
            $modif = PAGE.'&action=modif&id='.$ret[$i]['id'];
			$del = PAGE.'&action=delete&id='.$ret[$i]['id'];
			$laction = '<center><a href="#" onclick="DeleteItem(\''.$del.'\');" >'.IMG_DEL.'</a>&nbsp;';
			$laction.= '<a href="'.$modif.'" >'.IMG_MODIF.'</a></center>';
			ColTableau($laction);
            FinLigne()	;
        }
        FermeTableau()	;
        GoTop()			;
     }

	/**
	* Supprime un item de la table
	* @access	private
	*/
	function form($command,$field) {
		global $ad_texte;
		BeginFormulaire($command);
		$val1 = (isset($field[0])?$field[0]:'');
		$val2 = (isset($field[1])?$field[1]:'');
		$val3 = (isset($field[2])?$field[2]:'');
		AddText($ad_texte['nomsociete'],$val1,1);
		AddText($ad_texte['addsociete1'],$val2,2,false);
		AddText($ad_texte['addsociete2'],$val3,3,false);
		EndFormulaire("VerifSociete");
	}

	/**
	* Supprime un item de la table
	* @access	public
	*/
	function del() {
		$this->liste();
	}

	/**
	* Affiche un formulaire pour modifier une societe
	* @access	public
	*/
     function modif() { 
		global $ad_menu, $ClsMembre  ;
	    GetTitre($ad_menu[3]);
		GoBack();
		$ret = $ClsMembre->readCompany(ID);
		$field = array() ;
		$field[] = Unreplace($ret['name']) ;
		$field[] = Unreplace($ret['adresse']) ;
		$field[] = Unreplace($ret['adresse_facturation']) ;
		$this->form(PAGE.'&action=modif&id='.ID,$field)	;
        GoTop();
     }

	/**
	* Affiche un formulaire pour une societe
	* @access	public
	*/
	function add() {
		global $ad_menu  ;
	    GetTitre($ad_menu[2]);
		GoBack();
		$field = array() ;
		$this->form(PAGE.'&action=add',$field)	;
        GoTop();
	}

	/**
	* Traitement des variables POST et redirection
	* @access	public
	*/	
	function traite_post() {
		global $HTTP_POST_VARS, $ClsAdmin ;
		if (count($HTTP_POST_VARS) > 0) {
			$desc		= trim($HTTP_POST_VARS['text1']);
			$adresse	= trim($HTTP_POST_VARS['text2']);
			$adressef	= trim($HTTP_POST_VARS['text3']);
			$url = 	PAGE.'&action=liste';
			switch(ACTION) {
			case 'add'	:	
				$ClsAdmin->ajouterUneSociete($desc,$adresse,$adressef);
				location($url);
				exit();
				break;
			case 'modif':	
				$ClsAdmin->modifierUneSociete(ID,$desc,$adresse,$adressef);
				location($url);
				exit();
				break;			
			}
		}
	}

	/**
	* Traitement des variables GET et redirection
	* @access	public
	*/		
	function traite_get() {
		global $ClsAdmin ;
		if (is_numeric(ID) ) {
			switch(ACTION) {
			case 'delete':	
				$ClsAdmin->supprimerUneSociete(ID) ;
				location(PAGE.'&action=liste');
				exit();
				break;
			}
		}
	}

} // class 


/**
* Instance de la classe PageSocieteAdmin
* @var	object	PageSocieteAdmin
*/
$ClsPageAdmin = new PageSocieteAdmin ;
	
	// Affichage de la page
	pageAdmin();

?>