<?PHP
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Free Web Based Training System                          //
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Plate-forme de tlformation gratuite et en open source //
// ------------------------------------------------------------------------- //
// Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>          //
// ------------------------------------------------------------------------- //
//            Developer : Georges CALDEIRA <gcaldeira@anemalab.org>          //
// ------------------------------------------------------------------------- //
//               Infos on project <http://anemalab.org/>                     //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

/**
* Page tuteur de la partie Admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaAdmin
*/
	/**
	* include des fichiers + verification de la cnx
	*/
	include_once("anema.inc.php");
	
	debugf(__FILE__);
	
	/**#@+
    * @access public
	* @ignore
	*/
	define('SUBMENU',	MENU_TUTEUR)	;
	define('ACTION',	(isset($HTTP_GET_VARS['action'])?$HTTP_GET_VARS['action']:''))	;
	define('ID',		(isset($HTTP_GET_VARS['id'])?$HTTP_GET_VARS['id']:''))			;
	define('FILTRE',	(isset($HTTP_GET_VARS['filtre'])?$HTTP_GET_VARS['filtre']:''))	;		
	define('PAGE',		HTTP_ADMIN.$PAGE_ADMIN[SUBMENU]."?connexion=".$gconnexionid)	;
	define('PAGE_DIR',	HTTP_COMMUN."p_filemanager.php?connexion=".$gconnexionid)	;	
	/**#@-*/
	
/**
* Gestion de la page tuteur de l'admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaAdmin
*/
class PageTuteurAdmin {
		
	/**
	* Affiche la liste des stagiaires par ordre alphabetique.
	* @access	public
	*/	
	function liste_tutor() {
		global $ad_menu,$color1, $color3, $color1a, $ClsMembre, $ad_form, $ad_texte ;
		GetTitre($ad_menu[1]);
		GoBack();		
		BeginBorder("80%",$color1);
		$filtrer= PAGE.'&action=liste_tutor&filtre=';
		$filtre = (FILTRE == ''?'A':FILTRE);
		put('
		<table width="100%" border="0" cellspacing="0" cellpadding="1">
		<tr align="center" valign="middle"> ');
		for($i=65;$i<91;$i++) {
			$car = chr($i);
			if ( $car == $filtre ) {
				print('<td  bgcolor="'.$color1a.'">'.$car.'</td>');				
			} else {
				if ( ($i%2)==0 ) {
					print('<td  bgcolor="#FFFFFF"><a class="student" href="'.$filtrer.$car.'">'.$car.'</a></td>');
				} else {
					print('<td><a class="student" href="'.$filtrer.$car.'">'.$car.'</a></td>');
				}
			}
		}		

		if ( "all" == $filtre ) {
			print('<td  bgcolor="'.$color1a.'">'.$ad_texte['allt'].'</td>');				
		} else {
			if ( ($i%2)==0 ) {
				print('<td  bgcolor="#FFFFFF"><a class="student" href="'.$filtrer.'all">'.$ad_texte['allt'].'</a></td>');
			} else {
				print('<td ><a class="student" href="'.$filtrer.'all">'.$ad_texte['allt'].'</a></td>');
			}
		}

		print('</tr><tr>');
		for($i=0;$i<27;$i++) { print('<td  bgcolor="'.$color1a.'">&nbsp;</td>');}
		print('</tr></table>');	

		CloseBorder();	
		BR(2);
		$ret = $ClsMembre->filtrer($filtre,false);
		SubTitle($ad_texte['filtre'].' => '.$filtre.'<br>&nbsp;'.$ad_texte['nombre'].' => '.$ret['cnt']);
		BR();
		BeginBorder("90%",$color3);	
		BR() ;
		InitTableau()	;
		DebutLigne()	;
		TitreTableau($ad_form['nom'],30)	;
		TitreTableau($ad_form['nbcnx'],25)	;
		TitreTableau($ad_form['lastcnx'],25);
		TitreTableau($ad_form['action'],20)	;
		FinLigne()		;
		for($i=0;$i<$ret['cnt'];$i++) {				
			DebutLigne();		
			ColTableau('&nbsp;'.CSS(Unreplace($ret[$i]['name'])));
			ColTableau('&nbsp;'.Unreplace($ret[$i]['nbcnx']));
			ColTableau('&nbsp;'.Unreplace($ret[$i]['cnx']))	;
			$del	= PAGE.'&action=delete&id='.$ret[$i]['id']	;
			$ldel 	= '<a href="#" onclick="DeleteItem(\''.$del.'\');" >'.IMG_DEL.'</a>' ;
    	    $lmodif = '<a href="'.PAGE.'&action=modif&id='.$ret[$i]['id'].'" >'.IMG_MODIF.'</a>' ;				
    	    $laction= '<center>'.$ldel.'&nbsp;'.$lmodif.'</center>' ;
			ColTableau($laction) ;
			FinLigne();				
		}
		FermeTableau();
		BR();
		CloseBorder();			
		GoTop();
	}
		
	/**
	* Affiche la liste des tuteurs
	* @access	public
	*/
     function liste() { 
	 global $TBL, $db, $ClsMembre, $ad_menu, $ad_form, $ad_titre ;
	    GetTitre($ad_menu[1]);

		$ajouter= PAGE.'&action=add' ;
		$lister= PAGE.'&action=liste_tutor';				
		put('<center><a class="student" href="'.$ajouter.'" >'.IMG_ADD.$ad_titre['ajttut'].'</a>');
		put('&nbsp;&nbsp;&nbsp;<a class="student" href="'.$lister.'" >'.IMG_RIGHT.'&nbsp;'.$ad_titre['listtut'].'</a></center><br>');	

        InitTableau()	;
        DebutLigne()	;
		TitreTableau($ad_form['nom'],30)	;
		TitreTableau($ad_form['nbcnx'],25)	;
		TitreTableau($ad_form['lastcnx'],25);
		TitreTableau($ad_form['action'],20)	;
        FinLigne() ;
		$ret = $ClsMembre->listTuteur();
        for( $i=0;$i<$ret['cnt'];$i++) {
            DebutLigne();
            ColTableau('&nbsp;'.CSS(Unreplace($ret[$i]['name'])));
            ColTableau('&nbsp;'.$ret[$i]['nbcnx']);
            ColTableau('&nbsp;'.($ret[$i]['cnx']));
			$del = PAGE.'&action=delete&id='.$ret[$i]['id'];
			$ldel = '<a href="#" onclick="DeleteItem(\''.$del.'\');" >'.IMG_DEL.'</a>';
			$modif = PAGE.'&action=modif&id='.$ret[$i]['id'];
			$lmodif= '<a href="'.$modif.'" >'.IMG_MODIF.'</a>';
			$laction = '<center>'.$ldel.'&nbsp;'.$lmodif.'</center>';
            ColTableau($laction);
            FinLigne();
        }
        FermeTableau();
        GoTop();
     }

	/**
	* Supprime un item de la table
	* @access	public
	*/
	function del() {
		$this->liste();
	}

	/**
	* Affiche un formulaire pour modifier un tuteur
	* @access	public
	*/
     function modif() { 
		global $ad_menu, $ad_texte, $ClsMembre  ;
	    GetTitre($ad_menu[3]);
		GoBack();
		$ret = $ClsMembre->GetFiche(ID);
		BeginFormulaire(PAGE.'&action=modif&id='.ID); 
		AddText($ad_texte['prenom'],$ret['prenom'],1)	;
		AddText($ad_texte['nom'],$ret['nom'],2)		;
		AddText($ad_texte['login'],$ret['login'],3)	;
		AddPassword($ad_texte['pwd'],$ret['password'],4);
		AddText($ad_texte['email'],$ret['email'],5,false);
		AddListeSociete($ret['id_societe'],false);
		AddTextFile($ad_texte['cv'],$ret['cv'],7,CMD_FILE_CV,false);
		EndFormulaire('VerifMembre')	;
        GoTop();		
     }

	/**
	* Affiche un formulaire pour un tuteur
	* @access	public
	*/
	function add() {
		global $ad_menu, $HTTP_POST_VARS, $ClsMembre, $ad_texte  ;
	    GetTitre($ad_menu[2]);
		GoBack();
		BeginFormulaire(PAGE.'&action=add'); 
		AddText($ad_texte['prenom'],'',1)	;
		AddText($ad_texte['nom'],'',2)	;
		AddText($ad_texte['login'],'',3)	;
		AddPassword($ad_texte['pwd'],'',4);
		AddText($ad_texte['email'],'',5,false);
		AddListeSociete(AUCUN,false);
		AddTextFile($ad_texte['cv'],'',7,CMD_FILE_CV,false)	;	
		EndFormulaire('VerifMembre');
    	GoTop();			
	}


	/**
	* Traitement des variables POST et redirection
	* @access	public
	*/	
	function traite_post() {
		global $HTTP_POST_VARS, $ClsAdmin ;
		if (count($HTTP_POST_VARS) > 0) {				
			$prenom		= trim($HTTP_POST_VARS['text1'])	;
			$nom		= trim($HTTP_POST_VARS['text2'])	;
			$login		= trim($HTTP_POST_VARS['text3'])	;
			$password	= trim($HTTP_POST_VARS['text4'])	;
			$email		= trim($HTTP_POST_VARS['text5'])	;
			$cv			= trim($HTTP_POST_VARS['text7'])	;
			$idsociete	= $HTTP_POST_VARS['LSociete']		;
			$url 		= PAGE.'&action=liste';
			switch(ACTION) {
			case 'add'	:	
				$res = $ClsAdmin->ajouterUnTuteur($prenom,$nom,$login,$password,$email,$idsociete,$cv);
				location($url);
				exit();
				break;
			case 'modif':	
				$res = $ClsAdmin->modifierUnTuteur(ID,$nom,$prenom,$email,$login,$password,$cv,$idsociete);					
				location($url);
				exit();
				break;			
			}
		}
	}

	/**
	* Traitement des variables GET et redirection
	* @access	public
	*/		
	function traite_get() {
		global $ClsMembre ;	
		if (is_numeric(ID) ) {
			switch(ACTION) {
			case 'delete':	$ClsMembre->del(ID,TUTEUR);
							location(PAGE.'&action=liste');
							exit();
							break;
			}
		}
	}

} // class 


/**
* Instance de la classe PageTuteurAdmin
* @var	object	PageTuteurAdmin
*/
$ClsPageAdmin = new PageTuteurAdmin ;

	
	// Affichage de la page
	pageAdmin();

?>