<?PHP
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Fournit une API pour la gestion de l'admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Gestion de l'admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Admin {

	/**
	* Traite l'erreur du login/pwd/Email
	* @param	integer	$err 	valeur de l'erreur
	* @access	public
	*/		
	function traiteLoginPwdEmail($err) {
		switch($err){
		case ERR_LOGIN_PWD : messageError('erreur login/mot de passe ');
		case ERR_EMAIL_INVALID : messageError("L'Email n'est pas valide !!! ");
		case ERR_EMAIL_USED: messageError('Email deja utilis !!! ');
		}
	}
					
	/**
	* Verifie les logins et les mels.
	* @param	integer	$id 	ID du membre
	* @param	string	$login	login du membre	
	* @param	string	$password	password du membre			
	* @param	string	$email	email du membre
	* @access	public
	*/	
	function verifLoginPwdEmail($id,$login,$password,$email) {
		global $ClsMembre ;
		if ( !$ClsMembre->VerifPwdLogin($password,$login,$id) ) {
			$this->traiteLoginPwdEmail(ERR_LOGIN_PWD);
		}
		if ( $email != '') {
			if ( ! isEmail($email) ) {
				$this->traiteLoginPwdEmail(ERR_EMAIL_INVALID);
			} else {
				if ( $ClsMembre->emailExist($id,$email) ) {
					$this->traiteLoginPwdEmail(ERR_EMAIL_USED);
				}
			}
		}		
		return(OK);
	}
	/**
	* Modifie le user admin
	* @param	integer	$id 	ID du membre
	* @param	string	$nom	nom du membre
	* @param	string	$prenom prenom du membre
	* @param	string	$email	email du membre
	* @param	string	$login	login du membre
	* @param	string	$password	password du membre	
	* @access	public
	*/
	function modifierUserAdmin($id,$nom,$prenom,$email,$login,$password) {
		global $ClsMembre ;
		$res = $this->verifLoginPwdEmail($id,$login,$password,$email) ;
		$ClsMembre->update(ID,$nom,$prenom,$email,$login,$password,'',0);		
		return(OK);
	}	

	/**
	* supprime un groupe
	* @param	integer	$id 	ID du groupe
	* @access	public
	*/
	function supprimerUnGroupe($id) {
		global $ClsGroupe, $ClsDocument, $ClsWebMail, $ClsSession, $ClsTracking ;
		if ( CREATE_DIR_GRP ) {
			$rep = $ClsGroupe->Directory($id);
			deldir(RP_GROUPES.$rep)		;
		}
		DeletePhorum($id)				;
		$ClsDocument->DeleteGroupe($id)	;
		$ClsWebMail->DeleteGroupe($id)	;
		$ClsSession->DeleteGroupe($id)	;
		$ClsTracking->DelGroupe($id)	;
		$ClsGroupe->del($id) 			;
		return(OK);
	}		

	/**
	* modifie un groupe
	* @param	integer	$idg 	ID du groupe
	* @param	string	$name 	nom du groupe
	* @param	string	$code 	code du groupe
	* @param	array	$tabtut 	liste des tuteurs
	* @param	string	$planning 	planning du groupe
	* @param	array	$tabmodule 	liste des modules	
	* @access	public
	*/
	function modifierUnGroupe($idg,$name,$code,$tabtut,$planning,$tabmodule) {
		global $ClsGroupe, $ClsPhorum, $ClsSession ;
		$ClsGroupe->update($idg,$name,$code,$tabtut,$planning);
		$ClsSession->update($idg,$tabmodule);
		SetPhorumName($idg,$name);
		return(OK);
	}

	/**
	* modifie un groupe
	* @param	integer	$idg 	ID du groupe
	* @param	array	$stagiaire 	liste des stagiaire	
	* @access	public
	*/
	function MergeMembreGroupe($idg,$stagiaire) {
		global $ClsGroupe ;
		$ret = $ClsGroupe->Members(ID);
		$old = array() ;
		for($i=0;$i<$ret['cnt'];$i++) {
			$old[] = $ret[$i]['id'];
		}
		$ClsGroupe->MergeMembreGroupe($idg,$old,$stagiaire) ;
		return(OK);
	}
	
	
	/**
	* ajoute un groupe
	* @param	string	$name 	nom du groupe
	* @param	string	$code 	code du groupe
	* @param	array	$tabtut 	liste des tuteurs
	* @param	string	$planning 	planning du groupe
	* @param	boolean	$creation 	creation du repertoire groupe	
	* @param	array	$tabmodule 	liste des modules
	* @access	public
	*/
	function ajouterUnGroupe($name,$code,$tabtut,$planning,$creation,$tabmodule) {
		global $ClsGroupe, $ClsSession ;
		$idg = $ClsGroupe->add($name,$code,$tabtut,$planning,$creation)	;
		$ClsSession->add($idg,$tabmodule);
		if ( ! $creation ) {
			return(-$idg);
		}		
		return(OK);
	}

	/**
	* supprime un module
	* @param	integer	$id 	ID du module
	* @access	public
	*/
	function supprimerUnModule($id) {
		global $ClsModule, $ClsTracking, $ClsSession, $ClsFormation ;
		$ClsModule->del($id) ;
		$ClsTracking->delModule($id,0)	;
		$ClsSession->delModule($id,0)	;
		$ClsFormation->delModule($id)	;		
		return(OK);
	}	

	/**
	* Ajoute un module
	* @param	string	$titre	titre du module
	* @param	string	$code	code du module
	* @param	integer	$aut	id de l'auteur
	* @param	string	$support	support du module
	* @access	public
	*/
	function ajouterUnModule($titre,$code,$aut,$support) {
		global $ClsModule ;
		return($ClsModule->add($titre,$code,$aut,$support));
	}

	/**
	* Ajoute un nouveau chapitre a un module
	* @param	integer	$idm	id du module
	* @param	integer	$norme	norme du chapitre
	* @param	integer	$type	type du chapitre
	* @param	string	$chap	nom du chapitre
	* @param	string	$fic	fichier du chapitre
	* @access	public
	*/
	function ajouterUnChapitre($idm,$norme,$type,$chap,$fic) {
		global $ClsModule ;
		$ClsModule->addChapitre($idm,$norme,$type,$chap,$fic);
		return(OK);
	}

	/**
	* maj d'un module
	* @param	integer	$idm	id du module	
	* @param	string	$titre	titre du module
	* @param	string	$code	code du module
	* @param	integer	$aut	id de l'auteur
	* @param	string	$support	support du module
	* @access	public
	*/
	function modifierUnModule($idm,$titre,$code,$aut,$support) {
		global $ClsModule ;
		$ClsModule->update($idm,$titre,$code,$aut,$support);
		return(OK);
	}
	
	/**
	* met a jour un chapitre
	* @param	integer	$idm	id du module
	* @param	integer	$numero	numero du chapitre
	* @param	integer	$norme	norme du chapitre
	* @param	integer	$type	type du chapitre
	* @param	string	$chap	nom du chapitre
	* @param	string	$fic	fichier du chapitre
	* @access	public
	*/
	function modifierUnChapitre($idm,$numero,$norme,$type,$chap,$fic) {
		global $ClsModule ;
		$ClsModule->updateChapitre($idm,$numero,$norme,$type,$chap,$fic);
		return(OK);
	}

	/**
	* augmente un numero de chapitre
	* @param	integer	$idm	id du module
	* @param	integer	$numero	numero du chapitre
	* @access	public
	*/
	function augmenterNumeroChapitre($idm,$numero) {
		global $ClsModule ;
		$ClsModule->swapNumeroChapitre($idm,$numero,$numero+1);
		return(OK);
	}

	/**
	* diminue un numero de chapitre
	* @param	integer	$idm	id du module
	* @param	integer	$numero	numero du chapitre
	* @access	public
	*/
	function diminuerNumeroChapitre($idm,$numero) {
		global $ClsModule ;
		$ClsModule->swapNumeroChapitre($idm,$numero,$numero-1);
		return(OK);
	}
	
	/**
	* supprime un chapitre
	* @param	integer	$id 	ID du module
	* @param	integer	$numero	ID du chapitre
	* @access	public
	*/
	function supprimerUnChapitre($id,$numero) {
		global $ClsModule, $ClsTracking ;
		$ClsModule->delChapitre($id,$numero)	;
		$ClsTracking->delChapitre($id,$numero)	;
		return(OK);
	}	
		
	/**
	* supprime une societe
	* @param	integer	$id 	ID de la societe
	* @access	public
	*/
	function supprimerUneSociete($id) {
		global $ClsMembre ;
		$ClsMembre->delCompany($id) ;
		return(OK);
	}	
		
	/**
	* Ajoute une nouvelle societe.
	* @param	string	$desc	description de la societe
	* @param	string	$adresse	adresse de la soc.
	* @param	string	$adressef	adresse de facturation de la soc.
	* @access	public
	*/
	function ajouterUneSociete($desc,$adresse,$adressef) {
		global $ClsMembre ;
		$ClsMembre->addCompany($desc,$adresse,$adressef);
		return(OK);
	}
		
	/**
	* MAJ une nouvelle societe.
	* @param	integer	$id	id de la societe
	* @param	string	$desc	description de la societe
	* @param	string	$adresse	adresse de la soc.
	* @param	string	$adressef	adresse de facturation de la soc.
	* @access	public
	*/
	function modifierUneSociete($id,$desc,$adresse,$adressef) {
		global $ClsMembre ;
		$ClsMembre->updateCompany($id,$desc,$adresse,$adressef);
	}

	/**
	* supprime un stagiaire
	* @param	integer	$id 	ID de la societe
	* @access	public
	*/
	function supprimerUnStagiaire($id) {
		global $ClsMembre ;
		$ClsMembre->del($id,STAGIAIRE) ;
		return(OK);
	}		

	/**
	* modifier un stagiaire
	* @param	integer	$id		Id du membre
	* @param	string	$nom	Nom du membre
	* @param	string	$prenom	prenom du membre
	* @param	string	$email	Email du membre
	* @param	string	$login	Login du membre
	* @param	string	$pwd	Mot du passe du membre
	* @param	string	$cv		cv du membre
	* @param	integer	$societe	id de la societe
	* @param	array	$groupes	liste des groupes	
	* @access	public
	*/
	function modifierUnStagiaire($id,$nom,$prenom,$email,$login,$pwd,$cv,$societe,$groupes) {
		global $ClsMembre, $ClsGroupe ;
		$res = $this->verifLoginPwdEmail($id,$login,$pwd,$email) ;
		$idgroupe = (is_array($groupes) && count($groupes)>0 ?$groupes[0]:0) ;		
		$ClsMembre->update($id,$nom,$prenom,$email,$login,$pwd,$cv,$societe,$idgroupe);
		$ClsGroupe->updateMembreGroupe($id,$groupes);
		return(OK);
	}		
		
	/**
	* ajouter un stagiaire
	* @param	string	$prenom	prenom du membre	
	* @param	string	$nom	Nom du membre
	* @param	string	$login	Login du membre
	* @param	string	$pwd	Mot du passe du membre	
	* @param	string	$email	Email du membre	
	* @param	integer	$societe	id de la societe	
	* @param	string	$cv		cv du membre
	* @param	array	$groupes	liste des groupes	
	* @access	public
	*/
	function ajouterUnStagiaire($prenom,$nom,$login,$pwd,$email,$societe,$cv,$groupes) {
		global $ClsMembre, $ClsGroupe ;
		$res = $this->verifLoginPwdEmail(-1,$login,$pwd,$email) ;
		$idgroupe = (is_array($groupes) && count($groupes)>0 ?$groupes[0]:0) ;
		$idu = $ClsMembre->add($prenom,$nom,$login,$pwd,$email,$societe,$cv,STAGIAIRE,$idgroupe);
		$ClsGroupe->addMembreGroupe($idu,$groupes);
		return(OK);
	}	

	/**
	* ajouter un tuteur
	* @param	string	$prenom	prenom du membre	
	* @param	string	$nom	Nom du membre
	* @param	string	$login	Login du membre
	* @param	string	$pwd	Mot du passe du membre	
	* @param	string	$email	Email du membre	
	* @param	integer	$societe	id de la societe	
	* @param	string	$cv		cv du membre
	* @param	array	$groupes	liste des groupes	
	* @access	public
	*/
	function ajouterUnTuteur($prenom,$nom,$login,$pwd,$email,$societe,$cv) {
		global $ClsMembre ;
		$res = $this->verifLoginPwdEmail(-1,$login,$pwd,$email) ;
		$idu = $ClsMembre->add($prenom,$nom,$login,$pwd,$email,$societe,$cv,TUTEUR,0);
		return(OK);
	}	

	/**
	* modifier un tuteur
	* @param	integer	$id		Id du membre
	* @param	string	$nom	Nom du membre
	* @param	string	$prenom	prenom du membre
	* @param	string	$email	Email du membre
	* @param	string	$login	Login du membre
	* @param	string	$pwd	Mot du passe du membre
	* @param	string	$cv		cv du membre
	* @param	integer	$societe	id de la societe
	* @param	array	$groupes	liste des groupes	
	* @access	public
	*/
	function modifierUnTuteur($id,$nom,$prenom,$email,$login,$pwd,$cv,$societe) {
		global $ClsMembre	 ;
		$res = $this->verifLoginPwdEmail($id,$login,$pwd,$email) ;
		if ( OK <> $res ) {
			return($res);
		}	
		$ClsMembre->update($id,$nom,$prenom,$email,$login,$pwd,$cv,$societe);
		return(OK);
	}	
	
	/**
	* modifier un tuteur
	* @param	integer	$idg	Id du groupe
	* @param	string	$module	tableau id des modules
	* @param	string	$ordre	tableau ordre des modules
	* @access	public
	*/
	function OrdreSession($idg,$module,$ordre) {
		global $ClsSession	 ;
		for($i=0;$i<count($module);$i++) {
			$ClsSession->order($idg,$module[$i],$ordre[$i]);
		}
		return(OK);
	}		
		
 } // class Admin


/**
* Instance de la classe Admin
* @var	object	Admin
*/
 $ClsAdmin = new Admin ;

?>