<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion de la connexion a la bdd
* On utilise la librarie <a href="http://www.phplib.de">PhpLib</a>
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/

/**
* Definir ici le type de base de donnees utilise. Par defaut Ganesha utilise MYSQL
* Ces fichiers sont pris dans la librairie PhpLib <http://www.phplib.de>
*/
include_once(RP_PHPLIB."db_mysql.inc.php");

/**
* Fournit une API pour acceder a la bdd.
* On utilise la librarie <a href="http://www.phplib.de">PhpLib</a>
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class DB_Ganesha extends DB_Sql {
    
	/**#@+
    * @access private
    * @var string
	*/
	var $Host     = '' ;
	var $Database = '' ;
	var $User     = '' ;
	var $Password = '' ;
	/**#@-*/
	
	/**
	* Constructeur. Initialise la config de la base de donnees
	* @access	public
	*/
	function DB_Ganesha() {
	 global $BDD ;
		$this->Host     = $BDD['server']	;
		$this->Database = $BDD['name']	;
		$this->User     = $BDD['user']	;
		$this->Password = $BDD['pass']	;
	}

	/**
	* Surcharge de la methode query. Permet de logger les rqt.
	* @access	public
	*/	
	function query($Query_String,$debug=0) {
		if ( $debug != 0 ) {
			debug($Query_String);
		}
		if(!is_int(strpos($Query_String,'password'))) {
			if ( function_exists('TraceSQL') ) {
				TraceSQL($Query_String);
			}
		}
		return(parent::query($Query_String));
	}
		
} //fin class DB_Ganesha

/**
* Instance de la classe DB_Ganesha
* @var	object	DB_Ganesha
*/
$db = new DB_Ganesha ;

?>