<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+
/**
* Gestion des documents.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour la gestion des documents
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Document {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private	
	*/
	var $_db ;

	/**
	* Constructeur. Initialise la connexion locale de la classe 
	* @access	public
	*/
	function Document() {
		$this->_db = new DB_Ganesha ;
	}

	/**
	* lister les documents d'un groupe
	* @param	integer	$idg ID du groupe
	* @access	public
	* @see		NextItem()
	*/
	function Lister($idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment "	;
		$sSQL.= "FROM ".$TBL['document']." d, ".$TBL['membres']." u ";
		$sSQL.= "WHERE d.groupe=".$idg." AND d.prop=u.id AND d.priv=0 "	;
		$sSQL.= "ORDER BY d.id DESC";
		$db->query($sSQL)	;
		$i = 0 ;
		$ret['cnt'] = $db->num_rows() ;
		while( $db->next_record() ) {
			$ret[$i]['id']		= $db->f("id")				;
			$ret[$i]['user']	= $db->f("prenom")." ".$db->f("nom")	;
			$ret[$i]['titre']	= Unreplace($db->f("titre"))	;
			$ret[$i]['comment']	= Unreplace($db->f("comment"));
			$ret[$i]['date']	= $db->f("date")				;
			$ret[$i]['file']	= $db->f("fichier")			;
			$ret[$i]['size']	= $db->f("taille")			;
			$ret[$i]['nb']		= $db->f("nbcomment")		;
			$i++ ;
		}
		return($ret);
	}

	/**
	* Supprime un document de la bdd et du disque.
	* @param	integer	$idd ID du document a supprimer
	* @return	string	Retourne un message indiquant la reussite ou l'echec de la suppression
	* @access	public
	*/
	function Del($idd) {
	 global $TBL, $groupe, $ClsGroupe ;
	 global $tu_texte, $db ;
		$ret = $this->Read($idd)	;
		$rep =  $ClsGroupe->Directory($groupe)						;
		DeleteDocument(RP_GROUPES.$rep."/".$ret['file'])	;
		$msg = $tu_texte['suppdoc']									;
		$sSQL = "DELETE FROM ".$TBL['document']." WHERE id=".$idd	;
		if ( ! $db->query($sSQL) ) {
			return($tu_texte['errorsupp']) ;
		}
		return($msg) ;
	}

	/**
	* Supprime tous les documents d'un groupe
	* @param	integer	$idg ID du groupe a supprimer
	* @return	boolean	0 si la suppression est ok, 1 sinon 
	* @access	public
	*/
	function DeleteGroupe($idg) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['document']." WHERE groupe=".$idg ;
		if ( ! $db->query($sSQL) ) {
			return(ERROR);
		}
		return(OK);
	}

	/**
	* Ajoute un Document sur le serveur et dans la base de donnees
	* @param	integer	$idu	ID du membre
	* @param	array	$fichier	description du fichier a copier
	* @param	integer	$comment	Description du fichier
	* @param	integer	$titre	Titre associe au fichier
	* @return	string	Retourne un message indiquant la reussite ou l'echec de l'ajout
	* @access	public
	* @see		Read()
	*/
	function Add($idu,$fichier,$comment,$titre ){ 
	 global $ClsMembre, $groupe, $ClsGroupe, $TBL, $gusertype; 
	 global $guser, $db ;
	 global $tu_texte ;
		if ( isset($fichier['fichier']['name']) && 
			 strlen($fichier['fichier']['name'])>0 && 
			 $fichier['fichier']['error']==0 
		   ) {
			if ( !OPT_UPLOAD_ACTIVE ) {
				return($tu_texte['errorupload']);
			}
			$rep = $ClsGroupe->Directory($groupe);
			$server_fichier = CopyDocument($idu,$groupe,$fichier);
			$date = getdate()						;
			$date = date(FORMATDATE ,$date["0"])	;
			$size = taille (RP_GROUPES.$rep."/".$server_fichier);
			$mycomment = (strlen(trim($comment))==0?"":"<DEB>".Replace($guser)." a crit le ".$date."<MID>".$comment."<FIN>") ;
			$nb   = (strlen($mycomment)==0?"0":"1")	;
			$sSQL = "INSERT INTO ".$TBL['document']." (titre,comment,fichier,prop,groupe,type,priv,date,taille,nbcomment)" ;
			$sSQL.= " VALUES ('".$titre."','".$mycomment."','".$server_fichier."'," ;
			$sSQL.= $idu.",".$groupe.",".$gusertype.",0,'".$date."', '".$size."',".$nb.")"	;
			$db->query($sSQL)	;
			$msg = $tu_texte['addoc']	;
		} else {
			$msg = $tu_texte['errordoc'].' error=> '.$fichier['fichier']['error'];
		}
		return($msg);
	}

	/**
	* Lit un document
	* @param	integer	$idd ID du document
	* @return	array	Retourne un tableau avec les informations du document ou sinon false
	* @access	public
	* @see		Add()
	*/
	function Read($idd) {
	 global $TBL, $db ;
		$sSQL = "SELECT d.id,u.prenom,u.nom,d.titre,d.comment,d.fichier,d.date,d.taille,d.nbcomment ";
		$sSQL.= "FROM ".$TBL['document']." d, ".$TBL['membres']." u " ;
		$sSQL.= "WHERE d.id=".$idd." AND d.prop=u.id "				;
		$sSQL.= "ORDER BY d.id DESC";
		$db->query($sSQL)			;
		if ( $db->next_record() ) {
			$ret['priv']	= $db->f("priv")					;
			$ret['user']	= Unreplace($db->f("prenom")." ".$db->f("nom"));
			$ret['titre']	= Unreplace($db->f("titre"))		;
			$ret['comment']	= Unreplace($db->f("comment"))		;
			$ret['date']	= $db->f("date")					;
			$ret['file']	= $db->f("fichier")					;
			$ret['size']	= $db->f("size")					;
			$ret['nb']		= $db->f("nbcomment")				;
			return($ret) ;
		}
		return(false);
	}

	/**
	* Ajoute un commentaire a un document
	* @param	integer	$idd ID du document
	* @param	integer	$comment commentaire a inserer 
	* @access	public
	*/
	function InsertComment($idd,$comment) {
	 global $guser, $TBL;
	 global $db ;
		$ret  = $this->Read($idd)	;
		$date = getdate()							;
		$date = date(FORMATDATE ,$date["0"])		;
		$m_nb = ($ret['nb']==""?"0":$ret['nb']+1)	;
		$myDesc = "<DEB>".Replace($guser)." a crit le ".$date."<MID>".Replace($comment)."<FIN>".addslashes($ret['comment']);
		$sSQL = "UPDATE ".$TBL['document']." SET comment='".$myDesc."', nbcomment=".$m_nb." WHERE id=".$idd	;
//		die($sSQL."<br>".get_magic_quotes_gpc());
		$db->query($sSQL)	;
	}


	/**
	* Retourne le nombre de documents
	* @param	integer	$idg	ID du groupe
	* @return	integer	Retourne le nombre de documents
	* @access	public
	*/
	function Nb($idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT id FROM ".$TBL['document']." WHERE groupe=".$idg ;
		$db->query($sSQL)		;
		return($db->num_rows())	;
	}

	/**
	* Retourne le nombre de documents poste par un membre
	* @param	integer	$idu	ID du membre
	* @param	integer	$idg	ID du groupe
	* @return	integer	Retourne le nombre de documents poste par un membre
	* @access	public
	*/
	function NbPost($idu,$idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT id FROM ".$TBL['document']." WHERE prop=".$idu." AND groupe=".$idg ;
		$db->query($sSQL);
		return($db->num_rows());
	}

 } // class WebMail 

/**
* Instance de la classe Document
* @var	object	Document
*/
$ClsDocument = new Document ;

?>