<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des inscriptions
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour gerer les inscriptions.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Inscription {

	/**
	* Lecture de tous les groupes
	* @access	public
	*/
	function read() {
		global $TBL, $db ;
        $sSQL = "SELECT DISTINCT(code),etat,nb,date FROM ".$TBL['inscription'] ;
		$db->query($sSQL)	;        
		$i = 0 ;
        while($db->next_record()) {
        	$code[$i]['code'] 	= $db->f(0);
        	$code[$i]['etat'] 	= $db->f(1);
        	$code[$i]['nb'] 	= $db->f(2);
        	$code[$i++]['date'] = $db->f(3);
        }
		$code['cnt'] = $db->num_rows();
		for($i=0;$i<$code['cnt'];$i++) {
        	$sSQL = "SELECT DISTINCT(g.name) FROM ".$TBL['inscription']." i,".$TBL['list_groupe']." g ";
        	$sSQL.= "WHERE i.id_groupe=g.id_groupe AND i.code='".addslashes($code[$i]['code'])."' ";
			$db->query($sSQL)	; 
			$j = 0 ;       			
	        while($db->next_record()) {
	        	if ( $db->f(0) != '' ) {
		        	$code[$i]['groupe'][$j++] = $db->f(0);
	        	}
	        }
		}
		return($code);
	}


	/**
	* Lecture de tous les groupes
	* @access	public
	*/
	function readInsciption($code) {
		global $TBL, $db ;
        $sSQL = "SELECT DISTINCT(code),etat,nb,date FROM ".$TBL['inscription']." " ;
        $sSQL.= "WHERE code='".$code."'" ;
		$db->query($sSQL)	;        
        $db->next_record();
    	$ret['code'] 	= $db->f(0);
    	$ret['etat']	= $db->f(1);
    	$ret['nb'] 		= $db->f(2);
    	$ret['date'] 	= $db->f(3);

    	$sSQL = "SELECT DISTINCT(g.name),g.id_groupe FROM ".$TBL['inscription']." i,".$TBL['list_groupe']." g ";
    	$sSQL.= "WHERE i.id_groupe=g.id_groupe AND i.code='".$code."' ";
		$db->query($sSQL)	; 
		$j = 0 ;       	
		$k = 0 ;	
        while($db->next_record()) {
        	if ( $db->f(0) != '' ) {
	        	$ret['groupe'][$j++] 	= $db->f(0);
	        	$ret['id_groupe'][$k++] = $db->f(1);
        	}
        }
		return($ret);
	}
	
	/**
	* Ajoute un nouveau groupe
	* @param	string	$name nom du groupe
	* @param	array	$tabtut table des tuteurs
	* @param	string	$planning planning du groupe
	* @param	boolean	$create creation des repertoires sur le serveur		
	* @access	public
	*/
	function add($code,$tabgrp) { 
		global $db, $TBL;
		$date = FormatDate() ;
		$db->query("DELETE FROM ".$TBL['inscription']." WHERE code='".$code."'") ;
		if ( is_array($tabgrp) && count($tabgrp)>0 ) {
			for ($i=0;$i<count($tabgrp);$i++) {
				$sSQL = "INSERT INTO ".$TBL['inscription']." ";
				$sSQL.= "(code,id_groupe,etat,nb,date) ";
				$sSQL.= "VALUES ('".$code."','".$tabgrp[$i]."','1','0','".$date."')";
				$db->query($sSQL)   ;
			}
		} else {
			$sSQL = "INSERT INTO ".$TBL['inscription']." ";
			$sSQL.= "(code,id_groupe,etat,nb,date) ";
			$sSQL.= "VALUES ('".$code."','0','1','0','".$date."')";
			$db->query($sSQL)   ;
		}
	}

	/**
	* Ajoute un nouveau groupe
	* @param	string	$code code inscription
	* @param	array	$tabgrp table des groupes
	* @param	string	$etat active/arrete
	* @param	string	$oldcode ancien code
	* @access	public
	*/
	function update($code,$tabgrp,$etat,$oldcode) {
		global $db, $TBL ;
		$old = $this->readInsciption($oldcode);
		$db->query("DELETE FROM ".$TBL['inscription']." WHERE code='".$oldcode."'") ;		
		$this->add($code,$tabgrp) ;
		$sSQL = "UPDATE ".$TBL['inscription']." ";
		$sSQL.= "SET date='".$old['date']."',nb='".$old['nb']."',etat='".$etat."' ";
		$sSQL.= "WHERE code='".$code."'";
		$db->query($sSQL) ;
	}

	/**
	* incremente le nombre d'inscription
	* @param	string	$code code inscription
	* @access	public
	*/
	function incr($code) {
		global $db, $TBL ;
		$sSQL = "UPDATE ".$TBL['inscription']." ";
		$sSQL.= "SET nb=nb+1 ";
		$sSQL.= "WHERE code='".$code."'";
		$db->query($sSQL) ;
	}
		
	/**
	* suppression d'un groupe
	* @param	string	$code code de l'inscription
	* @access	public
	*/
	function del($code) {
		global $db, $TBL ;
		$db->query("DELETE FROM ".$TBL['inscription']." WHERE code='".$code."'") ;		
	}


	/**
	* Verifie l'existence d'un code
	* @param	string	$code code de l'inscription
	* @access	public
	*/
	function codeExiste($code) {
		global $db, $TBL ;
		$sSQL = "SELECT * FROM ".$TBL['inscription']." WHERE code='".$code."' AND etat=1" ;	
		$db->query($sSQL);
		return($db->num_rows()>0);
	}

 } // class Inscription


/**
* Instance de la classe Inscription
* @var	object	Inscription
*/
 $ClsInscription = new Inscription ;

?>