<?
//---------------------------------------------------------------------------------------------------
//							
//	WebJeff - FileManager v1.6
//	
//	Jean-Franois GAZET
//	http://www.webjeff.org
//	webmaster@webjeff.org	
//
//---------------------------------------------------------------------------------------------------

/**
* Page gestionnaire de fichier
*
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaCommun
*/
	/**
	* include des fichiers + verification de la cnx
	*/
	include_once("anema.inc.php");

    if ( $gusertype != ADMIN && $gusertype != TUTEUR ) {
	    PageErreur();
	    exit()      ;
    }

	$max_caracteres	= 30	;
	
    /**#@+
    * @access public
	* @ignore
	*/	
	define('CMD',		(isset($HTTP_GET_VARS['cmd'])?$HTTP_GET_VARS['cmd']:''))	;
	define('ID',		(isset($HTTP_GET_VARS['id'])?$HTTP_GET_VARS['id']:''))		;
	define('FORM',		(isset($HTTP_GET_VARS['form'])?$HTTP_GET_VARS['form']:''))	;
	define('PAGE',		HTTP_COMMUN."p_filemanager.php?connexion=".$gconnexionid."&cmd=".CMD.'&id='.ID."&form=".FORM);
	define('IMAGE_DIR',	HTTP_IMAGES."filemanager/");
	define('CHMOD',		0775)	;
	define('ACTION',	(isset($HTTP_GET_VARS['action'])?$HTTP_GET_VARS['action']:''))	;
	define('FICHIER',	(isset($HTTP_GET_VARS['fichier'])?$HTTP_GET_VARS['fichier']:''));
	/**#@-*/
			
	$sens = (isset($HTTP_GET_VARS['sens'])?$HTTP_GET_VARS['sens']:'') 	;
	if ( $sens == '' ) $sens = 1 ;
	$rep  = (isset($HTTP_GET_VARS['rep'])?$HTTP_GET_VARS['rep']:'') 	;	

	$select_file = false ;
	$select_dir  = false ;
	$gtitre = 'pas de titre !!!!';
	switch(CMD) {
	case CMD_ALL :
		$gtitre = $wj_mess[100] ;
		$racine		= RP_MAIN	;
		$url_racine	= HTTP_MAIN;
		break;	
	case CMD_FILE_CV :
		$gtitre = $wj_mess[101] ;
		$select_file= true ;	
		$racine		= RP_CV	;
		$url_racine	= HTTP_CV;	
		break;
	case CMD_DIR_FORMATION :
		$gtitre = $wj_mess[102]	;
		$select_dir = true ;
		$racine		= RP_FORMATION	;
		$url_racine	= HTTP_FORMATION;
		break;		
	case CMD_FILE_FORMATION :
		$gtitre = $wj_mess[103] 		;
		$select_file= true ;
		$racine		= RP_FORMATION	;
		$url_racine	= HTTP_FORMATION;
		break;		
	case CMD_LIST_FORMATION :
		$gtitre = $wj_mess[104]	;
		$racine		= RP_FORMATION	;
		$url_racine	= HTTP_FORMATION;
		break;	
	default :
	    PageErreur();
	    exit()      ;	
	}

	$nom_rep = '' ;
	
//-----------------------------------------------------------------------------------------------------------------------------------------
//	FONCTIONS
//-----------------------------------------------------------------------------------------------------------------------------------------

	function haut() {
		global $color2, $gtitre ;
		InitPageHtml('(c) Web-Jeff FileManager 1.6',false)	;
		put('
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
  <tr bgcolor="'.$color2.'"><td align="middle"><p class="g_titre">'.$gtitre.'</p></td></tr>
</table>');
	}
	
	function is_editable($file) {
		$retour=0;
		if(eregi("\.txt$|\.sql$|\.php$|\.php3$|\.phtml$|\.htm$|\.html$|\.cgi$|\.pl$|\.js$|\.css$|\.inc$",$file)) {$retour=1;}
		return $retour;
	}
	
	function is_image($file)	{
		$retour=0;
		if(eregi("\.png$|\.bmp$|\.jpg$|\.jpeg$|\.gif$",$file)) {$retour=1;}
		return $retour;
	}
	
	function date_modif($file)	{
		$tmp = filemtime($file);
		return date("d/m/Y H:i",$tmp);
	}
	
	function mimetype($file,$quoi) {
		global $wj_mess,$HTTP_USER_AGENT;
		if(!eregi("MSIE",$HTTP_USER_AGENT)) {
			$client="netscape.gif";
		} else {
			$client="html.gif";
		}
		if(is_dir($file)){$image="dossier.gif";$nom_type=$wj_mess[8];}
		else if(eregi("\.mid$",$file)){$image="mid.gif";$nom_type=$wj_mess[9];}
		else if(eregi("\.txt$",$file)){$image="txt.gif";$nom_type=$wj_mess[10];}
		else if(eregi("\.sql$",$file)){$image="txt.gif";$nom_type=$wj_mess[10];}
		else if(eregi("\.js$",$file)){$image="js.gif";$nom_type=$wj_mess[11];}
		else if(eregi("\.gif$",$file)){$image="gif.gif";$nom_type=$wj_mess[12];}
		else if(eregi("\.jpg$",$file)){$image="jpg.gif";$nom_type=$wj_mess[13];}
		else if(eregi("\.html$",$file)){$image=$client;$nom_type=$wj_mess[14];}
		else if(eregi("\.htm$",$file)){$image=$client;$nom_type=$wj_mess[15];}
		else if(eregi("\.rar$",$file)){$image="rar.gif";$nom_type=$wj_mess[60];}
		else if(eregi("\.gz$",$file)){$image="zip.gif";$nom_type=$wj_mess[61];}
		else if(eregi("\.tgz$",$file)){$image="zip.gif";$nom_type=$wj_mess[61];}
		else if(eregi("\.z$",$file)){$image="zip.gif";$nom_type=$wj_mess[61];}
		else if(eregi("\.ra$",$file)){$image="ram.gif";$nom_type=$wj_mess[16];}
		else if(eregi("\.ram$",$file)){$image="ram.gif";$nom_type=$wj_mess[17];}
		else if(eregi("\.rm$",$file)){$image="ram.gif";$nom_type=$wj_mess[17];}
		else if(eregi("\.pl$",$file)){$image="pl.gif";$nom_type=$wj_mess[18];}
		else if(eregi("\.zip$",$file)){$image="zip.gif";$nom_type=$wj_mess[19];}
		else if(eregi("\.wav$",$file)){$image="wav.gif";$nom_type=$wj_mess[20];}
		else if(eregi("\.php$",$file)){$image="php.gif";$nom_type=$wj_mess[21];}
		else if(eregi("\.php3$",$file)){$image="php.gif";$nom_type=$wj_mess[22];}
		else if(eregi("\.phtml$",$file)){$image="php.gif";$nom_type=$wj_mess[22];}
		else if(eregi("\.exe$",$file)){$image="exe.gif";$nom_type=$wj_mess[50];}
		else if(eregi("\.bmp$",$file)){$image="bmp.gif";$nom_type=$wj_mess[56];}
		else if(eregi("\.png$",$file)){$image="gif.gif";$nom_type=$wj_mess[57];}
		else if(eregi("\.css$",$file)){$image="css.gif";$nom_type=$wj_mess[58];}
		else if(eregi("\.mp3$",$file)){$image="mp3.gif";$nom_type=$wj_mess[59];}
		else if(eregi("\.xls$",$file)){$image="xls.gif";$nom_type=$wj_mess[64];}
		else if(eregi("\.doc$",$file)){$image="doc.gif";$nom_type=$wj_mess[65];}
		else if(eregi("\.pdf$",$file)){$image="pdf.gif";$nom_type=$wj_mess[79];}
		else if(eregi("\.mov$",$file)){$image="mov.gif";$nom_type=$wj_mess[80];}
		else if(eregi("\.avi$",$file)){$image="avi.gif";$nom_type=$wj_mess[81];}
		else if(eregi("\.mpg$",$file)){$image="mpg.gif";$nom_type=$wj_mess[82];}
		else if(eregi("\.mpeg$",$file)){$image="mpeg.gif";$nom_type=$wj_mess[83];}
		else if(eregi("\.swf$",$file)){$image="flash.gif";$nom_type=$wj_mess[91];}
		else {$image="defaut.gif";$nom_type=$wj_mess[23];}
		return($quoi=="image"?$image:$nom_type);
	}
	
	function init_rep($rep)		{
		global $racine,$sens,$wj_mess;
		$nom_rep = ($rep==''?$racine:$racine.'/'.$rep);
		$sens = ($sens==1?0:1);
		if(!file_exists($racine)) {put($wj_mess[72].'<br><br><a href="'.PAGE.'">'.$wj_mess[32].'</a>');exit;}
		if(!is_dir($nom_rep)) {put($wj_mess[76].'<br><br><a href="javascript:window.history.back()">'.$wj_mess[32].'</a>');exit;}
		return($nom_rep);
		}
	
	function assemble_tableaux($t1,$t2) {
		global $sens;
		$liste = '' ;
		if($sens==0) {$tab1=$t1; $tab2=$t2;} else {$tab1=$t2; $tab2=$t1;}
		if(is_array($tab1)) {while (list($cle,$val) = each($tab1)) {$liste[$cle]=$val;}}
		if(is_array($tab2)) {while (list($cle,$val) = each($tab2)) {$liste[$cle]=$val;}}
		return($liste);
	}
	
	function txt_vers_html($chaine)	{
		$chaine=str_replace("&#8216;","'",$chaine)	;
		$chaine=str_replace("&#339;","oe",$chaine)	;
		$chaine=str_replace("&#8217;","'",$chaine)	;
		$chaine=str_replace("&#8230;","...",$chaine);
		$chaine=str_replace("&","&amp;",$chaine)	;
		$chaine=str_replace("<","&lt;",$chaine)		;
		$chaine=str_replace(">","&gt;",$chaine)		;
		$chaine=str_replace("\"","&quot;",$chaine)	;
		$chaine=str_replace("","&agrave;",$chaine)	;
		$chaine=str_replace("","&eacute;",$chaine)	;
		$chaine=str_replace("","&egrave;",$chaine)	;
		$chaine=str_replace("","&ugrave;",$chaine)	;
		$chaine=str_replace("","&acirc;",$chaine)	;
		$chaine=str_replace("","&ecirc;",$chaine)	;
		$chaine=str_replace("","&icirc;",$chaine)	;
		$chaine=str_replace("","&ocirc;",$chaine)	;
		$chaine=str_replace("","&ucirc;",$chaine)	;
		$chaine=str_replace("","&auml;",$chaine)	;
		$chaine=str_replace("","&euml;",$chaine)	;
		$chaine=str_replace("","&iuml;",$chaine)	;
		$chaine=str_replace("","&ouml;",$chaine)	;
		$chaine=str_replace("","&uuml;",$chaine)	;
		return $chaine;
	}

	/**
	* Retourne une liste avec tous les fichiers et repertoires 
	* @param	string	$nom_rep	repertoire a lister
	* @access	public
	*/		
	function listing($nom_rep)	{
		global $sens;
		$poidstotal=0;
		$handle=opendir($nom_rep);
		$liste_rep = array();
		$liste_fic = array();
		while ($file = readdir($handle)){
			if($file=='.' || $file=='..' ) continue;
			$poidsfic=filesize($nom_rep.'/'.$file);
			$poidstotal+=$poidsfic;
			if(is_dir($nom_rep.'/'.$file)) {
				$liste_rep[$file]=$file;
			//}elseif (CMD != CMD_DIR_FORMATION) {
			}else{
				$liste_fic[$file]=mimetype($nom_rep.'/'.$file,'image');
			}
		}
		closedir($handle);
		
		if(is_array($liste_fic)) {
			if($sens==0){
				ksort($liste_fic);
			} else {
				krsort($liste_fic);
			}
		}
		if(is_array($liste_rep)) {
			if($sens==0){
				ksort($liste_rep);
			}else{
				krsort($liste_rep);
			}
		}
		$liste=assemble_tableaux($liste_rep,$liste_fic);
		
		return array($liste,$poidstotal);	
	}
	
		
	/**
	* definition de la barre d'outil. gere egalement l'arboresence.	
	* @param	integer	$revenir	gestion de l'arboresence
	* @access	public
	*/			
	function barre_outil($revenir)	{
		global $sens,$user,$wj_mess,$rep, $color1;
		BR();
		BeginBorder("95%",$color1);		
		put('<table width="100%" cellpadding="0" cellspacing="1" bgcolor="#FFFFFF"><tr><td>');
		if($revenir==0) {
			put('<a href="'.PAGE.'"><img border="0" src="'.IMAGE_DIR.'dossier.gif" width="20" height="20" align="ABSMIDDLE"></a>');
		}
		echo "<a class=\"student\" href=\"";
		if($revenir==1) {
			echo PAGE."&sens=$sens&rep=$rep";
		} else {
			echo PAGE."&sens=$sens";
		}
		echo "\">";
		if($revenir==1) {
			echo "$wj_mess[32]</a>";
		} else {
			echo "$user</a>";
			$array_chemin=split("/",$rep);
			$addchemin = '' ;
			while (list($cle,$val) = each($array_chemin)) {
				if($val!="") {
					if($addchemin!="") {
						$addchemin=$addchemin."/".$val;
					} else {
						$addchemin=$val;
					}
					echo "/<a class=\"student\" href=\"".PAGE."&sens=$sens&rep=$addchemin\">$val</a>";
				}
			}
		}
		echo "</td>";
		echo "</td></tr></table>";
		CloseBorder();
		BR();		
	}

	/**
	* Affiche le contenu d'un repertoire
	* @param	string	$nom_rep	repertoire a lister
	* @access	public
	*/	
	function contenu_dir($nom_rep)	{
		global $sens,$rep,$poidstotal,$wj_mess, $racine, $select_file, $select_dir;
		
		// LECTURE DU REPERTOIRE ET CLASSEMENT DES FICHIERS
		list($liste,$poidstotal)=listing($nom_rep);

		// AFFICHAGE
		if(is_array($liste)) {
			$i = 0 ;
			while (list($file,$mime) = each($liste))	{
				// DEFINITION DU LIEN SUR LE FICHIER
				$affiche_copier=false;
				if(is_dir("$nom_rep/$file"))	{
					$lien=PAGE."&sens=$sens&rep=";
					if($rep!=""){
						$lien.="$rep/";
					}
					$lien.=$file;
				} else 	{
					$lien="";
					if($rep!=""){$lien.="$rep/";}
					$lien.=$file;
					$lien="javascript:popup('$lien')";
					$affiche_copier=true;
				}
				
				// AFFICHAGE DE LA LIGNE
				put('<tr bgcolor="'.GetColor($i++).'">');
				echo "<td>";
				if ( is_editable($file) || is_image($file) || is_dir("$nom_rep/$file")) {
					echo "<a class=\"student\"href=\"".$lien."\">";
				}
				put('<img src="'.IMAGE_DIR.mimetype("$nom_rep/$file","image").'" width="20" height="20" align="ABSMIDDLE" border="0">');
				echo "$file";
				if ( is_editable($file) || is_image($file) || is_dir("$nom_rep/$file")) {
					echo "</a>\n";
				}
				echo "</td>\n";
				put('<td>'.taille($nom_rep.'/'.$file).'</td>');
				put('<td align="center">');

				if ( $select_file || $select_dir ) {
					// IMAGE SELECTIONNER
					if ( $select_file && $affiche_copier ) { 
						// fichier
						$selection = str_replace($racine,'',$nom_rep.'/'.$file);
						$click = 'onclick="javascript:opener.document.forms[\''.FORM.'\'].text'.ID.'.value = \''.$selection.'\';window.close();"';
						put('<a href="#" '.$click.'><img src="'.IMAGE_DIR.'deplacer.gif" alt="..." width="20" height="20" border="0"></a>');					
					} elseif( $select_dir && !$affiche_copier) {
						$selection = str_replace($racine,'',$nom_rep.'/'.$file);
						$click = 'onclick="javascript:opener.document.forms[\''.FORM.'\'].text'.ID.'.value = \''.$selection.'\';window.close();"';
						put('<a href="#" '.$click.'><img src="'.IMAGE_DIR.'deplacer.gif" alt="..." width="20" height="20" border="0"></a>');					
					}
				} else {
					// IMAGE SUPPRIMER
					$url = PAGE.'&action=supprimer&sens='.$sens.'&rep=' ;
					//$url.= ($rep!=''?$rep.'&fic='.$rep:'&fic=').$file ;
					// BUG : Correction PYG 
					// http://www.anemalab.org/phorum/read.php?f=2&i=5086&t=5086
					$url.= ($rep!=''?$rep.'&fic='.$rep."/":'&fic=').$file ;
					put('<a href="'.$url.'"><img src="'.IMAGE_DIR.'supprimer.gif" alt="'.$wj_mess[7].'" width="20" height="20" border="0"></a>');
					
					// IMAGE TELECHARGER
					if($affiche_copier)	{
						put('<a href="'.PAGE.'&action=telecharger&fichier=');
						if($rep!='') {
							put($rep.'/');
						}
						put($file.'">');
						put('<img src="'.IMAGE_DIR.'download.gif" alt="'.$wj_mess[88].'" width="20" height="20" border="0"></a>');
					} else {
						put('<img src="'.IMAGE_DIR.'pixel.gif" width="20" height="20" border="0">');					
					}
				}								
				put('</td></tr>');
				}
			}	
		}
	
	/**
	* Affiche le contenu d'un repertoire : Titre tableau + contenu_dir
	* @param	string	$nom_rep	repertoire a lister
	* @access	public
	*/			
	function lister_rep($nom_rep) {
		global $rep,$url_racine,$racine,$wj_mess,$sens,$user,$color1,$poidstotal;
		if(eregi("\.\.",$rep)) {$rep="";}
		$nom_rep=init_rep($rep);
			
		// AFFICHAGE BARRE DU HAUT (REPERTOIRE COURANT, ...)
		$sens = ($sens==1?0:1);
		barre_outil(0);
		$sens = ($sens==1?0:1);
		
		put('<script language="javascript">');
		put('function popup(lien) {');
		put("var fen = window.open('".PAGE."&action=voir&fichier='+lien,'vfilemanager','status=yes,scrollbars=yes,resizable=yes,width=500,height=400');");
		put('}');
		put('</script>');
		BeginBorder("95%",$color1);	
		put('<table width="100%" cellpadding="0" cellspacing="1" bgcolor="#FFFFFF" >');
//		put('<tr><td>');
		put('<tr bgcolor="'.$color1.'">');

		// PREMIERE LIGNE DU TABLEAU : Nom du fichier / Taille / Actions
		if($rep!=""){$lien="&rep=".$rep;}
		$refresh = '<a href="javascript:location.reload();"><img align="ABSMIDDLE" src="'.IMAGE_DIR.'refresh.gif" alt="'.$wj_mess[85].'" border="0"></a>&nbsp;';						
		put('<td width="60%">'.$refresh.'<a class="student" href="'.PAGE.'&sens='.$sens.'">'.$wj_mess[1].'</a>');
		put('&nbsp;&nbsp;<img src="'.IMAGE_DIR.'fleche'.$sens.'.gif" width="10" height="10">');
		put('</td>');
		put('<td width="20%"><b>'.$wj_mess[2].'</b></td>');
		put('<td width="20%" align="center"><b>'.$wj_mess[5].'</td>');	
		put('</tr>');
	
		$sens = ($sens==1?0:1);
		
		// LIEN DOSSIER PARENT
		if($rep!=""){
			$nom=dirname($rep);
			echo "<tr><td colspan=\"3\"><a class=\"student\"href=\"".PAGE."&sens=".$sens;
			if($rep!=$nom && $nom!="."){echo "&rep=$nom";}
			put('"><img src="'.IMAGE_DIR.'/parent.gif" width="20" height="20" align="ABSMIDDLE" border="0">'.$wj_mess[24].'</a></td></tr>');
		}
			
		contenu_dir($nom_rep);
	
		put('</table>');		
		CloseBorder();
		BR();
	}

	/**
	* Suppression d'un repertoire
	* @param	string	$location	repertoire a supprimer
	* @access	public
	*/	
	function wj_deldir($location) { 
		if(is_dir($location)){
			$all=opendir($location); 
			while ($file=readdir($all)) { 
				if (is_dir("$location/$file") && $file !=".." && $file!=".") { 
					wj_deldir("$location/$file"); 
					if(file_exists("$location/$file")){
						rmdir("$location/$file"); 
					}
					unset($file); 
				}elseif (!is_dir("$location/$file")) { 
					if(file_exists("$location/$file")){
						unlink("$location/$file"); 
					}
					unset($file); 
				} 
			} 
			closedir($all);
			rmdir($location);
		} else {
			if(file_exists("$location")) {
				unlink("$location");
			}
		}
	}
	
	/**
	* Nettoyage du fichier \r\n
	* @param	string	$file	nom du fichier
	* @access	public
	*/		
	function enlever_controlM($file)	{
		$fic=file($file);
		$fp=fopen($file,"w");
		while (list ($cle, $val) = each ($fic)) {
			$val=str_replace(CHR(10),"",$val);
			$val=str_replace(CHR(13),"",$val);
			fputs($fp,"$val\n");
		}
		fclose($fp);
	}

	/**
	* Traitement du nom du fichier
	* @param	string	$nom	nom du fichier
	* @access	public
	*/		
	function traite_nom_fichier($nom) {
		global $max_caracteres;
		$nom=stripslashes($nom);
		$nom=str_replace("'","",$nom);
		$nom=str_replace("\"","",$nom);
		$nom=str_replace("\"","",$nom);
		$nom=str_replace("&","",$nom);
		$nom=str_replace(",","",$nom);
		$nom=str_replace(";","",$nom);
		$nom=str_replace("/","",$nom);
		$nom=str_replace("\\","",$nom);
		$nom=str_replace("`","",$nom);
		$nom=str_replace("<","",$nom);
		$nom=str_replace(">","",$nom);
		$nom=str_replace(" ","_",$nom);
		$nom=str_replace(":","",$nom);
		$nom=str_replace("*","",$nom);
		$nom=str_replace("|","",$nom);
		$nom=str_replace("?","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("@","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("!","",$nom);
		$nom=str_replace("","",$nom);
		$nom=str_replace("+","",$nom);
		$nom=str_replace("^","",$nom);
		$nom=str_replace("(","",$nom);
		$nom=str_replace(")","",$nom);
		$nom=str_replace("#","",$nom);
		$nom=str_replace("=","",$nom);
		$nom=str_replace("$","",$nom);	
		$nom=str_replace("%","",$nom);
		$nom = substr ($nom,0,$max_caracteres);
	 	return $nom;
	 }
	
	
	//-----------------------------------------------------------------------------------------------------------------------------------------
	//	MAIN
	//-----------------------------------------------------------------------------------------------------------------------------------------
	
	
	switch(ACTION) {
		
	//-----------------------------------------------------------------------------------------------------------------------------------------
	//	TELECHARGER / DOWNLOAD
	//-----------------------------------------------------------------------------------------------------------------------------------------
	
	case "telecharger";
		$NomFichier = basename(FICHIER);
		$taille=filesize($racine."/".FICHIER);
		header("Content-Type: application/force-download; name=\"$NomFichier\"");
		header("Content-Transfer-Encoding: binary");
		header("Content-Length: $taille");
		header("Content-Disposition: attachment; filename=\"$NomFichier\"");
		header("Expires: 0");
		header("Cache-Control: no-cache, must-revalidate");
		header("Pragma: no-cache");
		readfile($racine."/".FICHIER);
		exit(); 
		break;
	
	//-----------------------------------------------------------------------------------------------------------------------------------------
	//	VOIR UN FICHIER
	//-----------------------------------------------------------------------------------------------------------------------------------------
	
	case "voir";
		$nomdufichier=basename(FICHIER);
		put('<html>
<head><title>'.$wj_mess[23].' : '.$nomdufichier.'</title></head>
<center>'.$wj_mess[23].' : 
<img src="'.IMAGE_DIR.mimetype($racine.'/'.FICHIER,"image").'" align="ABSMIDDLE">
<b>'.$nomdufichier.'</b><br><br><hr>
<a href="javascript:window.print()"><img src="'.IMAGE_DIR.'imprimer.gif" alt="'.$wj_mess[90].'" border="0"></a>
<a href="javascript:window.close()"><img src="'.IMAGE_DIR.'fermer.gif" alt="'.$wj_mess[86].'" border="0"></a>
<br><hr><br>');
		if(!is_image(FICHIER)) {
			put('</center>');
			$fp=@fopen($racine.'/'.FICHIER,"r");
			if($fp)	{
				while(!feof($fp)){
					$buffer=fgets($fp,4096);
					$buffer=txt_vers_html($buffer);
					$buffer=str_replace("\t","&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",$buffer);
					put($buffer.'<br>');
				}
				fclose($fp);
			}else{
				put($wj_mess[89].' : '.$racine.'/'.FICHIER);
			}
			put('<center>');
		}else{
			put('<img src="'.$url_racine.'/'.FICHIER.'">');
		}
		put('<hr>');
		put('<a href="javascript:window.print()"><img src="'.IMAGE_DIR.'imprimer.gif" alt="'.$wj_mess[90].'" border="0"></a>');
		put('<a href="javascript:window.close()"><img src="'.IMAGE_DIR.'fermer.gif" alt="'.$wj_mess[86].'" border="0"></a>');
		put('<hr></center>');
		ClosePageHtml();
		exit;
		break;
	
	
	//-----------------------------------------------------------------------------------------------------------------------------------------
	//	SUPPRIMER / DELETE
	//-----------------------------------------------------------------------------------------------------------------------------------------
	
	case "supprimer";
		haut();
		$fic = $HTTP_GET_VARS['fic'];
		$mime = (is_dir($racine.'/'.$fic)?$wj_mess[45]:$wj_mess[46]);
		put('<center>'.$wj_mess[47].' '.$mime.' <b>'.$fic.'</b> ?<br><br>');
		put('<a class="error" href="'.PAGE.'&action=supprimer_suite&rep='.$rep.'&fic='.$fic.'&sens='.$sens.'">'.$wj_mess[48].'</a>&nbsp;&nbsp;&nbsp;');
		put('<a class="student" href="'.PAGE.'&rep='.$rep.'&sens='.$sens.'">'.$wj_mess[49].'</a><br></center>');
		break;

	case "supprimer_suite";
		$a_effacer	= $racine.'/'.$HTTP_GET_VARS['fic'];
		if(file_exists($a_effacer))	{
			if(is_dir($a_effacer)){
				wj_deldir($a_effacer);
			}else {
				unlink($a_effacer); 
			}
		}
		header("Location:".PAGE."&rep=".$rep."&sens=".$sens);
		exit;
		break;
	
	//-----------------------------------------------------------------------------------------------------------------------------------------
	//	CREER UN REPERTOIRE / CREATE DIR
	//-----------------------------------------------------------------------------------------------------------------------------------------
	
	case "mkdir";
		$err	= 0 ;
		$wj_messtmp= '';
		$nomdir = traite_nom_fichier($HTTP_POST_VARS['nomdir']);
		if($nomdir=='')	{
			$wj_messtmp.= $wj_mess[37]; 
			$err=1;
		} else if(file_exists($racine.'/'.$rep.'/'.$nomdir)) {
			$wj_messtmp.= $wj_mess[40]; 
			$err=1;
		} else {
			mkdir($racine.'/'.$rep.'/'.$nomdir,CHMOD);
			$wj_messtmp.=$wj_mess[38].' <b>'.$nomdir.'</b>'. $wj_mess[39].' <b>';
			$wj_messtmp.= ($rep==''?'/':$rep);
			$wj_messtmp.='</b>';
		}
		$wj_messtmp.="<br><br><a href=\"".PAGE."&rep=$rep&sens=$sens\">$wj_mess[32]</a>";
		
		if($err==0) {
			header("Location:".PAGE."&rep=".$rep."&sens=".$sens);
			exit;
		}
		haut();
		put('<center>'.$wj_messtmp.'</center>');
		break;
	
	
	//-----------------------------------------------------------------------------------------------------------------------------------------
	//	UPLOAD
	//-----------------------------------------------------------------------------------------------------------------------------------------	
	
	case "upload";
		if($rep!=''){$rep_source='/'.$rep;}
		$destination=$racine.$rep_source;
		$userfile = $HTTP_POST_FILES['userfile'];
		$name	  = $userfile['name'];
		$size	  = ($userfile['size']!=0?$userfile['size']/1024:0);
		$file 	  = $userfile['tmp_name'];
		$error 	  = $userfile['error']	;

		if ( $error == 0 ) {
			if ($name!='') {
				$name=traite_nom_fichier($name);
				if (@copy($file, $destination.'/'.$name)){
			        if(is_editable($name))	{
			        	enlever_controlM($destination.'/'.$name);
			       	}		
				}
			}
		}
		header("Location:".PAGE."&rep=".$rep."&sens=".$sens);
		exit;
		break;
		
	
	//-----------------------------------------------------------------------------------------------------------------------------------------
	//	DEFAUT
	//-----------------------------------------------------------------------------------------------------------------------------------------
	
	default;
		haut();
		echo "<center>\n";

		lister_rep($nom_rep);

		BeginBorder("95%",$color1);	
		put('<table width="100%" border="0" cellspacing="1" cellpadding="0" bgcolor="#FFFFFF">');
		put('<tr bgcolor="'.$color1.'">');
		put('<td colspan="2"><img src="'.IMAGE_DIR.'upload.gif" align="ABSMIDDLE">');
		put('<b>'.$wj_mess[25]);
		if($rep==""){echo "/";}else{echo "$rep";}
		put('</b></td></tr>');
		put('<tr><td>');
		$url = PAGE.'&action=upload&rep='.$rep.'&sens='.$sens ;
		put('<form enctype="multipart/form-data" action="'.$url.'" method="post">');
		put('&nbsp;&nbsp;');
		put('<input class="bouton" type="file" name="userfile" size="30">');
		put('<input class="bouton" type="submit" name="Submit" value="'.$wj_mess[27].'">');
		put('</form></td></tr>');
		put('<tr bgcolor="'.$color1.'"><td colspan="2">');
		put('<img src="'.IMAGE_DIR.'dossier.gif" align="ABSMIDDLE"><b>'.$wj_mess[26]);
		if($rep==""){put('/');}else{put($rep);}
		put('</b></td></tr>');
		put('<tr><td>');
		$url = PAGE.'&action=mkdir&rep='.$rep.'&sens='.$sens ;
		put('<form method="post" action="'.$url.'">');
		put('&nbsp;&nbsp;');
		put('<input class="bouton" type="text" name="nomdir" size="30">');
		put('<input class="bouton" type="submit" name="Submit" value="'.$wj_mess[29].'">');
		put('</form></td></tr>');
		put('</table>');		
		CloseBorder();
		
		//if ( CMD == CMD_ALL ) {
	    	put('<form action="" method="POST" >');
	    	//put('	<input type="button" class="bouton" value="Quitter" onclick="window.opener.location.reload();window.close();" >');
			put('	<input type="button" class="bouton" value="Quitter" onclick="window.close();" >');
	    	put('</form>');
		//}	
			
		put('</center>');
		break;
	}
	
	put('<br><br><center><a href="http://www.webjeff.org/langages/php_scripts.htm" target="_blank">&copy; WebJeff-Filemanager 1.6</a></center>');
	
	ClosePageHtml();

?>