<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Liste de fonctions utilisees par Ganesha. 
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Affiche un commentaire en HTML
	* @param	string	$txt	chaine a afficher en commentaire
	* @access	public
	* @see		
	*/
	function put_debug($txt){ 
		put ("<!-- ".$txt." // -->");
	}

	/**
	* Affiche une chaine de debug et termine le script
	* @param	string	$val	valeur a afficher
	* @access	public
	*/
	function debug($val){
		if ( is_array($val) ) {
			print('<pre>');print_r($val);print('</pre>');
		} else {
			print("DEBUG : $val");
		}
		exit();
	}

	/**
	* Fonction tres importante. Affiche le (c) de Ganesha en commentaire
	* @access	public
	* @see		put_debug()
	*/
	function put_copyright() {
		put_debug("<G a n e s h a> is under GNU General Public License");
		put_debug("info : http://www.anemalab.org");
		put_debug("(c) 2003 Anema Formation SA");
		put_debug("GNU GPL : http://www.fsf.org/copyleft/gpl.html");
	}

	/**
	* Affiche une chaine de debug dans un fichier
	* @param	string	$val	valeur a afficher
	* @access	public
	*/
	function TraceSQL($val){
		if ( !defined("TRACE") || TRACE == 0 ) {
			return(0);
		}
		$filename = RP_TRACE_FILE;
		if ( $fd = fopen($filename, "a+") ) {
			$date = getdate();
			$date = date(FORMATDATE,$date["0"])	;
			$contents = '['.$date.'] '.$val."\r\n" ;
			fwrite($fd, $contents)	;
			fflush($fd);
			fclose($fd);
		}
	}

	/**
	* Affiche une chaine de debug et termine le script
	* @param	string	$msg	message a afficher ds le fichier de debug
	* @access	public
	*/
	function debugf($scriptFileName,$var=''){
		global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_POST_FILES, $guser ;
		if ( DEBUG == 0 ) {
			return(0);
		}		
		$debug = $var ; 
		if ( $var != '' ) {
			if ( is_array($debug) ) {
				$debug = '' ;
				while(list ($key, $val) = each ($var)) {
					$debug.="\t$key => $val".CRLF;
				}			
			} else  {
				$debug = ' => '.$var ;
			}
		}else {
			$debug.= 'HTTP_GET_VARS'.CRLF ;
			foreach($HTTP_GET_VARS    as $k=>$v) $debug.="\t$k => $v".CRLF ;
			$debug.= 'HTTP_POST_VARS'.CRLF ;
			foreach($HTTP_POST_VARS	  as $k=>$v) $debug.="\t$k => $v".CRLF;
			$debug.= 'HTTP_POST_FILES'.CRLF ;
			foreach($HTTP_POST_FILES  as $k=>$v) $debug.="\t$k => $v".CRLF;
		}
			
		$filename = RP_DEBUG_FILE;
		if ( $fd = fopen($filename, "a+") ) {
			$date = getdate();
			$date = date(FORMATDATE,$date["0"])	;
			$contents = '['.$date.'] '.$guser.CRLF ;
			$contents.= $scriptFileName.CRLF.$debug.CRLF ;
			fwrite($fd, $contents)	;
			fflush($fd);
			fclose($fd);
		}
	}

	/**
	* Affiche une chaine de debug dans un fichier
	* @param	string	$val	valeur a afficher
	* @access	public
	*/
	function debug_msg($val) {
		if ( ! DEBUG_AICC ) return(1);
		$filename = RP_AICC_MSG_FILE;
		if ( $fd = fopen($filename, "a+") ) {
			$contents = "--------------------------------".CRLF.$val.CRLF ;		
			fwrite($fd, $contents)	;
			fflush($fd);
			fclose($fd);
		}
	}

	/**
	* Affiche une chaine de debug dans un fichier
	* @param	string	$val	valeur a afficher
	* @access	public
	*/
	function debug_res($val){
		if ( ! DEBUG_AICC ) return(1);
		$filename = RP_AICC_RES_FILE ;
		if ( $fd = fopen($filename, "a+") ) {
			$val = "--------------------------------".CRLF.$val.CRLF ;
			fwrite($fd, $val);
			fclose($fd);
		}
	}	
?>