<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des fichiers
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Verifie le type du fichier
	* @return	string	Retourne le nom du fichier modifie
	* @access	public
	*/
	function file_autorise($fichier) {
		global $FICHIER_AUTORIZ ;
		//die($fichier['type']);
		if ( in_array ($fichier['type'],$FICHIER_AUTORIZ) ) {
			return(true);
		} else {
			return(false);
		}
	}

	/**
	* Copie un fichier dans le repertoire upload. 
	* @access	public
	*/
	function copier_fichier($fichier,$dest) {
		debugf(__FILE__,$dest);
		$name =  basename($dest);
		if ( !file_autorise($fichier)) {
			$dest = $dest.'.txt';
			$name = $name.'.txt' ;
		}
		if ( is_uploaded_file($fichier['tmp_name']) ) {
			copy($fichier['tmp_name'],$dest) ;
			return($name);
		} else {
			die('erreur tmp_file -> '.$fichier['error']);
			return(false) ;
		}
	}

	/**
	* Traite les noms de fichiers a copier sur le serveur.
	* @param	string	$user	Nom du membre qui copie la fichier
	* @param	string	$file_name Nom du fichier a verifier
	* @return	string	Retourne le nom du fichier modifie
	* @access	public
	*/
	function MakeFileName($user,$file_name) {
		$server_fichier = $file_name ;
		$server_fichier = eregi_replace("[^a-z0-9\.]", "_", $server_fichier);
		$server_fichier = date("m-j-H-i-s-").$user.".".$server_fichier		;
		return($server_fichier) ;
	}

	/**
	* remplace tous les caracteres
	* @param	string	$file_name Nom du fichier a modifier
	* @return	string	Retourne le nom du fichier modifie
	* @access	public
	*/
	function Purge($file_name) {
		$ret = eregi_replace("[^a-z0-9]", "_", $file_name);
		$ret = str_replace("\\", "", $ret);
		return($ret) ;
	}

	/**
	* Extrait le nom du fichier
	* @param	string	$file	Nom du fichier modifie
	* @return	string	Retourne le nom du fichier 
	* @access	public
	*/
	function ExtractFileName($file) {	
		$tbl_date = explode ( "-", $file)			;
		$jour		= $tbl_date[0]					;
		$mois		= $tbl_date[1]					;
		$heure		= $tbl_date[2]					;
		$minute		= $tbl_date[3]					;
		$seconde	= $tbl_date[4]					;	
		$tbl_file	= explode ( ".", $tbl_date[5])	;
		$stagiaire	= $tbl_file[0]					;
		for($i=1;$i<count($tbl_file);$i++) {
			if ( $i==1) {
				$fichier = $tbl_file[$i] ;
			} else {
				$fichier.= '.'.$tbl_file[$i];
			}
		}
		return($fichier);
	}

	/**
	* Copie un fichier dans le repertoire du groupe. 
	* Utilise pour les fichiers attaches aux messages.
	* @param	integer	$idm	Id du membre
	* @param	integer	$idg	Id du groupe
	* @param	string	$fichier Description du fichier a copier
	* @return	string	Retourne le nom du fichier modifie
	* @access	public
	*/
	function CopyFileGroupe($idm,$idg,$fichier) {
	 global $ClsGroupe, $ClsMembre ;
		$rep = $ClsGroupe->Directory($idg)	;
		$login = $ClsMembre->GetLogin($idm)	;
		$server_fichier = MakeFileName($login,$fichier['fichier']['name']) ;
		$server_fichier = copier_fichier($fichier['fichier'],RP_GROUPES.$rep."/messages/".$server_fichier) ;
		return($server_fichier) ;
	}

	/**
	* Copie un fichier dans le repertoire du groupe
	* Utilise pour les fichiers postes dans la zone document
	* @param	integer	$idm	Id du membre
	* @param	integer	$idg	Id du groupe
	* @param	string	$fichier Desciption du fichier a copier
	* @return	string	Retourne le nom du fichier modifie
	* @access	public
	*/
	function CopyDocument($idm,$idg,$fichier) {
	 global $ClsGroupe, $ClsMembre ;
		$rep	=  $ClsGroupe->Directory($idg);
		$login  = $ClsMembre->GetLogin($idm);
		$server_fichier = MakeFileName($login,$fichier['fichier']['name']);
		$server_fichier = copier_fichier( $fichier['fichier'],RP_GROUPES.$rep."/".$server_fichier);
		return($server_fichier) ;
	}

	/**
	* Detruit un repertoire
	* mailto:clambert@gamespy.com
	* @param	string	$location	Repertoire a supprimer
	* @access	public
	*/
	/*
	function deldir($location) { 
		debugf(__FILE__,$location);
		if(is_dir($location)){
			$all=opendir($location); 
			while ($file=readdir($all)) { 
				if (is_dir("$location/$file") && $file !=".." && $file!=".") { 
					deldir("$location/$file"); 
					if(file_exists("$location/$file")){
						rmdir("$location/$file"); 
					}
					unset($file); 
				} elseif (!is_dir("$location/$file")) { 
					if(file_exists("$location/$file")){
						unlink("$location/$file"); 
					}
					unset($file); 
				} 
			} 
			closedir($all);
			rmdir($location);
		} else {
			if(file_exists("$location")) {
				unlink("$location");
			}
		}
	}
	*/
	
	/**
	* Detruit un repertoire
	* http://fr2.php.net/manual/fr/function.rmdir.php
	* @param	string	$file	Repertoire a supprimer
	* @access	public
	*/
	function deldir($file) { 
		debugf(__FILE__,$file);
		@chmod($file,0777); 
		if (is_dir($file)) { 
			$handle = opendir($file); 
			while($filename = readdir($handle)) { 
				if ($filename != "." && $filename != "..") { 
				deldir($file."/".$filename); 
				} 
			} 
			@closedir($handle); 
			@rmdir($file); 
		} else { 
			@unlink($file); 
		} 
	} 


	
	/**
	* lecture d'un repertoire
	* @param	string	$location	Repertoire a lire
	* @access	public
	*/
	function readir($location) { 
		if ( substr($location,-1) <> "/" ) {
			$location = $location."/"; 
		}
		$i = 0 ;
		$ret = array();
		$all=opendir($location); 
		while ($file=readdir($all)) { 
			if($file=="." or $file=="..") continue;
			if ( is_dir($location.$file) ) { 
				$ret[$i]['type'] = 'directory'	;
				$ret[$i]['name'] = $file		;	
			} elseif ( ! @is_dir($location.$file) ) { 
				$ret[$i]['type'] = 'file'	;
				$ret[$i]['name'] = $file	;	
			}
			$i++ ;	
		}
		$ret['cnt'] = $i;
		return($ret)	;
	}
		
	/**
	* retourne la taille d'un fichier
	* mailto:clambert@gamespy.com
	* @param	string	$fichier	Nom du fichier
	* @return	string	Retourne la taille du fichier
	* @access	public
	*/
	function taille($fichier) {
	 global $st_texte ;
		$taille=filesize($fichier);
		if ( $taille >= 1073741824 ) {
			$taille = round($taille / 1073741824 * 100) / 100 . " ".$st_texte['go']	;
		} elseif ( $taille >= 1048576 ) {
			$taille = round($taille / 1048576 * 100) / 100 . " ".$st_texte['mo']	;
		} elseif ( $taille >= 1024 ) {
			$taille = round($taille / 1024 * 100) / 100 . " ".$st_texte['ko']		;
		} else {
			$taille = $taille . "  ".$st_texte['octets'];
		}
		if( $taille == 0 ) {
			$taille="-";
		}
		return($taille);
	}


	/**
	* supprime un fichier
	* @param	string	$fichier	Fichier a supprimer
	* @access	public
	*/
	function DeleteDocument($fichier) {
		if ( file_exists ($fichier) ) {
			unlink($fichier);
		}
	}

	/**
	* Cre un repertoire
	* @param	string	$path	Chemin et nom du repertoire a creer
	* @return	integer	retourne le resultat de la creation
	* @access	public
	*/
	function CreateDirectorie($path) { 
		if ( strlen( $path) == 0) {
			return 0;
		}
		if ( is_dir( $path)) {
			return 0;
		}
		if ( dirname( $path) == $path) {
			return 0; 
		}
		return(mkdir($path,0775));
	}

	/**
	* Cre un repertoire
	* @param	string	$oldname	repertoire a renommer
	* @param	string	$newname	nouveau repertoire
	* @access	public
	*/
	function renameDirectorie($oldname, $newname) { 
		if ( strlen( $oldname) == 0) {
			return(false); 
		}
		if ( ! is_dir( $oldname)) {
			return(false); 
		}
		if ( is_dir( $newname)) {
			return(false); 
		}
		if ( ! rename($oldname,$newname) ) {
			return(false); 
		}
		return(true);
	}

	/**
	* verifie l'extension du fichier.
	* @param	string	$file	nom du fichier a traiter
	* @access	public
	*/
	function extensionModule($file){
		if(eregi("\.html$",$file)){return(true);}
		else if(eregi("\.htm$",$file)){return(true);}
		else if(eregi("\.zip$",$file)){return(true);}
		else if(eregi("\.wav$",$file)){return(true);}
		else if(eregi("\.php$",$file)){return(true);}
		else if(eregi("\.php3$",$file)){return(true);}
		else if(eregi("\.phtml$",$file)){return(true);}
		else if(eregi("\.xls$",$file)){return(true);}
		else if(eregi("\.doc$",$file)){return(true);}
		else if(eregi("\.pdf$",$file)){return(true);}
		else if(eregi("\.swf$",$file)){return(true);}
		return(false);
	}
	
	/**
	* Cre un fichier index.htm
	* @param	string	$path	Chemin du repertoire ou doit etre place le fichier index.htm
	* @access	public
	*/
	function CreateIndexFile($path) {
		$data = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n"	;
		$data.= "<HTML><HEAD>\n"											;
		$data.= "<TITLE>401 Authorization Required</TITLE>\n"				;
		$data.= "</HEAD><BODY>\n"											;
		$data.= "<H1>Authorization Required</H1>\n"							;
		$data.= "This server could not verify that you\n"					;
		$data.= "are authorized to access the document\n"					;
		$data.= "requested.  Either you supplied the wrong\n"				;
		$data.= "credentials (e.g., bad password), or your\n"				;
		$data.= "browser doesn't understand how to supply\n"				;
		$data.= "the credentials required.<P>\n"							;
		$data.= "<HR>\n"													;
		$data.= "<ADDRESS>Apache/1.3.19 Server </ADDRESS>\n"				;
		$data.= "</BODY></HTML>\n"											;
		$fp = fopen($path."/index.htm", "w")								;
		fputs($fp, $data)													;
		fclose($fp)															;
	}

	
	//On stocke le niveau de compression dans $level et le contenu  ziper dans $text. 
	//La variable globale $nozip permet  l'admin du logiciel de dsactiver la compression. 
	//La fonction header permet d'ajouter un header, on s'en doute ;)	
	function gzipoutput($text,$level=1){
	  global $HTTP_ACCEPT_ENCODING,$nozip;
	
	  $returntext=$text;
	
	  if (function_exists("crc32") and function_exists("gzcompress") and !$nozip){
	    if (strpos(" ".$HTTP_ACCEPT_ENCODING,"x-gzip")) {
	      $encoding = "x-gzip";
	    }
	    if (strpos(" ".$HTTP_ACCEPT_ENCODING,"gzip")) {
	      $encoding = "gzip";
	    }
	
	    if ($encoding) {
	      header("Content-Encoding: $encoding");
	
	      $size = strlen($text);
	      $crc = crc32($text);
	
	      $returntext = "\x1f\x8b\x08\x00\x00\x00\x00\x00";
	      $returntext .= substr(gzcompress($text,$level),0,-4);
	      $returntext .= pack("V",$crc);
	      $returntext .= pack("V",$size);
	    }
	  }
	  return $returntext;
	}

?>