/* 

   Geeks Artificial Neural Network (G.A.N.N) - Generate Random Data
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



#if defined __GANN__
#define __GGENDATA__

//Common Varialbe
static float RandomData;	//Random Values

//Geeks Generate Data (Function)
float GGenData(int FuncType,float Val1,float Val2)

{

    //Randomize
    GRand();
    
    if (FuncType==0)
        RandomData=random()%2;
    
    else if (FuncType==1)
    
    {
    
        RandomData=random()%2;
        
        if (RandomData==0.0)
        
        {
        
            RandomData=random()%(-2);
            
            if (RandomData==0.0)
                RandomData=-1.0;
        
        }
    
    }
    
    else if (FuncType==2)
    
    {
    
        //Produce Random Real Data - Single Value Or Specified Range
        if (Val2==0.0)
            RandomData=Val1*random()/(RAND_MAX+1.0);
        else
        
        {
        
            if (Val2<0.0)
                RandomData=(Val1-Val2)*random()/(RAND_MAX+1.0);
            else
                RandomData=(Val2-Val1)*random()/(RAND_MAX+1.0);
        
        }
    
    }
    
    else
        GExit(1,"Error:Wrong Function Type Specified!\n");
    
    //Resutls
    return RandomData;

}

#endif

/* ------------------------------------------------------------------------ */
