/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Main File
   
   Copyright GNU/GPL 2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Include Libraries - Functions - Classes - Prototypes
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include "headers/gglobal.h"
#include "headers/gptl.h"
#include "gsleep.cpp"
#include "grand.cpp"
#include "gsocket.cpp"
#include "gneuron.cpp"
#include "gstat.cpp"
#include "gerrc.cpp"
#include "gdmloader.cpp"
#include "ggendata.cpp"
#include "greaddata.cpp"
#include "gsavedata.cpp"
#include "gremdata.cpp"
#include "gnmopt.cpp"
#include "gsnmc.cpp"
#include "gnms.cpp"
#include "gumsgs.cpp"

//Main Function
int main(int argc,char **argv)

{

    //Variables
    int i;			//A Counter
    
    //Graphical Menu
    printf("-------------------------\n");
    printf("******   G.A.N.N   ******\n");
    printf("-------------------------\n");
    printf("=========================\n");
    printf("George Delaportas\n");
    printf("Dimitris Vlachos\n");
    printf("Copyright GNU/GPL 2006\n");
    printf("=========================\n\n");
    printf("Please Select An Option\n");
    printf("1.Create A G.A.N.N And Teach It\n");
    printf("2.Simulate An Existing G.A.N.N From GKDB\n");
    printf("3.Create A G.A.N.N - Teach It And Simulate It\n");
    printf("4.Exit\n");
    printf("Choice:");
    
    scanf("%i",&i);
    
    printf("\n");
    
    //Check Choices
    if (i==1)
    
    {
    
        //Create New G.A.N.N
        GSNMC();
        
        printf("Restoring Data...\n");
        
        //Load GIOD And GMap Data
        GDMLoader();
        
        printf("Done!\n\n");
        printf("Starting Simulation...\n\n");
        
        //Simulate G.A.N.N At Learning Mode
        GNMS(0);
    
    }
    
    else if (i==2)
    
    {
    
        //Unfinished
        
    
    }
    
    else if (i==3)
    
    {
    
        //Create New G.A.N.N
        GSNMC();
        
        //Unfinished
    
    }
    
    else if (i==4)
    
    {
    
        printf("Thank You For Using G.A.N.N\n");
        printf("Goodbye!\n");
        
        exit(0);
    
    }
    
    else
    
    {
    
        printf("Error: Wrong Choice Specified!\n");
        
        exit(1);
    
    }
    
    exit(0);

}

/* ------------------------------------------------------------------------ */
