/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - I/O Socket
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Constructor
GSocket::GSocket()

{

    //Private Variables
    int SockType=-1;
    int SockPins=0;
    
    //Load Pins Matrix
    Pins=new GPin[MAX_PIN];

}



//Destructor
GSocket::~GSocket()

{

    //UnLoad Pins Matrix
    delete [] Pins;

}



//Set Socket Type (I/O)
void GSocket::SetST(int SType)

{

    //Check Socket Type (0:Input,1:Output)
    if (SType<0 || SType>1)
    
    {
    
        printf("Error: Wrong Socket Type Specified!\n");
        
        exit(1);
    
    }
    
    SockType=SType;

}



//Set Pins Number
void GSocket::SetPins(int Num)

{

    //Check Socket Pins (Not Less Than 1 Or Not More Than MAX_PIN)
    if (Num<1 || Num>MAX_PIN)
    
    {
    
        printf("Error: Wrong Number Of Pins Specifed!\n");
        
        exit(1);
    
    }
    
    SockPins=Num;

}



//Set Pin Type
void GSocket::SetPT(int Pin,int PinType)

{

    //Check Socket Pins
    if (Pin<0 || Pin>SockPins)
    
    {
    
        printf("Error: Wrong Pin Specified!\n");
        
        exit(1);
    
    }
    
    //Socket Pin Type (0:Binary,1:Real)
    if (PinType<0 || PinType>1)
    
    {
    
        printf("Error: Wrong Pin Type Specified!\n");
        
        exit(1);
    
    }
    
    Pins[Pin].Type=PinType;

}



//Set Pin State
void GSocket::SetPS(int Pin,int PinState)

{

    //Check Socket Pins
    if (Pin<0 || Pin>SockPins)
    
    {
    
        printf("Error: Wrong Pin Specified!\n");
        
        exit(1);
    
    }
    
    //Socket Pin State (0:Off,1:On)
    if (PinState<0 || PinState>1)
    
    {
    
        printf("Error: Wrong Pin State Specified!\n");
        
        exit(1);
    
    }
    
    Pins[Pin].State=PinState;

}



//Set Pin Value
void GSocket::SetPV(int Pin,float Val)

{

    //Check Socket Pins And Values
    if (Pin<0 || Pin>SockPins)
    
    {
    
        printf("Error: Wrong Pin Specified!\n");
        
        exit(1);
    
    }
    
    if (Pins[Pin].Type==0 && Val!=0.0 && Val!=1.0)
    
    {
    
        printf("Error: Value Mismatch!\n");
        
        exit(1);
    
    }
    
    Pins[Pin].MinVal=Val;
    Pins[Pin].MaxVal=0.0;

}



//Set Pin Value With Range [Over-Loaded]
void GSocket::SetPV(int Pin,float Val1,float Val2)

{

    //Check Socket Pins And Values
    if (Pin<0 || Pin>SockPins)
    
    {
    
        printf("Error: Wrong Pin Specified!\n");
        
        exit(1);
    
    }
    
    if (Val2!=0.0 && Val2<=Val1)
    
    {
    
        printf("Error: Wrong Range Specified!\n");
        
        exit(1);
    
    }
    
    if (Pins[Pin].Type==0 && Val2>0.0)
    
    {
    
        printf("Error: Binary Numbers Have No Range!\n");
        
        exit(1);
    
    }
    
    Pins[Pin].MinVal=Val1;
    Pins[Pin].MaxVal=Val2;

}



//Get Socket Type (I/O)
int GSocket::GetST()

{

    return SockType;

}



//Get Pins Number
int GSocket::GetPins()

{

    return SockPins;

}



//Get Pin Type
int GSocket::GetPT(int Pin)

{

    if (Pin<0 || Pin>SockPins)
    
    {
    
        printf("Error: Wrong Pin Specified!\n");
        
        exit(1);
    
    }
    
    return Pins[Pin].Type;

}



//Get Pin State
int GSocket::GetPS(int Pin)

{

    if (Pin<0 || Pin>SockPins)
    
    {
    
        printf("Error: Wrong Pin Specified!\n");
        
        exit(1);
    
    }
    
    return Pins[Pin].State;

}



//Get Pin Value Or Pin Value With Range
float GSocket::GetPV(int Pin,int Choice)

{

    if (Pin<0 || Pin>SockPins)
    
    {
    
        printf("Error: Wrong Pin Specified!\n");
        
        exit(1);
    
    }
    
    if (Choice==0)
    
    {
    
        if (Pins[Pin].State==1)
            return Pins[Pin].MinVal;
        else
            return 0.0;
    
    }
    
    else if (Choice==1)
    
    {
    
        if (Pins[Pin].State==1)
            return Pins[Pin].MaxVal;
        else
            return 0.0;
    
    }
    
    else
    
    {
    
        printf("Error: Wrong Choice Specified!\n");
        
        exit(1);
    
    }

}

/* ------------------------------------------------------------------------ */
