/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Error Statistics
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Error Statistics (Function)
float GErrStat(float *FirstData,float *LastData,float *AltData,int StatType)

{

    //Variables
    int i,j;			//Counters
    int Y;			//A Tracer
    int Faults;			//Faults Counter
    float OK,Error;		//OK And Error Values (%)
    
    //Reset Statistics
    OK=0.0;
    Error=0.0;
    
    //Reset Tracer;
    Y=0;
    
    //Reset Faults Counter
    Faults=0;
    
    //Check Statistics Type
    if (StatType<0 OR StatType>1)
    
    {
    
        printf("Error: Wrong Statistics Type Specified!\n");
        
        exit(1);
    
    }
    
    else if (StatType==0)
    
    {
    
        for (i=0;i<Outputs;i++)
        
        {
        
            if (FirstData[i]!=LastData[i])
                Faults++;
        
        }
    
    }
    
    else
    
    {
    
        for (i=0;i<Outputs;i++)
        
        {
        
            if (OutSocket.GetPV(i,1)!=0.0 &&\
            AltData[i]>OutSocket.GetPV(i,1))
                Faults++;
            
            if (OutSocket.GetPV(i,1)==0.0 &&\
            LastData[i]>OutSocket.GetPV(i,0))
                Faults++;
            
            if (LastData[i]<OutSocket.GetPV(i,0))
                Faults++;
        
        }
    
    }
    
    //Enable Tracer If We Have Faults
    if (Faults>0)
        Y=1;
    
    //Statistics (%)
    if (Y==0)
    
    {
    
        OK=100.0;
        Error=0.0;
    
    }
    
    else
    
    {    
    
        Error=(Faults/Outputs)*100.0;
        OK=100.0-Error;
        
        printf("Correct:%.1f%\n",OK);
        printf("Error:%.1f%\n\n",Error);
    
    }
    
    return Error;

}

/* ------------------------------------------------------------------------ */
