/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Read Data From GKDB
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Read Data (Function)
void GReadData(GNeuron *GMatrix,int RegNum)

{

    //Variables
    int i,j,k;
    float d;
    FILE *FileToOpen;
    
    //Reset j
    j=0;
    
    //Initialize GHT
    FileToOpen=fopen("GHT","r");
    
    //Error Check
    if (FileToOpen==NULL)
    
    {
    
        printf("Error: GKDB Has Not Been Found!\n");
        
        exit(1);
    
    }
    
    //Read Offset
    for (i=0;i<RegNum-1;i++)
        fscanf(FileToOpen,"%i\n",&j);
    
    //Close GHT
    fclose(FileToOpen);
    
    //Initialize GKDB
    FileToOpen=fopen("GKDB","r");
    
    //Set Pointer To The Right Offset
    fseek(FileToOpen,j,SEEK_SET);
    
    //Read Starting Header
    fscanf(FileToOpen,"%i\n%i\n%i\n%i\n%f\n%i\n%i\n%i\n%i\n",\
    &SimNum,&ECT,&GMSType,&GMCType,&LearnTH,&GNNum,&Layers,&Inputs,&Outputs);
    
    //Read GMap Layers
    for (i=0;i<Layers;i++)
        fscanf(FileToOpen,"%i\n",&GMap[i]);
    
    //Read GNeurons Options
    for (i=0;i<GNNum;i++)
    
    {
    
        //Read Input Slot Pins Of This GNeuron
        fscanf(FileToOpen,"%i\n",&k);
        
        for (j=0;j<k;j++)
        
        {
        
            fscanf(FileToOpen,"%f\n",&d);
            GMatrix[i].SetWeights(j,d);
        
        }
        
        fscanf(FileToOpen,"%i\n",&j);
        GMatrix[i].SetNFT(j);
        fscanf(FileToOpen,"%f\n",&d);
        GMatrix[i].Mod=d;
    
    }
    
    //Read Output Socket Values
    for (i=0;i<Outputs;i++)
    
    {
    
        fscanf(FileToOpen,"%f\n",&GMinData[i]);
        fscanf(FileToOpen,"%f\n",&GMaxData[i]);
    
    }
    
    //Close GKDB
    fclose(FileToOpen);

}

/* ------------------------------------------------------------------------ */
