/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - GIOD And GMap Loader
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks [I/O] Distribution And Map Loader (Function)
void GDMLoader()

{

    //Variables
    int i,j;			//Counters
    float Val;			//A Float Value
    float Tmp;			//Temp Values
    FILE *FileToOpen;		//A File Pointer
    
    //Initialize GIOD
    FileToOpen=fopen("GIOD","r");
    
    //Read Starting Header
    fscanf(FileToOpen,"%i\n%i\n",&Inputs,&Outputs);
    
    //Set Values To The Inputs GSocket
    for (i=0;i<Inputs;i++)
    
    {
    
        for (j=0;j<5;j++)
        
        {
        
            fscanf(FileToOpen,"%f\n",&Val);
            
            if (j==0)
            
            {
            
                InSocket.SetST(int(Val));
            
            }
            
            else if (j==1)
            
            {
            
                InSocket.SetPT(i,int(Val));
            
            }
            
            else if (j==2)
            
            {
            
                InSocket.SetPS(i,int(Val));
            
            }
            
            else if (j==3)
            
            {
            
                InSocket.SetPV(i,Val);
                Tmp=Val;
            
            }
            
            else
            
            {
            
                InSocket.SetPV(i,Tmp,Val);
            
            }
        
        }
    
    }
    
    //Set Values To The Outputs GSocket
    for (i=0;i<Outputs;i++)
    
    {
    
        for (j=0;j<5;j++)
        
        {
        
            fscanf(FileToOpen,"%f\n",&Val);
            
            if (j==0)
            
            {
            
                OutSocket.SetST(int(Val));
            
            }
            
            else if (j==1)
            
            {
            
                OutSocket.SetPT(i,int(Val));
            
            }
            
            else if (j==2)
            
            {
            
                OutSocket.SetPS(i,int(Val));
            
            }
            
            else if (j==3)
            
            {
            
                OutSocket.SetPV(i,Val);
                Tmp=Val;
            
            }
            
            else
            
            {
            
                OutSocket.SetPV(i,Tmp,Val);
            
            }
        
        }
    
    }
    
    //Close GIOD
    fclose(FileToOpen);
    
    //Initialize GMap
    FileToOpen=fopen("GMap","r");
    
    //Read Starting Header
    fscanf(FileToOpen,"%i\n%i\n%i\n%i\n%i\n%i\n%f\n%i\n",\
    &SimNum,&ECT,&GMSType,&GMCType,&Inputs,&Outputs,&LearnTH,&Layers);
    
    //Get GNeurons From Layers
    for (i=0;i<Layers;i++)
    
    {
    
        fscanf(FileToOpen,"%f\n",&Tmp);
        GMap[i]=int(Tmp);
    
    }
    
    //Get GNNum
    fscanf(FileToOpen,"%i\n",&GNNum);
    
    //Close GMap
    fclose(FileToOpen);
    
    //Clean Up
    system("touch GIOD GMap");
    system("rm GIOD GMap");

}

/* ------------------------------------------------------------------------ */
