/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Neural Map Simulator
   
   Copyright GNU/GPL 2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Neural Map Simulator (Learning Function)
void GNMS(float Data[],int SMode)

{

    //Variables
    register int i,j,k,n;	//Counters
    register int C;		//Characters From GMap
    int GNNum;			//GNeurons Number
    int Inputs,Outputs;		//I/O Sockets
    int Tracer;			//A Tracer
    float ErrStat;		//Error Statistics (%)
    FILE *GMap;			//The Neural Map
    
    //Check For Wrong Simulation Mode
    if (SMode<0 || SMode>2)
    
    {
    
        printf("Error: Wrong Simulation Mode Specified!\n");
        
        exit(1);
    
    }
    
    //Read GMap
    GMap=fopen("GMap","r");
    
    //Get Header
    fscanf(GMap,"%i\n%i\n%i",&GNNum,&Inputs,&Outputs);
    
    //Create A New GANN
    GNeuron GANN[GNNum];	//GANN Matrix
    
    //Final Data
    float FinalData[Outputs];	//Last Outputs
    
    //Print Input Socket
    printf("----- Input Socket -----\n");   
    
    for (i=0;i<Inputs;i++)
        printf("Input%i:%.3f\n",i+1,Data[i]);
    
    printf("-----------------------\n\n");
    
    printf("Start Learning...\n\n");
    
    //Escape Caption
    ReRoute:;
    
    //Reset Tracer
    Tracer=0;
    
    //Reset i,k
    i=k=n=-1;
    
    //Start Simulation
    while (C!=EOF)
    
    {
    
        C=fgetc(GMap);
        
        //Increase i (Next Neuron)
        if (C=='+')
            i++;
        
        if (C=='*')
        
        {
        
            for (j=0;j<Inputs;j++)
                GANN[i].InData(j,Data[j]);
            
            GANN[i].Enable(SMode);
        
        }
        
        else if (C=='i')
        
        {
        
            while (C!='+')
            
            {
            
                C=fgetc(GMap);
                
                if (C=='e')
                
                {
                
                    GANN[i].Enable(SMode);
                    
                    //Increase n (Next Output)
                    n++;
                    
                    //Get Final Outputs
                    FinalData[n]=GANN[i].OutData();
                    
                    k=-1;
                
                }
                
                else if (C!='\n' && C!='+')
                
                {
                
                    k++;
                    
                    j=int(C)-49;
                    
                    GANN[i].InData(k,GANN[j].OutData());
                
                }
            
            }
            
            //Check When To Enable This Neuron
            if (k>-1)
                GANN[i].Enable(SMode);
            
            //Reset k
            k=-1;
            
            //Increase i (Next Neuron)
            i++;
        
        }
    
    }
    
    //Gather Error Statistics
    ErrStat=GStat(Data,FinalData);
    
    //Check Error Statistics
    if (ErrStat==0.0)
    
    {
    
        //Save This G.A.N.N Map To The GKDB
        GSaveData(GANN,AUTO);
        
        printf("----- Final Output -----\n");
        
        for (j=0;j<Outputs;j++)
            printf("Data%i:%f\n",j+1,FinalData[j]);
        
        printf("------------------------\n\n");
        
        printf("Learning Successfully Completed\n");
    
    }
    
    else
    
    {
    
        for (i=0;i<Outputs;i++)
        
        {
        
            //Error Correction
            if (0!=FinalData[i])
            
            {
            
                GErrC(GANN,i,ErrStat,1);
                
                printf("* Error Correction At Neuron %i *\n\n",i+1);
            
            }
            
            goto ReRoute;
        
        }
    
    }

}



//Geeks Neural Map Simulator (Learnning Function) [Overloaded]
void GNMS(int Data[],int SMode)

{


}



//Geeks Neural Map Simulator (Running Function) [Overloaded]
/*void GNMS()

{



}



//Geeks Neural Map Simulator (Running Function) [Overloaded]
void GNMS()

{



}
*/
/* ------------------------------------------------------------------------ */
