/* 

   Geeks Artificial Neural Network (G.A.N.N) - Global Declarations
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Include Libraries
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <time.h>

//Set Global Symbols Definitions
#define	   TRUE    1
#define	   FALSE   0
#define	   AND     &&
#define	   OR      ||
#define    NOT     !

//Set Global Constants
const int AUTO=0;		//Automatic Definition
const int MAX_LAYERS=24;	//Maximum Layers
const int MAX_GN=32;		//Maximum GNeurons In Each Layer
const int MAX_MATRIX=\
MAX_LAYERS*MAX_GN;		//Maximum Matrix
const int MAX_PIN=MAX_GN/2;	//Maximum Pins
const int MAX_REG=1000;		//Maximum Database Registrations

//Set Global Variables
int SimNum;			//Simulations Number
int ECT;			//Error Correction Type
int GMSType;			//GMap Simulation Type
int GMCType;			//GMap Connections Type
int GNNum;			//GNeurons Number
int Inputs,Outputs;		//GSockets I/O
int Layers;			//GMap Layers
int RegSerNum;			//Registration Serial Number
int UserInp;			//User Inputs (GRMC)
int GMap[MAX_LAYERS];		//Default GMap
long Offset;			//GHT Offset
float GMinData[MAX_PIN];	//Minimum Data
float GMaxData[MAX_PIN];	//Maximum Data
float LearnTH;			//Learning Threshold
float RunTH;			//Running Threshold
float UserVal[MAX_PIN];		//User Values

//Include Prototypes - Functions - Classes
#include "gptl.h"
#include "../gsleep.cpp"
#include "../grand.cpp"
#include "../gsocket.cpp"
#include "../gneuron.cpp"
#include "../gerrstat.cpp"
#include "../gerrc.cpp"
#include "../gdmloader.cpp"
#include "../ggendata.cpp"
#include "../greaddata.cpp"
#include "../gsavedata.cpp"
#include "../gremdata.cpp"
#include "../gsnmc.cpp"
#include "../gnms.cpp"
#include "../grmc.cpp"
#include "../gexit.cpp"

/* ------------------------------------------------------------------------ */
