/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Save Data
   
   Copyright GNU/GPL 2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Include Prototypes
#include "headers/gsavedata.h"

//Geeks Save Data (Function)
void GSaveData(GNeuron SaveGANN[MAX_GN],int NetType)

{

    //Variables
    int i,j;
    
    //Check Net Type (0:Binary,1:Sign,2:Sigmoid)
    if (NetType==0)
    
    {
    
        //Create A File Pointer
    	FILE *FileToSave;
    	
    	//Initialize GKDB
    	FileToSave=fopen("GKDB","a");
    	
    	//Set Starting Header
    	fprintf(FileToSave,"%i\n%i\n%i\n",NetType,MAX_GN,MAX_PIN);
    	
    	for (i=0;i<MAX_GN;i++)
	
	{
	
            fprintf(FileToSave,"Neuron%i\n",i+1);
            fprintf(FileToSave,"Out: %i\n",SaveGANN[i].OutData());
            fprintf(FileToSave,"NFT: %i\n",SaveGANN[i].GetNFT());
            fprintf(FileToSave,"Sum: %i\n",SaveGANN[i].GetSum());
            fprintf(FileToSave,"Base: %i\n",SaveGANN[i].GetBase());
            
            for (j=0;j<8;j++)
                fprintf(FileToSave,"Bit%i: %i\n",j+1,SaveGANN[i].GetInData(j));
            
            for (j=0;j<8;j++)
                fprintf(FileToSave,"Weight%i: %i\n",j+1,SaveGANN[i].GetWeights(j));
        
	}
        
        //Ending Header
        fprintf(FileToSave,"********\n\n");
        
        //Close GKDB
        fclose(FileToSave);
    
    }
    
    else if (NetType==1)
    
    {
    
        //Sign Type
    
    }
    
    else if (NetType==2)
    
    {
    
        //Sigmoid Type
    
    }
    
    else
    
    {
    
        printf("Error: Wrong Type Specified!\n");
        
        exit(1);
    
    }

}

/* ------------------------------------------------------------------------ */
