/*
                GNU GO - the game of Go (Wei-Chi)
                Version 1.1   last revised 3-1-89
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
                    documented by Bob Webber
                    NeXT version by John Neil
*/
/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 1.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

mail address:   Man L. Li
                Dept. of Computer Science
                University of Houston
                4800 Calhoun Road
                Houston, TX 77004

e-mail address: manli@cs.uh.edu         (Internet)
                coscgbn@uhvax1.bitnet   (BITNET)
                70070,404               (CompuServe)

For the NeXT version, please report any bug/fix, modification, suggestion to

mail address:   John Neil
                Mathematics Department
                Portland State University
                PO Box 751
                Portland, OR  97207

e-mail address: neil@math.mth.pdx.edu  (Internet)
                neil@psuorvm.bitnet    (BITNET)
*/

#include "comment.header"

/* $Id: smgcom.h,v 1.1 2003/01/12 04:01:53 gcasa Exp $ */

/*
 * $Log: smgcom.h,v $
 * Revision 1.1  2003/01/12 04:01:53  gcasa
 * Committing the entire GNU Go and NeXT Go application to the repository.
 * See COPYING file for GNU License.
 *
 * Revision 1.3  1997/07/06 19:38:28  ergo
 * actual version
 *
 * Revision 1.2  1997/05/04 18:57:24  ergo
 * added time control for moves
 *
 */

struct {
  char str[3];
  Token val;
} commands[] = {
  {"W", t_White},          /*  White         */
  {"B", t_Black},          /*  Black         */
  {"C", t_Comment},        /*  Comment       */
  {"AW", t_AddWhite},      /*  AddWhite      */
  {"AB", t_AddBlack},      /*  AddBlack      */
  {"L", t_Letter},         /*  Letter        */
  {"M", t_Mark},           /*  Mark          */
  {"AE", t_AddEmpty},      /*  AddEmpty      */
  {"N", t_Name},           /*  Name          */
  {"PL", t_Player},        /*  PLayer        */
  {"SZ", t_Size},          /*  SiZe          */
  {"HA", t_Handicap},      /*  HAndicap      */
  {"PB", t_PlayerBlack},   /*  PlayerBlack   */
  {"PW", t_PlayerWhite},   /*  PlayerWhite   */
  {"WR", t_WhiteRank},     /*  WhiteRank     */
  {"BR", t_BlackRank},     /*  BlackRank     */
  {"GN", t_GameName},      /*  GameName      */
  {"EV", t_Event},         /*  EVent         */
  {"RO", t_Round},         /*  ROund         */
  {"DT", t_Date},          /*  DaTe          */
  {"PC", t_Place},         /*  PlaCe         */
  {"TM", t_TimeLimit},     /*  TiMe limit    */
  {"RE", t_Result},        /*  REsult        */
  {"GC", t_GameComment},   /*  Game Comment  */
  {"SO", t_Source},        /*  SOurce        */
  {"US", t_User},          /*  USer          */
  {"KM", t_Komi}};         /*  KoMi          */

