// -*- C++ -*-

/* 
 * GChemPaint
 * bond.h 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_BOND_H
#define GCHEMPAINT_BOND_H

#include "config.h"
#include <chemistry/bond.h>
#include <list>

typedef enum
{
	NormalBondType,
	UpBondType,
	DownBondType,
	UndeterminedBondType
} gcpBondType;

using namespace gcu;

class gcpAtom;
class gcpCycle;

class gcpBond: public Bond
{
public:
	gcpBond();
	gcpBond(gcpAtom* first, gcpAtom* last, unsigned char order);
	virtual ~gcpBond();

	virtual Object* GetAtomAt(double x, double y, double z = 0.);
	gcpBondType GetType() {return m_type;}
	void SetType(gcpBondType type);
	double GetAngle2D(gcpAtom* pAtom);
	double GetAngle2DRad(gcpAtom* pAtom);
	void AddCycle(gcpCycle* pCycle);
	void RemoveCycle(gcpCycle* pCycle);
	void RemoveAllCycles();
	unsigned IsCyclic() {return m_Cycles.size();}
	gcpCycle* GetFirstCycle(std::list<gcpCycle*>::iterator& i, gcpCycle * pCycle);
	gcpCycle* GetNextCycle(std::list<gcpCycle*>::iterator& i, gcpCycle * pCycle);
	bool IsInCycle(gcpCycle* pCycle);
	bool GetLine2DCoords(unsigned Num, double* x1, double* y1, double* x2, double* y2);
	virtual bool SaveNode(xmlDocPtr xml, xmlNodePtr);
	virtual bool LoadNode(xmlNodePtr);
	virtual void Move(double x, double y, double z = 0);
	double GetDist(double x, double y);
	void SetDirty();
	void Revert();
	double Get2DLength();
	void IncOrder(int n = 1);
	virtual void SetSelected(GtkWidget* w, int state);
	void Add(GtkWidget* w);
	bool ReplaceAtom(gcpAtom* oldAtom, gcpAtom* newAtom);

protected:
	gcpBondType m_type;
	double m_coords[16];//coordinates of the lines used to represent the bond in the canvas
	bool m_CoordsCalc; //true if m_coords have been calculated, false else
	list<gcpCycle*> m_Cycles;
};


#endif // GCHEMPAINT_BOND_H
