// -*- C++ -*-

/* 
 * GChemPaint
 * file.h 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_FILE_H
#define GCHEMPAINT_FILE_H

#include <glib.h>
#include "document.h"

bool file_process(const gchar* filename, int filetype, bool bSave, gcpDocument *pDoc = NULL);
//void do_import_cml(const gchar* filename, gcpDocument* pDoc);
//void do_save_cml(const gchar* filename, gcpDocument* pDoc);
void do_save_gcp(const gchar* filename, gcpDocument* pDoc);
void do_open_gcp(const gchar* filename, gcpDocument* pDoc);
void do_save_with_babel(const gchar* filename, const gchar* ext, gcpDocument* pDoc, io_type Type);
void do_open_with_babel(const gchar* filename, const gchar* ext, gcpDocument* pDoc, io_type Type);
//void do_import_mol(const gchar* filename, gcpDocument* pDoc);
//void do_import_pdb(const gchar* filename, gcpDocument* pDoc);
void add_document(gcpDocument* pDoc);

#endif // GCHEMPAINT_FILE_H
