// -*- C++ -*-

/* 
 * GChemPaint
 * main.cc 
 *
 * Copyright (C) 2001-2005
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include <gtk/gtk.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/libgnomeui.h>
#include <glade/glade.h>
#include <list>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-job.h>
#include <libgnomeprintui/gnome-print-dialog.h>
#include <libgnomeprintui/gnome-print-job-preview.h>
#include <glib-object.h>
#ifdef GCU_OLD_VER
#	include <chemistry/chemistry.h>
#else
#	include <gcu/chemistry.h>
#endif
#include "document.h"
#include "tools.h"
#include "mendeleiev.h"
#include "filesel.h"
#include "file.h"
#include "globals.h"
#include "gchempaint-bonobo.h"
#include <gnome-vfs-module-2.0/libgnomevfs/gnome-vfs-mime.h>

std::list<gcpDocument*> Docs;
bool bCloseAll = false;
int CurElt = 6;
gcpDocument *pActiveDoc = NULL;
GtkWidget	*TextToolBar, *BoldBtn, *ItalicBtn, *UnderlineBtn, *StrikethroughBtn,
						*SubscriptBtn, *SuperscriptBtn, *FontBtn;
extern char* FontName;
extern GtkTextTagTable *TextTagTable;

//static GnomeMDI *mdi;
static GnomeApp *app;
static GtkNotebook *book;
static GtkMenu *windowsmenu;
static GtkWidget* bar;	//GnomeAppBar
static map<string, string> SupportedPixbufFormats;

#ifndef GTK_IS_26
GdkPixbuf *icon;
#endif

void on_change_element(int Z)
{
	CurElt = Z;
	if (ToolsDlg) ToolsDlg->SetElement(Z);
}

void set_status_text(const char* status)
{
	if (!IsEmbedded())
		gnome_appbar_set_status(GNOME_APPBAR(bar), status);
}

void clear_status()
{
	if (!IsEmbedded())
		gnome_appbar_clear_stack(GNOME_APPBAR(bar));
}

static void on_quit(GtkWidget* widget, void* data)
{
	bCloseAll = true;
	gtk_main_quit();
}

static void on_select(GtkWidget* widget, GtkWidget* w)
{
	gcpDocument* pDoc = (gcpDocument*) g_object_get_data(G_OBJECT(w), "doc");
	if (pDoc != pActiveDoc)
	{
		if (pActiveDoc && !pActiveDoc->GetView()->PrepareUnselect()) 
		{
			w = pActiveDoc->GetView()->GetWidget();
		}
		else
		{
			pActiveDoc = pDoc;
			pDoc->SetActive();
		}
		gint i;
		i = gtk_notebook_page_num(book, gtk_widget_get_parent(gtk_widget_get_parent(w)));
		if(i != gtk_notebook_get_current_page(book))
			gtk_notebook_set_current_page(book, i);
	}
}

static bool on_page_select(GtkWidget* widget, void* data)
{
	on_select(NULL, widget);
	return false;
}

static GtkWidget* create_view()
{
	gcpDocument* pDoc = new gcpDocument();
	if (pDoc)
	{
		Docs.push_back(pDoc);
		pActiveDoc = pDoc;
		return pDoc->GetWidget();
	}
	else return NULL;
}

static void on_file_new(GtkWidget* widget, void* data)
{
	static gint num_window = 1;
	gchar tmp[32];
	if (pActiveDoc && !pActiveDoc->GetView()->PrepareUnselect()) return;
	g_snprintf(tmp, sizeof(tmp), _("Untitled%d"), num_window++);
	GtkWidget* w = create_view();
	if (w)
	{
		GtkWidget *label = gtk_label_new(tmp);
		GtkWidget* item = gtk_menu_item_new_with_label(tmp);
		g_signal_connect(G_OBJECT(item), "activate", (GtkSignalFunc)on_select, w); 
		g_signal_connect(G_OBJECT(w), "expose_event", (GtkSignalFunc)on_page_select, NULL); 
		g_object_set_data(G_OBJECT(w), "menu", item);
		g_object_set_data(G_OBJECT(w), "label", label);
		gtk_widget_show(item);
		gtk_menu_shell_append(GTK_MENU_SHELL(windowsmenu), item);
		GtkScrolledWindow* scroll = (GtkScrolledWindow*)gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(scroll, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
		gtk_scrolled_window_add_with_viewport(scroll, w);
		gtk_widget_set_size_request(GTK_WIDGET(scroll), 400, 300);
		gtk_widget_show(GTK_WIDGET(scroll));
		gtk_notebook_append_page(book, GTK_WIDGET(scroll), label);
		gtk_notebook_set_current_page(book, g_list_length(book->children) - 1);
		pActiveDoc = (gcpDocument*) g_object_get_data(G_OBJECT(w), "doc");
	}
}

static void on_file_open(GtkWidget* widget, void* data)
{
	new gcpFileSel(_("Open File..."), /*do_open_gcp,*/ false/*, ".gchempaint"*/);
}

void on_file_save_as(GtkWidget* widget, void* data)
{
	if (IsEmbedded() || !pActiveDoc)
		pActiveDoc = (gcpDocument*)data;
	if (pActiveDoc == NULL) return;
	new gcpFileSel(_("Save file as..."),true, pActiveDoc);
}

static void on_file_save(GtkWidget* widget, void* data)
{
	if (pActiveDoc == NULL) return;
	if (pActiveDoc->GetFileName()) pActiveDoc->Save();
	else on_file_save_as(widget, data);
}

static void on_file_close(GtkWidget* widget, void* data)
{
	gcpView* pView = pActiveDoc->GetView();
	pView->PrepareUnselect();
	gint i;
	i = gtk_notebook_get_current_page(book);
	gtk_notebook_remove_page(book, i);
}

static void on_properties(GtkWidget* widget, void* data)
{
	pActiveDoc->OnProperties();
}

void on_print(GtkWidget* widget, void* data)
{
	if (IsEmbedded() || !pActiveDoc)
		pActiveDoc = (gcpDocument*)data;
	if (!pActiveDoc) return;
	GnomePrintConfig* config = gnome_print_config_default();
	GnomePrintContext *pc;// = gnome_print_context_new(config);
	GnomePrintJob *gpj = gnome_print_job_new(config);
	int do_preview, copies = 1, collate = 0;
	GnomePrintDialog *gpd;
	gpd = GNOME_PRINT_DIALOG (gnome_print_dialog_new(gpj, (const guchar*)_("Print"), GNOME_PRINT_DIALOG_COPIES));
	gnome_print_dialog_set_copies(gpd, copies, collate);
	switch (gtk_dialog_run(GTK_DIALOG(gpd)))
	{
	case GNOME_PRINT_DIALOG_RESPONSE_PRINT:
		do_preview = 0;
		break;
	case GNOME_PRINT_DIALOG_RESPONSE_PREVIEW:
		do_preview = 1;
		break;
	case GNOME_PRINT_DIALOG_RESPONSE_CANCEL:
		gtk_widget_destroy (GTK_WIDGET(gpd));
		return;
	}
	gtk_widget_destroy(GTK_WIDGET(gpd));
	pc = gnome_print_job_get_context (gpj);
	gnome_print_beginpage(pc, (const guchar*)"");
	gdouble width, height;
	gnome_print_config_get_page_size(config, &width, &height);
	pActiveDoc->Print(pc, width, height);
	gnome_print_showpage(pc);
	g_object_unref(pc);
	gnome_print_job_close(gpj);
	if (do_preview)
	{
		gtk_widget_show (gnome_print_job_preview_new (gpj, (const guchar*)_("Preview")));
	}
	else
	{
		gnome_print_job_print(gpj);
	}
	g_object_unref (gpj);
	gnome_print_config_unref(config);
}

void on_show_elements(GtkWidget* widget, void* data)
{
	if (MendeleievDlg) MendeleievDlg->Destroy();
	else
	{
		MendeleievDlg = new gcpMendeleievDlg(CurElt);
		MendeleievDlg->SetCallBack(&on_change_element);
	}
}

static void on_cut_selection(GtkWidget* widget, void *data)
{
	gint i = gtk_notebook_get_current_page(book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (v && v->GetDoc()->GetEditable()) v->OnCutSelection(w, clipboard);
}

static void on_copy_selection(GtkWidget* widget, void *data)
{
	gint i = gtk_notebook_get_current_page(book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (v && v->GetDoc()->GetEditable()) v->OnCopySelection(w, clipboard);
}

static void on_undo(GtkWidget* widget, void *data)
{
	pActiveDoc->OnUndo();
}

static void on_redo(GtkWidget* widget, void *data)
{
	pActiveDoc->OnRedo();
}

static void on_select_all(GtkWidget* widget, void *data)
{
	gint i = gtk_notebook_get_current_page(book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) v->OnSelectAll();
}

static void on_paste_selection(GtkWidget* widget, void *data)
{
	gint i = gtk_notebook_get_current_page(book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (v && v->GetDoc()->GetEditable()) v->OnPasteSelection(w, clipboard);
}

static void on_delete_selection(GtkWidget* widget, void *data)
{
	gint i = gtk_notebook_get_current_page(book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) v->OnDeleteSelection(w);
}

static bool on_key_release(GtkWidget* widget, GdkEventKey* ev, void *data)
{
	gint i = gtk_notebook_get_current_page(book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) return v->OnKeyRelease(w, ev);
	return false;
}

static bool on_key_press(GtkWidget* widget, GdkEventKey* ev, void *data)
{
	gint i = gtk_notebook_get_current_page(book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) return v->OnKeyPress(w, ev);
	return false;
}

static void on_prefs(GtkWidget* widget, void* data)
{
/*	GtkFontSelectionDialog* dlg = (GtkFontSelectionDialog*)gtk_font_selection_dialog_new("");
	gtk_dialog_run(GTK_DIALOG(dlg));
	gtk_widget_destroy(GTK_WIDGET(dlg));*/
}

static bool do_save_as_image(GtkWidget* widget, GtkFileSelection *fsel)
{
	const gchar* filename = gtk_file_selection_get_filename(fsel);
	if (!filename || !strlen(filename) || filename[strlen(filename) - 1] == '/') {
		GtkWidget* message = gtk_message_dialog_new (GTK_WINDOW (fsel), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, 
															_("Please enter a file name,\nnot a directory"));
		SET_ICON(message);
		gtk_dialog_run (GTK_DIALOG (message));
		gtk_widget_destroy (message);
		return true;
	}
	struct stat buf;
	gint err;
	gint result = GTK_RESPONSE_YES;
	err = stat(filename, &buf);
	if (!err)
	{
		gchar * message = g_strdup_printf(_("File %s\nexists, overwrite?"), filename);
		GtkDialog* Box = GTK_DIALOG(gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, message));
		SET_ICON(message);
		result = gtk_dialog_run(Box);
		gtk_widget_destroy(GTK_WIDGET(Box));
		g_free(message);
		if (result != GTK_RESPONSE_YES)
			return true;
	}
	const char* mime_type = gnome_vfs_mime_type_from_name (filename);
	if (SupportedPixbufFormats.find (mime_type) != SupportedPixbufFormats.end()) {
		pActiveDoc->GetView ()->ExportImage (filename, SupportedPixbufFormats[mime_type].c_str ());
		gtk_widget_destroy (GTK_WIDGET (fsel));
		return false;
	}
	else if (!strcmp (mime_type, "image/x-eps")) {
		char *result = NULL;
		g_spawn_command_line_sync ("which ps2eps", &result, NULL, NULL, NULL);
		if (result && strlen (result)) {
			pActiveDoc->GetView ()->ExportImage (filename, "eps");
			gtk_widget_destroy (GTK_WIDGET (fsel));
			g_free (result);
			return false;
		} else {
			GtkWidget* message = gtk_message_dialog_new (GTK_WINDOW (fsel), GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, 
																_("Please, install which and ps2eps!"));
			SET_ICON(message);
			gtk_dialog_run (GTK_DIALOG (message));
			gtk_widget_destroy (message);
		}
		if (result)
			g_free (result);
	}
	else if (!strcmp (mime_type, "image/svg+xml")) {
		pActiveDoc->GetView ()->ExportImage (filename, "svg");
		gtk_widget_destroy (GTK_WIDGET (fsel));
		return false;
	}
	else {
		GtkWidget* message = gtk_message_dialog_new (GTK_WINDOW (fsel), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, 
															_("Sorry, format not supported!"));
		SET_ICON(message);
		gtk_dialog_run (GTK_DIALOG (message));
		gtk_widget_destroy (message);
	}
	return true;
}

static void on_save_as_image(GtkWidget* widget, void* data)
{
	GtkFileSelection *fsel = GTK_FILE_SELECTION(gtk_file_selection_new("Save as Image"));
	gtk_window_set_modal(GTK_WINDOW(fsel), true);
	g_signal_connect(G_OBJECT(fsel->ok_button), "clicked", G_CALLBACK(do_save_as_image), fsel);
	g_signal_connect_swapped(G_OBJECT(fsel->cancel_button), "clicked", G_CALLBACK(gtk_widget_destroy), fsel);
	g_signal_connect(G_OBJECT(fsel), "destroy", G_CALLBACK(gtk_widget_destroy), NULL);
	gtk_widget_show_all(GTK_WIDGET(fsel));
}

void on_about(GtkWidget* widget, void* data)
{
	char * authors[]={"Jean Bréfort",NULL};
	char * documentors[] = {NULL};
	char * translators = _(\
"Jean Bréfort <jean.brefort@ac-dijon.fr>: French\n\
Christian Neumair <christian-neumair@web.de>: German\n\
Costantino Ceoldo: Italian\n\
Ben Luo: Chinese\n\
Michał Sałaban: Polish"
			);
	GdkPixbuf* pixbuf = gdk_pixbuf_new_from_file ( DATADIR"/"PACKAGE"/pixmaps/gchempaint_logo.png", NULL);
	GtkWidget* about = gnome_about_new(_("GChemPaint"), VERSION,
										_("(C) 2001-2004 by Jean Bréfort"),
										_("GChemPaint is a 2D chemical structures editor for Gnome"),
										(const gchar**) authors, (const gchar**) documentors, translators, pixbuf);
	SET_ICON(about);
	if (pixbuf != NULL)
		g_object_unref (pixbuf);
	gtk_widget_show_all(about);
}

void add_document(gcpDocument* pDoc)
{
	if (!pDoc) return;
	Docs.push_back(pDoc);
	GtkWidget* w = pDoc->GetWidget();
	if (w)
	{
		GtkWidget *label = gtk_label_new(pDoc->GetLabel());
		GtkWidget* item = gtk_menu_item_new_with_label(pDoc->GetLabel());
		g_signal_connect(G_OBJECT(item), "activate", (GCallback)on_select, w);
		g_signal_connect(G_OBJECT(w), "expose_event", (GCallback)on_page_select, NULL); 
		g_object_set_data(G_OBJECT(w), "menu", item);
		g_object_set_data(G_OBJECT(w), "label", label);
		gtk_widget_show(item);
		gtk_menu_shell_append(GTK_MENU_SHELL(windowsmenu), item);
		GtkScrolledWindow* scroll = (GtkScrolledWindow*)gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(scroll, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
		gtk_scrolled_window_add_with_viewport(scroll, w);
		gtk_widget_set_size_request(GTK_WIDGET(scroll), 400, 300);
		gtk_notebook_append_page(book, GTK_WIDGET(scroll), label);
		gtk_widget_show(GTK_WIDGET(scroll));
		gtk_notebook_set_current_page(book, g_list_length(book->children) - 1);
		pActiveDoc = pDoc;
	}
}

static bool on_focus(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
	gtk_clipboard_request_contents(gtk_clipboard_get(GDK_SELECTION_CLIPBOARD), gdk_atom_intern ("TARGETS", FALSE),  (GtkClipboardReceivedFunc)on_receive_targets, NULL);
	return false;
}

/*********
 * Menus *
 *********/
	
static GnomeUIInfo file_menu [] = {
	GNOMEUIINFO_MENU_NEW_ITEM(N_("_New File"), N_("Create a new file"), on_file_new, NULL),
	GNOMEUIINFO_MENU_OPEN_ITEM(on_file_open, NULL),
	GNOMEUIINFO_MENU_SAVE_ITEM(on_file_save, NULL),
	GNOMEUIINFO_MENU_SAVE_AS_ITEM(on_file_save_as, NULL),
	{GNOME_APP_UI_ITEM, N_("Save as _Image"), N_("Save the current file as an image"),
	(void*) on_save_as_image, NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
	'I', (GdkModifierType) GDK_CONTROL_MASK, NULL},
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PRINT_ITEM(on_print, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PROPERTIES_ITEM(on_properties, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_CLOSE_ITEM(on_file_close, NULL),
	GNOMEUIINFO_MENU_EXIT_ITEM(on_quit, NULL),
	GNOMEUIINFO_END
};
 
static GnomeUIInfo edit_menu [] = {
	GNOMEUIINFO_MENU_UNDO_ITEM(on_undo, NULL),
	GNOMEUIINFO_MENU_REDO_ITEM(on_redo, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_CUT_ITEM(on_cut_selection, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM(on_copy_selection, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM(on_paste_selection, NULL),
	GNOMEUIINFO_MENU_CLEAR_ITEM(on_delete_selection, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_SELECT_ALL_ITEM(on_select_all, NULL),
	GNOMEUIINFO_END
 };

#define TOOLS		0
#define MENDELEIEV	1
 
static GnomeUIInfo view_menu [] = {
	GNOMEUIINFO_TOGGLEITEM(N_("_Tools"), N_("Show tools window"), on_show_tools, NULL),
	GNOMEUIINFO_TOGGLEITEM(N_("_Periodic table"), N_("Show the periodic table of the elements"), on_show_elements, NULL),
	GNOMEUIINFO_END
 };
 
static GnomeUIInfo windows_menu [] = {
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
 };
 
static GnomeUIInfo help_menu [] = {
	GNOMEUIINFO_HELP((void*)"gchempaint"),
	GNOMEUIINFO_MENU_ABOUT_ITEM(on_about, NULL),
	GNOMEUIINFO_END
 };

static GnomeUIInfo main_menu [] = {
	GNOMEUIINFO_MENU_FILE_TREE(&file_menu),
	GNOMEUIINFO_MENU_EDIT_TREE(&edit_menu),
	GNOMEUIINFO_MENU_VIEW_TREE(&view_menu),
	GNOMEUIINFO_MENU_WINDOWS_TREE(&windows_menu),
	GNOMEUIINFO_MENU_HELP_TREE(&help_menu),
	GNOMEUIINFO_END
};

static GnomeUIInfo tool_bar [] = {
	GNOMEUIINFO_ITEM_STOCK(N_("New"), N_("Create a new file"), on_file_new, GTK_STOCK_NEW),
	GNOMEUIINFO_ITEM_STOCK(N_("Open"), N_("Open a file"), on_file_open, GTK_STOCK_OPEN),
	GNOMEUIINFO_ITEM_STOCK(N_("Save"), N_("Save active file"), on_file_save, GTK_STOCK_SAVE),
	GNOMEUIINFO_ITEM_STOCK(N_("Print"), N_("Print active file"), on_print, GTK_STOCK_PRINT),
	GNOMEUIINFO_ITEM_STOCK(N_("Close"), N_("Close active file"), on_file_close, GTK_STOCK_CLOSE),
	GNOMEUIINFO_ITEM_STOCK(N_("Quit"), N_("Quit GChemPaint"), on_quit, GTK_STOCK_QUIT),
	GNOMEUIINFO_END
};

static char* opt_filename = NULL;
static bool bonobo_server_flag = false;
struct poptOption options[] =
{
    {"bonobo-server", '\0', POPT_ARG_NONE, &bonobo_server_flag, 0, N_("Allow GChemPaint to act as a Bonobo server."), NULL},
	{NULL, '\0', 0, NULL, 0, NULL, NULL}
};

bool IsEmbedded() {return bonobo_server_flag;}

void ActivateMenu(int menu, int menuitem, bool activate)
{
	if (!GTK_IS_WIDGET(file_menu[menuitem].widget)) return;
	switch (menu)
	{
		case FileMenu:
			gtk_widget_set_sensitive(file_menu[menuitem].widget, activate);
			break;
		case EditMenu:
			gtk_widget_set_sensitive(edit_menu[menuitem].widget, activate);
			break;
	}
}

void ActivateTool(int tool, bool activate)
{
	if (!GTK_IS_WIDGET(tool_bar[tool].widget)) return;
	gtk_widget_set_sensitive(tool_bar[tool].widget, activate);
}

int main(int argc, char *argv[])
{
	poptContext pctx;
	bindtextdomain(PACKAGE, DATADIR"/locale");
#ifdef ENABLE_NLS
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
	textdomain(PACKAGE);

	GnomeProgram* prog = gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, 
                   GNOME_PARAM_POPT_TABLE, options,
                   GNOME_PROGRAM_STANDARD_PROPERTIES, NULL);
	g_object_get(G_OBJECT(prog), GNOME_PARAM_POPT_CONTEXT, &pctx, NULL);

	GSList *formats = gdk_pixbuf_get_formats ();
	GSList *l = formats;
	GdkPixbufFormat *format;
	char **mimes, **mime;
	while (l) {
		format = (GdkPixbufFormat*) l->data;
		if (gdk_pixbuf_format_is_writable (format)) {
			mimes = gdk_pixbuf_format_get_mime_types (format);
			mime = mimes;
			while (*mime)
				SupportedPixbufFormats[*mime++] = gdk_pixbuf_format_get_name (format);
			g_strfreev (mimes);
		}
		l = l->next;
	}
	g_slist_free (formats);
#ifndef GTK_IS_26
	GError *error = NULL;
#ifdef GNOME_OLD_VER
	icon = gdk_pixbuf_new_from_file (DATADIR"/pixmaps/gchempaint.png", &error);
#else
	icon = gdk_pixbuf_new_from_file (DATADIR"/icons/hicolor/48x48/apps/gchempaint.png", &error);
#endif
#endif

	if (bonobo_server_flag)
	{
		BONOBO_FACTORY_INIT ("gchempaint", VERSION, &argc, argv);		
		return bonobo_generic_factory_main ("OAFIID:gchempaint_factory", gchempaint_factory, NULL);
	}
	else
	{
		app = GNOME_APP(gnome_app_new(_("GChemPaint"), _("GChemPaint")));
		gnome_app_create_menus(app, main_menu);
		gnome_app_create_toolbar(app, tool_bar);
		SET_ICON(app);
		windowsmenu = GTK_MENU(windows_menu[0].widget->parent);
		bar = gnome_appbar_new(true, true, GNOME_PREFERENCES_ALWAYS);
		gnome_appbar_set_default(GNOME_APPBAR(bar), _("Ready."));
		gnome_app_set_statusbar(app, bar);
		gnome_app_install_appbar_menu_hints(GNOME_APPBAR(bar), main_menu);
		g_signal_connect(G_OBJECT(app), "destroy", G_CALLBACK(on_quit), NULL);
		g_signal_connect(G_OBJECT(app), "focus_in_event", G_CALLBACK(on_focus), NULL);
		book = GTK_NOTEBOOK(gtk_notebook_new());
		gtk_notebook_set_tab_pos(book, GTK_POS_TOP);
		gnome_app_set_contents(app, GTK_WIDGET(book));
		ActivateMenu(EditMenu, UndoMenu, false);
		ActivateMenu(EditMenu, RedoMenu, false);
		ActivateMenu(EditMenu, CopyMenu, false);
		ActivateMenu(EditMenu, CutMenu, false);
		ActivateMenu(EditMenu, PasteMenu, false);
		ActivateMenu(EditMenu, EraseMenu, false);
		ActivateMenu(FileMenu, SaveAsImageMenu, false);
		GladeXML* xml =  glade_xml_new(DATADIR"/gchempaint/glade/texttools.glade", "texttoolbar", NULL);
		TextToolBar = glade_xml_get_widget(xml, "texttoolbar");
//		gtk_toolbar_set_style(GTK_TOOLBAR(TextToolBar), GTK_TOOLBAR_ICONS);
		GtkWidget* widget = glade_xml_get_widget(xml, "texttoolbar");
		BoldBtn = glade_xml_get_widget(xml, "bold");
		ItalicBtn = glade_xml_get_widget(xml, "italic");
		UnderlineBtn = glade_xml_get_widget(xml, "underline");
		StrikethroughBtn = glade_xml_get_widget(xml, "strikethrough");
		SubscriptBtn = glade_xml_get_widget(xml, "subscript");
		SuperscriptBtn = glade_xml_get_widget(xml, "superscript");
		FontBtn = glade_xml_get_widget(xml, "font");
#ifdef GTK_IS_RECENT
		gtk_toolbar_set_show_arrow(GTK_TOOLBAR (TextToolBar), false);
#endif
		gtk_widget_show_all (TextToolBar);
		gnome_app_add_toolbar(app, GTK_TOOLBAR(widget), "texttools", BONOBO_DOCK_ITEM_BEH_NORMAL, BONOBO_DOCK_TOP, 2, 0, 0);
		gtk_widget_set_sensitive(widget, false);
		g_object_unref(G_OBJECT(widget));
		g_object_unref(G_OBJECT(xml));
		const char ** args = poptGetArgs(pctx);
		int i = 0;
		if (args)
			while(args[i])
			{
				file_process(args[i++], 0, false);
			}	
		else on_file_new(NULL, NULL);
		
		g_signal_connect(GTK_OBJECT(app), "key_press_event", (GCallback)on_key_press, NULL);
		g_signal_connect(GTK_OBJECT(app), "key_release_event", (GCallback)on_key_release, NULL);

		gtk_widget_show_all(GTK_WIDGET(app));
		
		ToolsMenu = GTK_CHECK_MENU_ITEM(view_menu[TOOLS].widget);
		on_show_tools(NULL, NULL);
		MendeleievMenu = GTK_CHECK_MENU_ITEM(view_menu[MENDELEIEV].widget);

		gtk_main();
	}

#ifndef GTK_IS_26
	g_object_unref (icon);
#endif
		
	return 0;
}
