// -*- C++ -*-

/* 
 * GChemPaint
 * cycle.h 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_CYCLE_H
#define GCHEMPAINT_CYCLE_H
#include "chain.h"

class gcpCycle: public gcpChain
{
public:
	gcpCycle(gcpMolecule* Molecule);
	virtual ~gcpCycle();
	
	void Simplify();	//Reduce size of fused cycles
	virtual void Erase(gcpAtom* pAtom1, gcpAtom* pAtom2);
	virtual void Insert(gcpAtom* pAtom1, gcpAtom* pAtom2, gcpChain& Chain);
	bool IsBetterForBonds(gcpCycle* pCycle);
	void GetAngles2D(gcpBond *pBond, double* a1, double* a2);
	int GetFusedBonds();
};

#endif // GCHEMPAINT_CYCLE_H
