// -*- C++ -*-

/* 
 * GChemPaint
 * tool.h 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_TOOL_H
#define GCHEMPAINT_TOOL_H

#include <vector>
#include "widgetdata.h"
#include "view.h"
#include "dialog.h"
#include "operation.h"

enum gcpToolId
{
	SelectId = 0,
	EraserId,
	ElementId,
	FragmentId,
	ChargePlusId,
	ChargeMinusId,
	Reserved6Id,
	Reserved7Id,
	Reserved8Id,
	Reserved9Id,
	BondId,
	UpBondId,
	DownBondId,
	SquiggleBondId,
	Reserved14Id,
	Reserved15Id,
	Reserved16Id,
	Reserved17Id,
	Reserved18Id,
	Reserved19Id,
	Cycle3Id,
	Cycle4Id,
	Cycle5Id,
	Cycle6Id,
	Cycle7Id,
	Cycle8Id,
	CycleNId,
	BenzKekukeId,
	BenzAromId,
	CycleAromId,
	SimpleArrowId,
	DoubleArrowId,
	TextId,
	PlusSignId,
	DoubleHeadArrowId,
	Reserved35Id,
	Reserved36Id,
	Reserved37Id,
	Reserved38Id,
	Reserved39Id,
	MaxId
};

class gcpTool
{
public:
	gcpTool(gcpToolId Id);
	virtual ~gcpTool();
	
	bool OnClicked(gcpView* pView, Object* pObject, double x, double y, unsigned int state);
	void OnDrag(double x, double y, unsigned int state);
	void OnRelease(double x, double y, unsigned int state);
	bool Activate(bool bState);
	virtual bool OnClicked();
	virtual void OnDrag();
	virtual void OnRelease();
	virtual void Activate();
	virtual bool Deactivate();
	virtual void SetOptions();
	virtual void OnChangeState();
	void OnKeyPressed(unsigned int code) {m_nState |= code; OnChangeState();}
	void OnKeyReleased(unsigned int code) {if (m_nState & code) m_nState -= code; OnChangeState();}
	virtual bool OnEvent(GdkEvent* event);
	virtual bool NotifyViewChange();
	virtual bool DeleteSelection();
	virtual bool CopySelection(GtkClipboard *clipboard);
	virtual bool CutSelection(GtkClipboard *clipboard);
	virtual bool PasteSelection(GtkClipboard *clipboard);
	virtual bool OnReceive(GtkClipboard *clipboard, GtkSelectionData *data, int type);
	virtual bool OnUndo();
	virtual bool OnRedo();
	
protected:
	gdouble m_x0, m_y0, m_x1, m_y1, m_x, m_y;
	Object* m_pObject;
	gcpView* m_pView;
	gcpWidgetData* m_pData;
	gcpDialog* m_OptionDialog;
	GtkWidget *m_pWidget;
	GnomeCanvasGroup *m_pGroup;
	GnomeCanvasItem* m_pItem;
	GnomeCanvasItem* m_pBackground;
	double m_dZoomFactor;
	bool m_bChanged, m_bPressed;
	unsigned int m_nState;
/*!
if true, the intended operation is allowed. Default value is true, each tool must set
this flag to false if necessary.
*/
	bool m_bAllowed;

private:
	double lastx, lasty;
};

extern gcpTool* pActiveTool;
extern gcpTool* Tools[];

#endif // GCHEMPAINT_TOOL_H
