// -*- C++ -*-

/* 
 * GChemPaint
 * filesel.cc 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <fileformat.h>
#undef PACKAGE
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef VERSION
#include "config.h"
#include "filesel.h"
#include "file.h"
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <libgnomeui/libgnomeui.h>

enum gcpFileTypes
{
	gcp_ft_Normal = 1,
	gcp_ft_CML,
	gcm_ft_SDF,
	gcp_ft_PDB,
//	gcp_ft_ChemDraw,
	gcp_ft_max
};

static void on_ok(GtkWidget *widget, gcpFileSel* pBox)
{
	pBox->Apply();
}

static void on_cancel(GtkWidget *widget, gcpFileSel* pBox)
{
	pBox->Destroy();
}

static bool on_destroy(GtkWidget *widget, gcpFileSel* pBox)
{
	delete pBox;
	return true;
}

gcpFileSel::gcpFileSel(const gchar* title, bool Save, gcpDocument* pDoc)
{
	fsel = GTK_FILE_SELECTION(gtk_file_selection_new(title));
	m_optmenu = GTK_OPTION_MENU(gtk_option_menu_new());
	GtkMenu* menu = GTK_MENU(gtk_menu_new());
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), gtk_menu_item_new_with_label(_("All Files (*.*)")));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), gtk_menu_item_new_with_label(_("GChemPaint files (*.gchempaint)")));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), gtk_menu_item_new_with_label(_("ChemML files (*.cml)")));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), gtk_menu_item_new_with_label(_("MDL MOL files, MDL ISIS files (*.mdl;*.mol;*.sd;*.sdf)")));
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), gtk_menu_item_new_with_label(_("PDB files (*.pdb;*.ent)")));
//	gtk_menu_shell_append(GTK_MENU_SHELL(menu), gtk_menu_item_new_with_label(_("ChemDraw files (*.chm)")));
	gtk_option_menu_set_menu(m_optmenu, GTK_WIDGET(menu));
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(fsel)->vbox), GTK_WIDGET(m_optmenu), false, false, 5);
	m_bSave = Save;
	m_pDoc = pDoc;
	if (Save) gtk_window_set_modal(GTK_WINDOW(fsel), true);
	g_signal_connect(G_OBJECT(fsel->ok_button), "clicked", G_CALLBACK(on_ok), this);
	g_signal_connect(G_OBJECT(fsel->cancel_button), "clicked", G_CALLBACK(on_cancel), this);
	g_signal_connect(G_OBJECT(fsel), "destroy", G_CALLBACK(on_destroy), this);
	gtk_widget_show_all(GTK_WIDGET(fsel));
}

gcpFileSel::~gcpFileSel()
{
}

void gcpFileSel::Destroy()
{
	gtk_widget_destroy(GTK_WIDGET(fsel));
}

bool gcpFileSel::Apply()
{
	const gchar* filename = gtk_file_selection_get_filename(fsel);
	if (file_process(filename, gtk_option_menu_get_history(m_optmenu), m_bSave, m_pDoc)) return true;
	gtk_widget_destroy(GTK_WIDGET(fsel));
	return false;
}
