// -*- C++ -*-

/* 
 * GChemPaint text plugin
 * plugin.cc 
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "plugin.h"
#include "lib/application.h"
#include "lib/text.h"
#include "lib/fragment.h"
#include "texttool.h"
#include "fragmenttool.h"

static Object* CreateText()
{
	return new gcpText();
}

static Object* CreateFragment()
{
	return new gcpFragment();
}

gcpTextPlugin plugin;

gcpTextPlugin::gcpTextPlugin(): gcpPlugin()
{
	Object::AddType("text", CreateText, TextType);
	Object::AddType("fragment", CreateFragment, FragmentType);
}

gcpTextPlugin::~gcpTextPlugin()
{
}

void gcpTextPlugin::Populate (gcpApplication* App)
{
	App->AddUI (DATADIR"/gchempaint/ui/text.xml");
	new gcpTextTool (App);
	new gcpFragmentTool (App);
}
