// -*- C++ -*-

/* 
 * GChemPaint library
 * arrow.h 
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_ARROW_H
#define GCHEMPAINT_ARROW_H

#include <chemistry/object.h>

using namespace gcu;

typedef enum
{
	gcpSimpleArrow,
	gcpReversibleArrow,
	NotAnArrow1,
	NotAnArrow2,
	gcpDoubleHeadedArrow
} gcpArrowType;

class gcpArrow: public Object
{
public:
	gcpArrow(TypeId Type, unsigned Step = 0);
	virtual ~gcpArrow();
	
	virtual bool Load(xmlNodePtr);
	virtual void SetSelected(GtkWidget* w, int state);
	unsigned GetStep() {return m_Step;}
	void SetStep(unsigned Step) {m_Step = Step;}
	void SetCoords(double xstart, double ystart, double xend, double yend);
	bool GetCoords(double* xstart, double* ystart, double* xend, double* yend);
	virtual void Move(double x, double y, double z = 0);

protected:
	bool Save(xmlDocPtr xml, xmlNodePtr node);
	
protected:
	unsigned m_Step;
	double m_x, m_y, m_width, m_height;
};

#endif	//GCHEMPAINT_ARROW_H
