// -*- C++ -*-

/* 
 * GChemPaint library
 * atom.h 
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCHEMPAINT_ATOM_H
#define GCHEMPAINT_ATOM_H

#include <map>
#include <glib.h>
#include <chemistry/atom.h>
#include <libgnomecanvas/gnome-canvas.h>
#include "widgetdata.h"

namespace OpenBabel
{
	class OBAtom;
}

using namespace OpenBabel;
using namespace std;
using namespace gcu;

class gcpBond;
class gcpCycle;
class gcpMolecule;

#define CHARGE_NE 1
#define CHARGE_NW 2
#define CHARGE_N 4
#define CHARGE_SE 8
#define CHARGE_SW 16
#define CHARGE_S 32
#define CHARGE_E 64
#define CHARGE_W 128

class gcpAtom: public Atom
{
public:
	gcpAtom();
	gcpAtom(int Z, double x, double y, double z);
	gcpAtom(OBAtom* atom, double zoom = 1.0);
	virtual ~gcpAtom();

public :
	virtual void SetZ(int Z);
	void AddBond(Bond* pBond);
	void RemoveBond(Bond* pBond);
	void Update();
	virtual void Add(GtkWidget* w);
	virtual void Update(GtkWidget* w);
	int GetTotalBondsNumber(); //take bond order into account
	int GetAttachedHydrogens() {return m_nH;}
	bool GetBestSide();
	bool IsInCycle(gcpCycle* pCycle);
	virtual int GetChargePosition(double& x, double& y);
	virtual bool LoadNode(xmlNodePtr);
	virtual void SetSelected(GtkWidget* w, int state);
	virtual bool AcceptNewBonds(int nb = 1);
	/*!
	@param Mol: a pointer to a molecule
	
	Adds the atom to the molecule calling gcpMolecule::AddAtom()
	*/
	virtual void AddToMolecule(gcpMolecule* Mol);

private:
	void AddChargeItem(gcpWidgetData* pData, GnomeCanvasGroup* group);

private:
	int m_nH;
	int m_Valence, m_nve; //valence, number of valence electrons
	double m_width, m_height; //size of the atomic symbol in the canvas
	double m_length, m_text_height; // size of the text buffer
	bool m_HPos; //false = left, true = right
	bool m_ChargeAuto;
	int m_Changed; //update needs regenerate the buffer
	GtkTextBuffer *m_buf;
	int m_ascent;
	int m_lbearing;
	double m_CHeight;
};

#endif // GCHEMPAINT_ATOM_H
