// -*- C++ -*-

/* 
 * GChemPaint library
 * mesomery.cc 
 *
 * Copyright (C) 2002-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "widgetdata.h"
#include "view.h"
#include "settings.h"
#include "libgcpcanvas/gcp-canvas-line.h"
#include "libgcpcanvas/gcp-canvas-group.h"
#include "mesomery.h"

gcpMesomeryArrow::gcpMesomeryArrow(gcpMesomery* mesomery, unsigned Step): gcpArrow(MesomeryArrowType, Step)
{
	m_Step = Step;
	if (mesomery) mesomery->AddChild(this);
}

gcpMesomeryArrow::~gcpMesomeryArrow()
{
}

xmlNodePtr gcpMesomeryArrow::Save(xmlDocPtr xml)
{
	xmlNodePtr parent, node, child;
	gchar buf[16];
	node = xmlNewDocNode(xml, NULL, (xmlChar*)"mesomery-arrow", NULL);
	if (!node) return NULL;
	if (!gcpArrow::Save(xml, node)) {xmlFreeNode(node); return NULL;}
	gcpMesomery* m = (gcpMesomery*)GetParentOfType(MesomeryType);
	if (!m)
	{
		//save the arrow as an object
		parent = xmlNewDocNode(xml, NULL, (xmlChar*)"object", NULL);
		if (node && parent) xmlAddChild(parent, node);
			else {xmlFreeNode(node); return NULL;}
	}
	else parent = node;
	return parent;
}

bool gcpMesomeryArrow::Load(xmlNodePtr node)
{
	return gcpArrow::Load(node);
}

void gcpMesomeryArrow::Add(GtkWidget* w)
{
	gcpWidgetData* pData = (gcpWidgetData*)g_object_get_data(G_OBJECT(w), "data");
	GnomeCanvasPoints *points = gnome_canvas_points_new(2);
	GnomeCanvasGroup* group = GNOME_CANVAS_GROUP(gnome_canvas_item_new(pData->Group, gnome_canvas_group_ext_get_type(), NULL));
	GnomeCanvasItem* item;
	points->coords[0] = m_x * pData->ZoomFactor;
	points->coords[1] = m_y * pData->ZoomFactor;
	points->coords[2] = (m_x + m_width) * pData->ZoomFactor;
	points->coords[3] = (m_y + m_height) * pData->ZoomFactor;
	item = gnome_canvas_item_new(
								group,
								gnome_canvas_line_ext_get_type(),
								"points", points,
								"fill_color", (pData->IsSelected(this))? SelectColor: Color,
								"width_units", pData->BondWidth,
								"first_arrowhead", true,
								"last_arrowhead", true,
								"arrow_shape_a", pData->ArrowHeadA,
								"arrow_shape_b", pData->ArrowHeadB,
								"arrow_shape_c", pData->ArrowHeadC,
								"first_arrowhead_style", (unsigned char)ARROW_HEAD_BOTH,
								"last_arrowhead_style", (unsigned char)ARROW_HEAD_BOTH,
								NULL);
	g_object_set_data(G_OBJECT(item), "object", this);
	g_object_set_data(G_OBJECT(group), "arrow", item);
	g_signal_connect(G_OBJECT(item), "event", G_CALLBACK(on_event), w);
	pData->Items[this] = group;
	gnome_canvas_points_free(points);
}

void gcpMesomeryArrow::Update(GtkWidget* w)
{
	gcpWidgetData* pData = (gcpWidgetData*)g_object_get_data(G_OBJECT(w), "data");
	GnomeCanvasGroup* group = pData->Items[this];
	GnomeCanvasPoints *points = gnome_canvas_points_new(2);
	points->coords[0] = m_x * pData->ZoomFactor;
	points->coords[1] = m_y * pData->ZoomFactor;
	points->coords[2] = (m_x + m_width) * pData->ZoomFactor;
	points->coords[3] = (m_y + m_height) * pData->ZoomFactor;
	g_object_set(G_OBJECT(g_object_get_data(G_OBJECT(group), "arrow")),
						"points", points,
						NULL);
	gnome_canvas_points_free(points);
}

gcpMesomery::gcpMesomery(): Object(MesomeryType)
{
}


gcpMesomery::~gcpMesomery()
{
}

xmlNodePtr gcpMesomery::Save(xmlDocPtr xml)
{
}

bool gcpMesomery::Load(xmlNodePtr)
{
}

void gcpMesomery::Add(GtkWidget* w)
{
	map<string, Object*>::iterator i;
	Object* p = GetFirstChild(i);
	while (p)
	{
		p->Add(w);
		p = GetNextChild(i);
	}
}
