// -*- C++ -*-

/* 
 * GChemPaint atoms plugin
 * chargetool.cc 
 *
 * Copyright (C) 2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "chargetool.h"
#include "lib/settings.h"
#include "lib/document.h"
#include "libgcpcanvas/gcp-canvas-group.h"

gcpChargeTool::gcpChargeTool(gcpApplication *App, string Id): gcpTool(App, Id)
{
	if (Id == string("ChargePlus")) m_glyph = "\xE2\x8a\x95";
	else if (Id == string("ChargeMinus")) m_glyph = "\xE2\x8a\x96";
	else m_glyph = 0;
}

gcpChargeTool::~gcpChargeTool()
{
}

bool gcpChargeTool::OnClicked()
{
	if (!m_pObject || (m_pObject->GetType() != AtomType)) false;
	if ((GetName() == string("ChargePlus")) && (((gcpAtom*)m_pObject)->GetCharge() > 0)) return false;
	else if ((GetName() == string("ChargeMinus")) && (((gcpAtom*)m_pObject)->GetCharge() < 0)) return false;
	double x, y;
	int align = ((gcpAtom*)m_pObject)->GetChargePosition(x, y);
	if (!align) return false;
	m_pItem = gnome_canvas_item_new(m_pGroup, gnome_canvas_group_ext_get_type(), NULL);
	x *= m_dZoomFactor;
	y *= m_dZoomFactor;
	switch (align)
	{
		case -2:
			y += 6.0;
			break;
		case -1:
			x -= 6.0;
			break;
		case 1:
			x += 6.0;
			break;
		case 2:
			y -= 6.0;
			break;
	}
	gnome_canvas_item_new(
					(GnomeCanvasGroup*)m_pItem,
					gnome_canvas_ellipse_get_type(),
					"width_units", 1.0,
					"outline_color", ((gcpAtom*)m_pObject)->GetCharge()? DeleteColor: AddColor,
					"x1", x - 4.0,
					"x2", x + 4.0,
					"y1", y - 4.0,
					"y2", y + 4.0,
					NULL);
	GnomeCanvasPoints *points = gnome_canvas_points_new (2);
	points->coords[0] = x - 2.5;
	points->coords[1] = points->coords[3] = y;
	points->coords[2] = x + 2.5;
	gnome_canvas_item_new(
					(GnomeCanvasGroup*)m_pItem,
					gnome_canvas_line_get_type(),
					"points", points,
					"fill_color", ((gcpAtom*)m_pObject)->GetCharge()? DeleteColor: AddColor,
					"width_units", 1.0,
					NULL);
	if (((GetName() == string("ChargePlus")) && (!((gcpAtom*)m_pObject)->GetCharge())) || ((GetName() == string("ChargeMinus")) && ((gcpAtom*)m_pObject)->GetCharge()))
	{	
		points->coords[0] = points->coords[2] = x;
		points->coords[1] = y - 2.5;
		points->coords[3] = y + 2.5;
		gnome_canvas_item_new(
						(GnomeCanvasGroup*)m_pItem,
						gnome_canvas_line_get_type(),
						"points", points,
						"fill_color", ((gcpAtom*)m_pObject)->GetCharge()? DeleteColor: AddColor,
						"width_units", 1.0,
						NULL);
	}
	m_bChanged = true;
	return true;
}

void gcpChargeTool::OnDrag()
{
	if (!m_pItem) return;
	GnomeCanvasItem* pItem = gnome_canvas_get_item_at(GNOME_CANVAS(m_pWidget), m_x, m_y);
	if (pItem == (GnomeCanvasItem*)m_pBackground) pItem = NULL;
	Object* pObject = NULL;
	if (pItem) pObject = (Object*)g_object_get_data(G_OBJECT(pItem), "object");
	if ((pObject == m_pObject) || (pObject == m_pObject->GetParent()))
	{
		if (!m_bChanged)
		{
			gnome_canvas_item_show(m_pItem);
			m_bChanged = true;
		}
	}
	else
	{
		gnome_canvas_item_hide(m_pItem);
		m_bChanged = false;
	}
}

void gcpChargeTool::OnRelease()
{
	if (!m_pItem) return;
	if (m_bChanged)
	{
		gcpAtom* pAtom = (gcpAtom*) m_pObject;
		char charge = pAtom->GetCharge();
		gcpDocument* pDoc = m_pView->GetDoc();
		gcpOperation* pOp = pDoc-> GetNewOperation(GCP_MODIFY_OPERATION);
		if (m_pObject->GetParent()->GetType() == FragmentType)
			m_pObject = m_pObject->GetParent();
		pOp->AddObject(m_pObject, 0);
		pAtom->SetCharge(charge + ((GetName() == string("ChargePlus"))? 1: -1));
		pAtom->Update();
		m_pView->Update(m_pObject);
		pOp->AddObject(m_pObject, 1);
		pDoc->FinishOperation();
	}
}
