// -*- C++ -*-

/* 
 * GChemPaint selection plugin
 * selectiontool.cc
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "selectiontool.h"
#include "lib/molecule.h"
#include "lib/settings.h"
#include "lib/document.h"
#include "lib/application.h"

gcpSelectionTool::gcpSelectionTool(gcpApplication *App): gcpTool(App, "Select")
{
}

gcpSelectionTool::~gcpSelectionTool()
{
}

bool gcpSelectionTool::OnClicked()
{
	if (m_pObject)
	{
		switch (m_pObject->GetType())
		{
			case BondType:
			case AtomType:
				gcpMolecule* pMol = (gcpMolecule*)m_pObject->GetMolecule();
				if (pMol)
				m_pObject = pMol;
				break;
		}
		if (!m_pData->IsSelected(m_pObject))
		{
			m_pData->UnselectAll();
			m_pData->SetSelected(m_pObject);
			m_pApp->ActivateMenu("Copy", true);
			m_pApp->ActivateMenu("Cut", true);
			m_pApp->ActivateMenu("Erase", true);
		}
	}
	else
	{
		m_pData->UnselectAll();
		m_pApp->ActivateMenu("Copy", false);
		m_pApp->ActivateMenu("Cut", false);
		m_pApp->ActivateMenu("Erase", false);
	}
	return true;
}

void gcpSelectionTool::OnDrag()
{
	double dx = m_x - m_x1, dy = m_y - m_y1, x1, y1, x2, y2;
	m_x1 = m_x;
	m_y1 = m_y;
	if (m_pObject)
	{
		m_pData->MoveSelectedItems(dx, dy);
	}
	else
	{
		if (m_pItem)
		{
			gnome_canvas_item_get_bounds(m_pItem, &x1, &y1, &x2, &y2);
			g_object_set(G_OBJECT(m_pItem), "x2", m_x, "y2", m_y, NULL);
			gnome_canvas_request_redraw(GNOME_CANVAS(m_pWidget), (int)x1, (int)y1, (int)x2, (int)y2);
		}
		else
		{
			m_pItem = gnome_canvas_item_new(
									m_pData->Group,
									gnome_canvas_rect_get_type(),
									"x1", m_x0,
									"y1", m_y0,
									"x2", m_x,
									"y2", m_y,
									"outline_color", SelectColor,
									"width_units", m_pData->BondWidth,
									NULL);
		}
	}
}

void gcpSelectionTool::OnRelease()
{
	if (m_pObject)
	{
		double dx = m_x1 - m_x0, dy = m_y1 - m_y0;
		if (dx != 0.0 && dy != 0.0)
		{
			m_pData->MoveSelectedItems(-dx, -dy);
			m_pData->MoveSelection(dx, dy);
		}
	}
	else
	{
		if (m_x < m_x0)
		{
			m_x1 = m_x0;
			m_x0 = m_x;
		}
		else m_x1 = m_x;
		if (m_y < m_y0)
		{
			m_y1 = m_y0;
			m_y0 = m_y;
		}
		else m_y1 = m_y;
		double x0, y0, x1, y1;
		std::map<Object*, GnomeCanvasGroup*>::iterator j;
		for (j = m_pData->Items.begin(); j != m_pData->Items.end(); j++)
		{
			if (!m_pData->IsSelected((*j).first))
			{
				TypeId Id = (*j).first->GetType();
				gnome_canvas_item_get_bounds(GNOME_CANVAS_ITEM((*j).second), &x0, &y0,&x1, &y1);
				if ((x0 < m_x1) && (y0 < m_y1) && (x1 > m_x0) && (y1 > m_y0))
				{
					m_pObject = (*j).first->GetMolecule();
					if (m_pObject)
						m_pData->SetSelected(m_pObject);
					else
						m_pData->SetSelected((*j).first);
				}
			}
		}
	}
	AddSelection(m_pData);
}

bool gcpSelectionTool::Deactivate()
{
	while (!SelectedWidgets.empty())
	{
		SelectedWidgets.front()->UnselectAll();
		SelectedWidgets.pop_front();
	}
	return true;
}

void gcpSelectionTool::AddSelection(gcpWidgetData* data)
{
	gcpWidgetData *d = m_pData;
	m_pData = data;
	m_pView = data->View;
	if (m_pData->HasSelection())
	{
		GtkClipboard *clipboard = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
		m_pView->OnCopySelection (m_pData->Canvas, clipboard);
		if (!m_pView->IsEmbedded())
		{
			m_pApp->ActivateMenu("Copy", true);
			m_pApp->ActivateMenu("Cut", true);
			m_pApp->ActivateMenu("Erase", true);
		}
	}
	SelectedWidgets.remove(m_pData);
	SelectedWidgets.push_front(m_pData);
	m_pData = d;
	if (d) m_pView = d->View;
	else m_pView = NULL;
}
