// -*- C++ -*-

/* 
 * GChemPaint
 * main.cc 
 *
 * Copyright (C) 2001-2003
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include <gtk/gtk.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/libgnomeui.h>
#include <glade/glade.h>
#include <list>
#include <glib-object.h>
#include <chemistry/chemistry.h>
#include "lib/document.h"
#include "lib/view.h"
#include "lib/mendeleiev.h"
#include "standaloneapp.h"

static GtkMenu *windowsmenu;

/*
static char* opt_filename = NULL;
static bool bonobo_server_flag = false;
struct poptOption options[] =
{
    {"bonobo-server", '\0', POPT_ARG_NONE, &bonobo_server_flag, 0, N_("Allow GChemPaint to act as a Bonobo server."), NULL},
	{NULL, '\0', 0, NULL, 0, NULL, NULL}
};
*/

#warning "the following lines should be removed for stable releases"
#undef PACKAGE
#define PACKAGE "gchempaint-unstable" 

int main(int argc, char *argv[])
{
	poptContext pctx;
	bindtextdomain(GETTEXT_PACKAGE, DATADIR"/locale");
#ifdef ENABLE_NLS
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
	textdomain(GETTEXT_PACKAGE);

	GnomeProgram* prog = gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, 
 //                  GNOME_PARAM_POPT_TABLE, options,
                   GNOME_PROGRAM_STANDARD_PROPERTIES, NULL);
	g_object_get(G_OBJECT(prog), GNOME_PARAM_POPT_CONTEXT, &pctx, NULL);


/*	if (bonobo_server_flag)
	{
		BONOBO_FACTORY_INIT ("gchempaint", VERSION, &argc, argv);		
		return bonobo_generic_factory_main ("OAFIID:gchempaint_factory", gchempaint_factory, NULL);
	}
	else*/
	{
		gcpStandaloneApp* App = new gcpStandaloneApp();
		const char ** args = poptGetArgs(pctx);
		int i = 0;
		if (args)
			while(args[i])
			{
				App->FileProcess(args[i++], 0, false);
			}	
		else App->OnFileNew();

		gtk_main();
		delete App;
	}

	return 0;
}
