// -*- C++ -*-

/* 
 * GChemPaint
 * standaloneapp.cc
 *
 * Copyright (C) 2004
 *
 * Developed by Jean Bréfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gchempaint-config.h"
#include "standaloneapp.h"
#include "lib/about.h"
#include "lib/filechooser.h"
#include "lib/mendeleiev.h"
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-job.h>
#include <libgnomeprintui/gnome-print-dialog.h>
#include <libgnomeprintui/gnome-print-job-preview.h>

static void on_quit(GtkWidget* widget, gcpStandaloneApp* App)
{
	gtk_main_quit();
}

static void on_select(GtkWidget* widget, GtkWidget* w)
{
	gcpDocument* pDoc = (gcpDocument*) g_object_get_data(G_OBJECT(w), "doc");
	gcpStandaloneApp* App = (gcpStandaloneApp*) pDoc->GetApplication();
	App->SetActive(pDoc, w);
}

static bool on_page_select(GtkWidget* widget, void* data)
{
	on_select(NULL, widget);
	return false;
}

static void on_file_new(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnFileNew();
}

static void on_file_open(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnFileOpen();
}

void on_file_save_as(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnSaveAs();
}

static void on_file_save(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnSave();
}

static void on_file_close(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnFileClose ();
}

static void on_properties(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnProperties();
}

void on_print(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnPrint();
}

void on_show_elements(GtkWidget* widget, gcpStandaloneApp* App)
{
/*	if (MendeleievDlg) MendeleievDlg->Destroy();
	else
	{
		MendeleievDlg = new gcpMendeleievDlg(CurElt);
		MendeleievDlg->SetCallBack(&on_change_element);
	}*/
}

static void on_cut_selection(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnCutSelection();
}

static void on_copy_selection(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnCopySelection();
}

static void on_undo(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnUndo();
}

static void on_redo(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnRedo();
}

static void on_select_all(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnSelectAll();
}

static void on_paste_selection(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnPasteSelection();
}

static void on_delete_selection(GtkWidget* widget, gcpStandaloneApp* App)
{
	App->OnDeleteSelection();
}

static bool on_key_release(GtkWidget* widget, GdkEventKey* ev, gcpStandaloneApp* App)
{
	return App->OnKeyReleased(widget, ev);
}

static bool on_key_press(GtkWidget* widget, GdkEventKey* ev, gcpStandaloneApp* App)
{
	return App->OnKeyPressed(widget, ev);
}

static void on_prefs(GtkWidget* widget, gcpStandaloneApp* App)
{
/*	GtkFontSelectionDialog* dlg = (GtkFontSelectionDialog*)gtk_font_selection_dialog_new("");
	gtk_dialog_run(GTK_DIALOG(dlg));
	gtk_widget_destroy(GTK_WIDGET(dlg));*/
}

static bool on_focus(GtkWidget *widget, GdkEventFocus *event, gcpStandaloneApp* App)
{
	gtk_clipboard_request_contents(gtk_clipboard_get(GDK_SELECTION_CLIPBOARD), gdk_atom_intern ("TARGETS", FALSE),  (GtkClipboardReceivedFunc)on_receive_targets, App);
	return false;
}

static bool on_tool_clicked(GtkWidget *widget, gcpStandaloneApp* App)
{
	App->OnToolClicked (widget);
	return false;
}

/*********
 * Menus *
 *********/
	
static GnomeUIInfo file_menu [] = {
	GNOMEUIINFO_MENU_NEW_ITEM(N_("_New File"), N_("Create a new file"), on_file_new, NULL),
	GNOMEUIINFO_MENU_OPEN_ITEM(on_file_open, NULL),
	GNOMEUIINFO_MENU_SAVE_ITEM(on_file_save, NULL),
	GNOMEUIINFO_MENU_SAVE_AS_ITEM(on_file_save_as, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PRINT_ITEM(on_print, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PROPERTIES_ITEM(on_properties, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_CLOSE_ITEM(on_file_close, NULL),
	GNOMEUIINFO_MENU_EXIT_ITEM(on_quit, NULL),
	GNOMEUIINFO_END
};
 
static GnomeUIInfo edit_menu [] = {
	GNOMEUIINFO_MENU_UNDO_ITEM(on_undo, NULL),
	GNOMEUIINFO_MENU_REDO_ITEM(on_redo, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_CUT_ITEM(on_cut_selection, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM(on_copy_selection, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM(on_paste_selection, NULL),
	GNOMEUIINFO_MENU_CLEAR_ITEM(on_delete_selection, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_SELECT_ALL_ITEM(on_select_all, NULL),
	GNOMEUIINFO_END
 };

#define TOOLS		0
#define MENDELEIEV	1

#warning "the following lines should be removed for stable releases"
#undef PACKAGE
#define PACKAGE "gchempaint-unstable" 

static GnomeUIInfo tools_menu [] = {
//	GNOMEUIINFO_TOGGLEITEM(N_("_Main"), N_("Show main tool bar"), on_show_tools, GCHEMPAINT_MAIN_TOOLBAR),
//	GNOMEUIINFO_TOGGLEITEM(N_("_Text"), N_("Show text tool bar"), on_show_tools, GCHEMPAINT_TEXT_TOOLBAR),
	GNOMEUIINFO_END
};

static GnomeUIInfo view_menu [] = {
	GNOMEUIINFO_SUBTREE(N_("_Toolbars"), tools_menu),
	GNOMEUIINFO_TOGGLEITEM(N_("_Periodic table"), N_("Show the periodic table of the elements"), on_show_elements, NULL),
	GNOMEUIINFO_END
 };
 
static GnomeUIInfo windows_menu [] = {
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
 };
 
static GnomeUIInfo help_menu [] = {
	GNOMEUIINFO_HELP(PACKAGE),
	GNOMEUIINFO_MENU_ABOUT_ITEM(on_about, NULL),
	GNOMEUIINFO_END
 };

static GnomeUIInfo main_menu [] = {
	GNOMEUIINFO_MENU_FILE_TREE(&file_menu),
	GNOMEUIINFO_MENU_EDIT_TREE(&edit_menu),
	GNOMEUIINFO_MENU_VIEW_TREE(&view_menu),
	GNOMEUIINFO_MENU_WINDOWS_TREE(&windows_menu),
	GNOMEUIINFO_MENU_HELP_TREE(&help_menu),
	GNOMEUIINFO_END
};

static GnomeUIInfo tool_bar [] = {
	GNOMEUIINFO_ITEM_STOCK(N_("New"), N_("Create a new file"), on_file_new, GTK_STOCK_NEW),
	GNOMEUIINFO_ITEM_STOCK(N_("Open"), N_("Open a file"), on_file_open, GTK_STOCK_OPEN),
	GNOMEUIINFO_ITEM_STOCK(N_("Save"), N_("Save active file"), on_file_save, GTK_STOCK_SAVE),
	GNOMEUIINFO_ITEM_STOCK(N_("Print"), N_("Print active file"), on_print, GTK_STOCK_PRINT),
	GNOMEUIINFO_ITEM_STOCK(N_("Close"), N_("Close active file"), on_file_close, GTK_STOCK_CLOSE),
	GNOMEUIINFO_ITEM_STOCK(N_("Quit"), N_("Quit GChemPaint"), on_quit, GTK_STOCK_QUIT),
	GNOMEUIINFO_END
};

gcpStandaloneApp::gcpStandaloneApp(): gcpApplication()
{
	m_NumWindow = 1;
	m_App = GNOME_APP(gnome_app_new(_("GChemPaint"), _("GChemPaint")));
	gnome_app_create_menus_with_data(m_App, main_menu, this);
	GtkToolbar* Toolbar = GTK_TOOLBAR(gtk_toolbar_new());
	gnome_app_fill_toolbar_with_data(Toolbar, tool_bar, NULL, this);
	gtk_toolbar_set_style(Toolbar, GTK_TOOLBAR_ICONS);
	gnome_app_add_toolbar(m_App, GTK_TOOLBAR(Toolbar), _("Main"), BONOBO_DOCK_ITEM_BEH_NORMAL, BONOBO_DOCK_TOP, 1, 0, 0);
	SetMenu("Undo", edit_menu[0].widget);
	SetMenu("Redo", edit_menu[1].widget);
	SetMenu("Copy", edit_menu[3].widget);
	SetMenu("Cut", edit_menu[4].widget);
	SetMenu("Paste", edit_menu[5].widget);
	SetMenu("Erase", edit_menu[6].widget);
	SetMenu("Windows", windows_menu[0].widget->parent);
	m_Bar = gnome_appbar_new(true, true, GNOME_PREFERENCES_ALWAYS);
	gnome_appbar_set_default(GNOME_APPBAR(m_Bar), _("Ready."));
	gnome_app_set_statusbar(m_App, m_Bar);
	gnome_app_install_appbar_menu_hints(GNOME_APPBAR(m_Bar), main_menu);
	g_signal_connect(G_OBJECT(m_App), "destroy", G_CALLBACK(on_quit), this);
	g_signal_connect(G_OBJECT(m_App), "focus_in_event", G_CALLBACK(on_focus), this);
	m_Book = GTK_NOTEBOOK(gtk_notebook_new());
	gtk_notebook_set_tab_pos(m_Book, GTK_POS_TOP);
	gnome_app_set_contents(m_App, GTK_WIDGET(m_Book));
	ActivateMenu("Undo", false);
	ActivateMenu("Redo", false);
	ActivateMenu("Copy", false);
	ActivateMenu("Cut", false);
	ActivateMenu("Paste", false);
	ActivateMenu("Erase", false);
		
	g_signal_connect(GTK_OBJECT(m_App), "key_press_event", (GCallback)on_key_press, this);
	g_signal_connect(GTK_OBJECT(m_App), "key_release_event", (GCallback)on_key_release, this);

	Callbacks["tools"] = (GCallback) on_tool_clicked;

	if (m_pNode && !strcmp(bonobo_ui_node_get_name(m_pNode), "Root")) {
		BonoboUINode* Child = bonobo_ui_node_children (m_pNode);
		AppendUI (Child);
	}
	gtk_widget_show_all(GTK_WIDGET(m_App));

	SetMenu("Mendeleiev", view_menu[MENDELEIEV].widget);
	gcpMendeleievDlg::SetElement (this, m_CurZ);
}

gcpStandaloneApp::~gcpStandaloneApp()
{
	while (!m_Docs.empty())
		delete *m_Docs.begin();
}

void gcpStandaloneApp::OnToolClicked (GtkWidget* widget)
{
	const char* name = gtk_widget_get_name(widget);
	bool active = gtk_toggle_tool_button_get_active(GTK_TOGGLE_TOOL_BUTTON(widget));
	if (m_pActiveTool)
	{
		if (active && !strcmp(name, m_pActiveTool->GetName().c_str()))
		{
			m_pActiveTool->SetOptions ();
			return;
		}
		m_pActiveTool->Activate(false);
	}
	m_pActiveTool = Tools[name];
	if (m_pActiveTool)
		m_pActiveTool->Activate(true);
}

void gcpStandaloneApp::OnDoubleClick(GtkWidget* widget)
{
	const char* name = gtk_widget_get_name(widget);
	gcpTool* tool = Tools[name];
	if (tool) tool->SetOptions();
}

void gcpStandaloneApp::OnRightClick(GtkWidget* widget)
{
	const char* name = gtk_widget_get_name(widget);
	gcpTool* tool = Tools[name];
	if (tool) tool->SetOptions();
}

void gcpStandaloneApp::OnFileNew()
{
	gchar tmp[32];
	if (m_pActiveDoc && !m_pActiveDoc->GetView()->PrepareUnselect()) return;
	g_snprintf(tmp, sizeof(tmp), _("Untitled%d"), m_NumWindow++);
	GtkWidget* w = CreateView();
	if (w)
	{
		GtkWidget *label = gtk_label_new(tmp);
		GtkWidget* item = gtk_menu_item_new_with_label(tmp);
		g_signal_connect(G_OBJECT(item), "activate", (GtkSignalFunc)on_select, w); 
		g_signal_connect(G_OBJECT(w), "expose_event", (GtkSignalFunc)on_page_select, NULL); 
		g_object_set_data(G_OBJECT(w), "menu", item);
		g_object_set_data(G_OBJECT(w), "label", label);
		gtk_widget_show(item);
		gtk_menu_shell_append(GTK_MENU_SHELL(GetMenu("Windows")), item);
		GtkScrolledWindow* scroll = (GtkScrolledWindow*)gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(scroll, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
		gtk_scrolled_window_add_with_viewport(scroll, w);
		gtk_widget_set_size_request(GTK_WIDGET(scroll), 400, 300);
		gtk_widget_show(GTK_WIDGET(scroll));
		gtk_notebook_append_page(m_Book, GTK_WIDGET(scroll), label);
		gtk_notebook_set_current_page(m_Book, g_list_length(m_Book->children) - 1);
		m_pActiveDoc = (gcpDocument*) g_object_get_data(G_OBJECT(w), "doc");
	}
}

void gcpStandaloneApp::OnFileOpen()
{
	gcpFileChooser* fc = new gcpFileChooser (this, false);
}

void  gcpStandaloneApp::AddDocument(gcpDocument* pDoc)
{
	if (!pDoc) return;
	if (pDoc)
	{
		m_Docs.push_back(pDoc);
		m_pActiveDoc = pDoc;
	}
	GtkWidget* w = pDoc->GetWidget();
	if (w)
	{
		const char* tmp = pDoc->GetLabel();
		GtkWidget *label = gtk_label_new(tmp);
		GtkWidget* item = gtk_menu_item_new_with_label(tmp);
		g_signal_connect(G_OBJECT(item), "activate", (GtkSignalFunc)on_select, w); 
		g_signal_connect(G_OBJECT(w), "expose_event", (GtkSignalFunc)on_page_select, NULL); 
		g_object_set_data(G_OBJECT(w), "menu", item);
		g_object_set_data(G_OBJECT(w), "label", label);
		gtk_widget_show(item);
		gtk_menu_shell_append(GTK_MENU_SHELL(GetMenu("Windows")), item);
		GtkScrolledWindow* scroll = (GtkScrolledWindow*)gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(scroll, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
		gtk_scrolled_window_add_with_viewport(scroll, w);
		gtk_widget_set_size_request(GTK_WIDGET(scroll), 400, 300);
		gtk_widget_show(GTK_WIDGET(scroll));
		gtk_notebook_append_page(m_Book, GTK_WIDGET(scroll), label);
		gtk_notebook_set_current_page(m_Book, g_list_length(m_Book->children) - 1);
		m_pActiveDoc = (gcpDocument*) g_object_get_data(G_OBJECT(w), "doc");
	}
}

void gcpStandaloneApp::RemoveDocument(gcpDocument* pDoc)
{
	m_Docs.remove (pDoc);
}

GtkWidget* gcpStandaloneApp::CreateView()
{
	gcpDocument* pDoc = new gcpDocument(this, true);
	if (pDoc)
	{
		m_Docs.push_back(pDoc);
		m_pActiveDoc = pDoc;
		return pDoc->GetWidget();
	}
	else return NULL;
}

void gcpStandaloneApp::OnSave()
{
	if (m_pActiveDoc == NULL) return;
	if (m_pActiveDoc->GetFileName()) m_pActiveDoc->Save();
	else OnSaveAs();
}

void gcpStandaloneApp::ActivateMenu(const string& menuname, bool activate)
{
	GtkWidget* w = Menus[menuname];
	if (w) gtk_widget_set_sensitive(w, activate);
}

void gcpStandaloneApp::ActivateToolItem(const string& itemname, bool activate)
{
	GtkWidget* w = ToolItems[itemname];
	if (w) gtk_widget_set_sensitive(w, activate);
}

void gcpStandaloneApp::ClearStatus()
{
	gnome_appbar_clear_stack(GNOME_APPBAR(m_Bar));
}

void gcpStandaloneApp::SetStatusText(const char* text)
{
	gnome_appbar_set_status(GNOME_APPBAR(m_Bar), text);
}

GtkWindow* gcpStandaloneApp::GetWindow()
{
	return GTK_WINDOW (m_App);
}

void gcpStandaloneApp::AppendUI (BonoboUINode* Node)
{
	while (Node)
	{
		if (!strcmp(bonobo_ui_node_get_name(Node), "dockitem"))
		{
			AddToolbar (Node);
		}
		Node = bonobo_ui_node_next (Node);
	}
	GtkToggleToolButton* button = (GtkToggleToolButton*) ToolItems["Select"];
	if (button && !gtk_toggle_tool_button_get_active (button))
		gtk_toggle_tool_button_set_active (button, true);
	InitTools();
}

void gcpStandaloneApp::AddToolbar (BonoboUINode* Node)
{
	if (!bonobo_ui_node_has_attr (Node, "name")) return;
	if (!bonobo_ui_node_has_attr (Node, "position")) return;
	if (!bonobo_ui_node_has_attr (Node, "band_num")) return;
	char *name = NULL;
	int in_new_band = (bonobo_ui_node_has_attr (Node, "in_new_band"))?
				name = bonobo_ui_node_get_attr (Node, "in_new_band"), *name - '0': 1;
	if (name)
	{
		bonobo_ui_node_free_string (name);
		name = NULL;
	}
	name = bonobo_ui_node_get_attr (Node, "band_num");
	int row = (name)? atoi (name): 0;
	if (name)
	{
		bonobo_ui_node_free_string (name);
		name = NULL;
	}
	name = bonobo_ui_node_get_attr (Node, "band_num");
	int rank = (name)? atoi (name): 0;
	if (name)
	{
		bonobo_ui_node_free_string (name);
		name = NULL;
	}
	name = bonobo_ui_node_get_attr (Node, "name");
	GtkToolbar* toolbar = GTK_TOOLBAR (gtk_toolbar_new());
	Toolbars[name] = (GtkWidget*)toolbar;
	gtk_toolbar_set_show_arrow(toolbar, false);
	gtk_widget_show_all(GTK_WIDGET(toolbar));
	gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_tooltips(GTK_TOOLBAR(toolbar), true);
	gnome_app_add_toolbar(m_App, toolbar, name, BONOBO_DOCK_ITEM_BEH_NORMAL, BONOBO_DOCK_TOP, row, rank, in_new_band);
	if (name)
	{
		bonobo_ui_node_free_string (name);
		name = NULL;
	}
	BonoboUINode* Child = bonobo_ui_node_children (Node);
	GtkToolItem* button;
	int pos;
	while (Child) {
		button = NULL;
		name = (char*) bonobo_ui_node_get_name (Child);
		if (!strcmp (name, "toolitem")) {
			char* type;
			if (bonobo_ui_node_has_attr (Child, "type")) {
				type = bonobo_ui_node_get_attr (Child, "type");
				if (!strcmp (type, "toggle")) {
					button = gtk_toggle_tool_button_new ();
				} else if (!strcmp (type, "radio")) {
					if (bonobo_ui_node_has_attr (Child, "group")) {
						char* group = bonobo_ui_node_get_attr (Child, "group");
						if (Groups[group])
							button = gtk_radio_tool_button_new_from_widget(Groups[group]);
						else {
							Groups[group] = (GtkRadioToolButton*) (button = gtk_radio_tool_button_new (NULL));
						}
						bonobo_ui_node_free_string (group);
					} else
						button = gtk_radio_tool_button_new (NULL);
				} else if (!strcmp (type, "widget")) {
					if (bonobo_ui_node_has_attr (Child, "build")) {
						char* build = bonobo_ui_node_get_attr (Child, "build");
						if (Callbacks[build])
							button = ((GtkToolItem* (*)(gcpApplication*)) Callbacks[build]) (this);
						bonobo_ui_node_free_string (build);
					}
				}
			}
			else button = gtk_tool_button_new (NULL, NULL);
			bonobo_ui_node_free_string (type);
			if (GTK_IS_TOOL_BUTTON (button)) {
				if (bonobo_ui_node_has_attr (Child, "pixtype")) {
					const char* filename = NULL;
					name = bonobo_ui_node_get_attr (Child, "pixtype");
					if (!strcmp (name, "filename")) {
						bonobo_ui_node_free_string (name);
						char* filename = NULL;
						if (bonobo_ui_node_has_attr (Child, "pixname")) {
							name = bonobo_ui_node_get_attr (Child, "pixname");
							filename = g_strconcat (DATADIR"/gchempaint/ui/", name, NULL);
							bonobo_ui_node_free_string (name);
						}
						if (filename) {
							gtk_tool_button_set_icon_widget(GTK_TOOL_BUTTON(button), gtk_image_new_from_file (filename));
							g_free (filename);
						}
					} else if (!strcmp (name, "stock")) {
						bonobo_ui_node_free_string (name);
						if (bonobo_ui_node_has_attr (Child, "pixname")) {
							name = bonobo_ui_node_get_attr (Child, "pixname");
							gtk_tool_button_set_icon_widget(GTK_TOOL_BUTTON(button), gtk_image_new_from_stock (name, GTK_ICON_SIZE_LARGE_TOOLBAR));
							bonobo_ui_node_free_string (name);
						}
					}
				}
				if (bonobo_ui_node_has_attr (Child, "label")) {
					name = bonobo_ui_node_get_attr (Child, "label");
					gtk_tool_button_set_label(GTK_TOOL_BUTTON(button), name);
					bonobo_ui_node_free_string (name);
				}
			}
			if (bonobo_ui_node_has_attr (Child, "verb")) {
				name = bonobo_ui_node_get_attr (Child, "verb");
				if (Callbacks[name])
					g_signal_connect (button, "clicked", Callbacks[name], this);
//				bonobo_ui_node_free_string (name);
			}
			if (bonobo_ui_node_has_attr (Child, "name")) {
				name = bonobo_ui_node_get_attr (Child, "name");
				gtk_widget_set_name(GTK_WIDGET(button), name);
				SetToolItem (name, (GtkWidget*) button);
//				bonobo_ui_node_free_string (name);
			}
			pos = -1;
			if (bonobo_ui_node_has_attr (Child, "pos")) {
				name = bonobo_ui_node_get_attr (Child, "pos");
				if (!strcmp (name, "top")) pos = 0;
				else if (!strcmp (name, "bottom"));
				else pos = atoi (name);
//				bonobo_ui_node_free_string (name);
			}
			if (bonobo_ui_node_has_attr (Child, "tip")) {
				name = bonobo_ui_node_get_attr (Child, "tip");
				gtk_tool_item_set_tooltip (button, toolbar->tooltips, name, NULL);
//				bonobo_ui_node_free_string (name);
			}
			if (pos > (rank = gtk_toolbar_get_n_items (toolbar)))
				pos = rank;
			if (button)
				gtk_toolbar_insert(toolbar, button, pos);
		}
		else if (!strcmp (name, "separator"))
			gtk_toolbar_insert (toolbar, gtk_separator_tool_item_new (), -1);
		Child = bonobo_ui_node_next (Child);
	}
	gtk_widget_show_all(GTK_WIDGET(toolbar));
}

void gcpStandaloneApp::OnProperties()
{
	m_pActiveDoc->OnProperties();
}

void gcpStandaloneApp::OnPrint()
{
	if (!m_pActiveDoc) return;
	GnomePrintConfig* config = gnome_print_config_default();
	GnomePrintContext *pc;// = gnome_print_context_new(config);
	GnomePrintJob *gpj = gnome_print_job_new(config);
	int do_preview, copies = 1, collate = 0;
	GnomePrintDialog *gpd;
	gpd = GNOME_PRINT_DIALOG (gnome_print_dialog_new(gpj, (const guchar*)_("Print"), GNOME_PRINT_DIALOG_COPIES));
	gnome_print_dialog_set_copies(gpd, copies, collate);
	switch (gtk_dialog_run(GTK_DIALOG(gpd)))
	{
	case GNOME_PRINT_DIALOG_RESPONSE_PRINT:
		do_preview = 0;
		break;
	case GNOME_PRINT_DIALOG_RESPONSE_PREVIEW:
		do_preview = 1;
		break;
	case GNOME_PRINT_DIALOG_RESPONSE_CANCEL:
		gtk_widget_destroy (GTK_WIDGET(gpd));
		return;
	}
	gtk_widget_destroy(GTK_WIDGET(gpd));
	pc = gnome_print_job_get_context (gpj);
	gnome_print_beginpage(pc, (const guchar*)"");
	gdouble width, height;
	gnome_print_config_get_page_size(config, &width, &height);
	m_pActiveDoc->Print(pc, width, height);
	gnome_print_showpage(pc);
	g_object_unref(pc);
	gnome_print_job_close(gpj);
	if (do_preview)
	{
		gtk_widget_show (gnome_print_job_preview_new (gpj, (const guchar*)_("Preview")));
	}
	else
	{
		gnome_print_job_print(gpj);
	}
	g_object_unref (gpj);
	gnome_print_config_unref(config);
}

void gcpStandaloneApp::SetActive (gcpDocument* pDoc, GtkWidget* w)
{
	if (pDoc != m_pActiveDoc)
	{
		if (m_pActiveDoc && !m_pActiveDoc->GetView()->PrepareUnselect()) 
		{
			w = m_pActiveDoc->GetView()->GetWidget();
		}
		else
		{
			m_pActiveDoc = pDoc;
			pDoc->SetActive();
		}
		gint i;
		i = gtk_notebook_page_num(m_Book, gtk_widget_get_parent(gtk_widget_get_parent(w)));
		if(i != gtk_notebook_get_current_page(m_Book))
			gtk_notebook_set_current_page(m_Book, i);
	}
}

void gcpStandaloneApp::OnFileClose ()
{
	gcpView* pView = m_pActiveDoc->GetView ();
	pView->PrepareUnselect ();
	gint i;
	i = gtk_notebook_get_current_page (m_Book);
	gtk_notebook_remove_page (m_Book, i);
}

bool gcpStandaloneApp::OnKeyPressed(GtkWidget* widget, GdkEventKey* ev)
{
	gint i = gtk_notebook_get_current_page(m_Book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(m_Book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) return v->OnKeyPress(w, ev);
	return false;
}

bool gcpStandaloneApp::OnKeyReleased(GtkWidget* widget, GdkEventKey* ev)
{
	gint i = gtk_notebook_get_current_page(m_Book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(m_Book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) return v->OnKeyRelease(w, ev);
	return false;
}

void gcpStandaloneApp::OnUndo()
{
	m_pActiveDoc->OnUndo();
}

void gcpStandaloneApp::OnRedo()
{
	m_pActiveDoc->OnRedo();
}

void gcpStandaloneApp::OnSelectAll()
{
	gint i = gtk_notebook_get_current_page(m_Book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(m_Book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) v->OnSelectAll();
}

void gcpStandaloneApp::OnPasteSelection()
{
	gint i = gtk_notebook_get_current_page(m_Book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(m_Book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (v && v->GetDoc()->GetEditable()) v->OnPasteSelection(w, clipboard);
}

void gcpStandaloneApp::OnCutSelection()
{
	gint i = gtk_notebook_get_current_page(m_Book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(m_Book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (v && v->GetDoc()->GetEditable()) v->OnCutSelection(w, clipboard);
}

void gcpStandaloneApp::OnCopySelection()
{
	gint i = gtk_notebook_get_current_page(m_Book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(m_Book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	if (v && v->GetDoc()->GetEditable()) v->OnCopySelection(w, clipboard);
}

void gcpStandaloneApp::OnDeleteSelection()
{
	gint i = gtk_notebook_get_current_page(m_Book);
	GtkWidget* w = gtk_bin_get_child(GTK_BIN(gtk_bin_get_child(GTK_BIN(gtk_notebook_get_nth_page(m_Book, i)))));
	gcpView* v = (gcpView*) g_object_get_data(G_OBJECT(w), "view");
	if (v && v->GetDoc()->GetEditable()) v->OnDeleteSelection(w);
}
